/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl;

import java.util.Set;
import java.util.UUID;
import org.infinispan.commands.CancellableCommand;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.remoting.transport.Address;
import org.infinispan.stream.impl.KeyTrackingTerminalOperation;
import org.infinispan.stream.impl.LocalStreamManager;
import org.infinispan.stream.impl.TerminalOperation;

public class StreamRequestCommand<K>
extends BaseRpcCommand
implements CancellableCommand,
TopologyAffectedCommand {
    public static final byte COMMAND_ID = 47;
    private LocalStreamManager lsm;
    private UUID id;
    private Type type;
    private boolean parallelStream;
    private Set<Integer> segments;
    private Set<K> keys;
    private Set<K> excludedKeys;
    private boolean includeLoader;
    private Object terminalOperation;
    private int topologyId = -1;

    @Override
    public int getTopologyId() {
        return this.topologyId;
    }

    @Override
    public void setTopologyId(int topologyId) {
        this.topologyId = topologyId;
    }

    @Override
    public UUID getUUID() {
        return this.id;
    }

    private StreamRequestCommand() {
        super(null);
    }

    public StreamRequestCommand(String cacheName) {
        super(cacheName);
    }

    public StreamRequestCommand(String cacheName, Address origin, UUID id, boolean parallelStream, Type type, Set<Integer> segments, Set<K> keys, Set<K> excludedKeys, boolean includeLoader, Object terminalOperation) {
        super(cacheName);
        this.setOrigin(origin);
        this.id = id;
        this.parallelStream = parallelStream;
        this.type = type;
        this.segments = segments;
        this.keys = keys;
        this.excludedKeys = excludedKeys;
        this.includeLoader = includeLoader;
        this.terminalOperation = terminalOperation;
    }

    @Inject
    public void inject(LocalStreamManager lsm) {
        this.lsm = lsm;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        switch (this.type) {
            case TERMINAL: {
                this.lsm.streamOperation(this.id, this.getOrigin(), this.parallelStream, this.segments, this.keys, this.excludedKeys, this.includeLoader, (TerminalOperation)this.terminalOperation);
                break;
            }
            case TERMINAL_REHASH: {
                this.lsm.streamOperationRehashAware(this.id, this.getOrigin(), this.parallelStream, this.segments, this.keys, this.excludedKeys, this.includeLoader, (TerminalOperation)this.terminalOperation);
                break;
            }
            case TERMINAL_KEY: {
                this.lsm.streamOperation(this.id, this.getOrigin(), this.parallelStream, this.segments, this.keys, this.excludedKeys, this.includeLoader, (KeyTrackingTerminalOperation)this.terminalOperation);
                break;
            }
            case TERMINAL_KEY_REHASH: {
                this.lsm.streamOperationRehashAware(this.id, this.getOrigin(), this.parallelStream, this.segments, this.keys, this.excludedKeys, this.includeLoader, (KeyTrackingTerminalOperation)this.terminalOperation);
            }
        }
        return null;
    }

    @Override
    public byte getCommandId() {
        return 47;
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.getOrigin(), this.id, this.parallelStream, this.type, this.segments, this.keys, this.excludedKeys, this.includeLoader, this.terminalOperation};
    }

    @Override
    public void setParameters(int commandId, Object[] parameters) {
        int i = 0;
        this.setOrigin((Address)parameters[i++]);
        this.id = (UUID)parameters[i++];
        this.parallelStream = (Boolean)parameters[i++];
        this.type = (Type)((Object)parameters[i++]);
        this.segments = (Set)parameters[i++];
        this.keys = (Set)parameters[i++];
        this.excludedKeys = (Set)parameters[i++];
        this.includeLoader = (Boolean)parameters[i++];
        this.terminalOperation = parameters[i++];
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public boolean canBlock() {
        return true;
    }

    public static enum Type {
        TERMINAL,
        TERMINAL_REHASH,
        TERMINAL_KEY,
        TERMINAL_KEY_REHASH;

    }
}

