/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Version;
import org.jgroups.blocks.AbstractConnectionMap;
import org.jgroups.blocks.Connection;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.DefaultSocketFactory;
import org.jgroups.util.SocketFactory;
import org.jgroups.util.ThreadFactory;
import org.jgroups.util.TimeService;
import org.jgroups.util.Util;

public class TCPConnectionMap {
    protected final Mapper mapper;
    protected final InetAddress bind_addr;
    protected InetAddress client_bind_addr;
    protected int client_bind_port;
    protected boolean defer_client_binding;
    protected final Address local_addr;
    protected final ServerSocket srv_sock;
    protected Receiver recvr;
    protected final long conn_expire_time;
    protected Log log = LogFactory.getLog(this.getClass());
    protected int recv_buf_size = 120000;
    protected int send_buf_size = 60000;
    protected int send_queue_size = 2000;
    protected int sock_conn_timeout = 1000;
    protected int peer_addr_read_timeout = 2000;
    protected boolean tcp_nodelay = false;
    protected int linger = -1;
    protected final Thread acceptor;
    protected final AtomicBoolean running = new AtomicBoolean(false);
    protected volatile boolean use_send_queues = true;
    protected SocketFactory socket_factory = new DefaultSocketFactory();
    protected TimeService time_service;

    public TCPConnectionMap(String service_name, ThreadFactory f, SocketFactory socket_factory, Receiver r, InetAddress bind_addr, InetAddress external_addr, int external_port, int srv_port, int max_port) throws Exception {
        this(service_name, f, socket_factory, r, bind_addr, external_addr, external_port, srv_port, max_port, 0L, 0L);
    }

    public TCPConnectionMap(String service_name, ThreadFactory f, Receiver r, InetAddress bind_addr, InetAddress external_addr, int external_port, int srv_port, int max_port, long reaper_interval, long conn_expire_time) throws Exception {
        this(service_name, f, null, r, bind_addr, external_addr, external_port, srv_port, max_port, reaper_interval, conn_expire_time);
    }

    public TCPConnectionMap(String service_name, ThreadFactory f, SocketFactory socket_factory, Receiver r, InetAddress bind_addr, InetAddress external_addr, int external_port, int srv_port, int max_port, long reaper_interval, long conn_expire_time) throws Exception {
        this.mapper = new Mapper(f, reaper_interval);
        this.recvr = r;
        this.bind_addr = bind_addr;
        this.conn_expire_time = TimeUnit.NANOSECONDS.convert(conn_expire_time, TimeUnit.MILLISECONDS);
        if (socket_factory != null) {
            this.socket_factory = socket_factory;
        }
        this.srv_sock = Util.createServerSocket(this.socket_factory, service_name, bind_addr, srv_port, max_port);
        this.local_addr = external_addr != null ? (external_port <= 0 ? new IpAddress(external_addr, this.srv_sock.getLocalPort()) : new IpAddress(external_addr, external_port)) : (bind_addr != null ? new IpAddress(bind_addr, this.srv_sock.getLocalPort()) : new IpAddress(this.srv_sock.getLocalPort()));
        this.acceptor = f.newThread(new Acceptor(), "ConnectionMap.Acceptor [" + this.local_addr + "]");
    }

    public Address getLocalAddress() {
        return this.local_addr;
    }

    public Receiver getReceiver() {
        return this.recvr;
    }

    public void setReceiver(Receiver receiver) {
        this.recvr = receiver;
    }

    public SocketFactory getSocketFactory() {
        return this.socket_factory;
    }

    public void setSocketFactory(SocketFactory factory) {
        this.socket_factory = factory;
    }

    public InetAddress clientBindAddress() {
        return this.client_bind_addr;
    }

    public TCPConnectionMap clientBindAddress(InetAddress addr) {
        this.client_bind_addr = addr;
        return this;
    }

    public int clientBindPort() {
        return this.client_bind_port;
    }

    public TCPConnectionMap clientBindPort(int port) {
        this.client_bind_port = port;
        return this;
    }

    public boolean deferClientBinding() {
        return this.defer_client_binding;
    }

    public TCPConnectionMap deferClientBinding(boolean defer) {
        this.defer_client_binding = defer;
        return this;
    }

    public void setReceiveBufferSize(int recv_buf_size) {
        this.recv_buf_size = recv_buf_size;
    }

    public void setSocketConnectionTimeout(int timeout) {
        this.sock_conn_timeout = timeout;
    }

    public TCPConnectionMap peerAddressReadTimeout(int timeout) {
        this.peer_addr_read_timeout = timeout;
        return this;
    }

    public TCPConnectionMap timeService(TimeService ts) {
        this.time_service = ts;
        return this;
    }

    public void setSendBufferSize(int send_buf_size) {
        this.send_buf_size = send_buf_size;
    }

    public void setLinger(int linger) {
        this.linger = linger;
    }

    public void setTcpNodelay(boolean tcp_nodelay) {
        this.tcp_nodelay = tcp_nodelay;
    }

    public void setSendQueueSize(int send_queue_size) {
        this.send_queue_size = send_queue_size;
    }

    public void setUseSendQueues(boolean flag) {
        this.use_send_queues = flag;
    }

    public int getNumConnections() {
        return this.mapper.getNumConnections();
    }

    public int getNumOpenConnections() {
        return this.mapper.getNumOpenConnections();
    }

    public boolean connectionEstablishedTo(Address addr) {
        return this.mapper.connectionEstablishedTo(addr);
    }

    public String printConnections() {
        return this.mapper.printConnections();
    }

    public void retainAll(Collection<Address> members) {
        this.mapper.retainAll(members);
    }

    public int getSenderQueueSize() {
        return this.send_queue_size;
    }

    public TCPConnectionMap log(Log new_log) {
        this.log = new_log;
        return this;
    }

    public void addConnectionMapListener(AbstractConnectionMap.ConnectionMapListener<TCPConnection> l) {
        this.mapper.addConnectionMapListener(l);
    }

    public void removeConnectionMapListener(AbstractConnectionMap.ConnectionMapListener<TCPConnection> l) {
        this.mapper.removeConnectionMapListener(l);
    }

    public void receive(Address sender, byte[] data, int offset, int length) {
        this.recvr.receive(sender, data, offset, length);
    }

    public void send(Address dest, byte[] data, int offset, int length) throws Exception {
        if (dest == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error(this.local_addr + ": destination is null");
            }
            return;
        }
        if (data == null) {
            this.log.warn(this.local_addr + ": data is null; discarding message to " + dest);
            return;
        }
        if (!this.running.get()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug(this.local_addr + ": connection table is not running, discarding message to " + dest);
            }
            return;
        }
        if (dest.equals(this.local_addr)) {
            this.receive(this.local_addr, data, offset, length);
            return;
        }
        TCPConnection conn = null;
        try {
            conn = this.mapper.getConnection(dest);
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (conn != null && !conn.isConnected()) {
            Util.sleepRandom(1L, 50L);
            try {
                conn = this.mapper.getConnection(dest);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (conn != null) {
            try {
                conn.send(data, offset, length);
            }
            catch (Exception ex) {
                this.mapper.removeConnectionIfPresent(dest, conn);
                throw ex;
            }
        }
    }

    public void flush(Address destination) throws Exception {
        TCPConnection conn = this.mapper.getConnection(destination);
        if (conn != null) {
            conn.flush();
        }
    }

    public void start() throws Exception {
        if (this.running.compareAndSet(false, true)) {
            this.acceptor.start();
            this.mapper.start();
        }
    }

    public void stop() {
        if (this.running.compareAndSet(true, false)) {
            try {
                this.getSocketFactory().close(this.srv_sock);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Util.interruptAndWaitToDie(this.acceptor);
            this.mapper.stop();
        }
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("local_addr=" + this.local_addr).append("\n");
        ret.append("connections (" + this.mapper.size() + "):\n");
        ret.append(this.mapper.toString());
        ret.append('\n');
        return ret.toString();
    }

    protected void setSocketParameters(Socket client_sock) throws SocketException {
        block6: {
            try {
                client_sock.setSendBufferSize(this.send_buf_size);
            }
            catch (IllegalArgumentException ex) {
                if (!this.log.isErrorEnabled()) break block6;
                this.log.error(this.local_addr + ": exception setting send buffer size to " + this.send_buf_size + " bytes", ex);
            }
        }
        try {
            client_sock.setReceiveBufferSize(this.recv_buf_size);
        }
        catch (IllegalArgumentException ex) {
            this.log.error(this.local_addr + ": exception setting receive buffer size to " + this.send_buf_size + " bytes", ex);
        }
        client_sock.setKeepAlive(true);
        client_sock.setTcpNoDelay(this.tcp_nodelay);
        if (this.linger > 0) {
            client_sock.setSoLinger(true, this.linger);
        } else {
            client_sock.setSoLinger(false, -1);
        }
    }

    protected static String explanation(boolean connection_existed, boolean replace) {
        StringBuilder sb = new StringBuilder();
        if (connection_existed) {
            sb.append(" (connection existed");
            if (replace) {
                sb.append(" but was replaced because my address is lower)");
            } else {
                sb.append(" and my address won as it's higher)");
            }
        } else {
            sb.append(" (connection didn't exist)");
        }
        return sb.toString();
    }

    protected class Mapper
    extends AbstractConnectionMap<TCPConnection> {
        public Mapper(ThreadFactory factory) {
            super(factory);
        }

        public Mapper(ThreadFactory factory, long reaper_interval) {
            super(factory, reaper_interval);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TCPConnection getConnection(Address dest) throws Exception {
            TCPConnection conn;
            this.getLock().lock();
            try {
                conn = (TCPConnection)this.conns.get(dest);
                if (conn != null && conn.isOpen()) {
                    TCPConnection tCPConnection = conn;
                    return tCPConnection;
                }
            }
            finally {
                this.getLock().unlock();
            }
            Exception connect_exception = null;
            this.sock_creation_lock.lockInterruptibly();
            try {
                block27: {
                    this.getLock().lock();
                    try {
                        conn = (TCPConnection)this.conns.get(dest);
                        if (conn != null && conn.isOpen()) {
                            TCPConnection tCPConnection = conn;
                            return tCPConnection;
                        }
                        conn = new TCPConnection(dest);
                        this.addConnection(dest, conn);
                    }
                    finally {
                        this.getLock().unlock();
                    }
                    try {
                        if (TCPConnectionMap.this.log.isTraceEnabled()) {
                            TCPConnectionMap.this.log.trace(TCPConnectionMap.this.local_addr + ": connecting to " + dest);
                        }
                        conn.connect(new InetSocketAddress(((IpAddress)dest).getIpAddress(), ((IpAddress)dest).getPort()));
                        conn.start(this.getThreadFactory());
                        if (TCPConnectionMap.this.log.isTraceEnabled()) {
                            TCPConnectionMap.this.log.trace(TCPConnectionMap.this.local_addr + ": connected to " + dest);
                        }
                    }
                    catch (Exception connect_ex) {
                        connect_exception = connect_ex;
                    }
                    this.getLock().lock();
                    try {
                        TCPConnection existing_conn = (TCPConnection)this.conns.get(dest);
                        if (existing_conn == null || !existing_conn.isOpen() || existing_conn == conn) break block27;
                        if (TCPConnectionMap.this.log.isTraceEnabled()) {
                            TCPConnectionMap.this.log.trace(TCPConnectionMap.this.local_addr + ": found existing connection to " + dest + ", using it and deleting own conn-stub");
                        }
                        Util.close((Closeable)conn);
                        TCPConnection tCPConnection = existing_conn;
                        this.getLock().unlock();
                        return tCPConnection;
                    }
                    catch (Throwable throwable) {
                        this.getLock().unlock();
                        throw throwable;
                    }
                }
                if (connect_exception != null) {
                    if (TCPConnectionMap.this.log.isTraceEnabled()) {
                        TCPConnectionMap.this.log.trace(TCPConnectionMap.this.local_addr + ": failed connecting to " + dest + ": " + connect_exception);
                    }
                    this.removeConnectionIfPresent(dest, conn);
                    throw connect_exception;
                }
                TCPConnection tCPConnection = conn;
                this.getLock().unlock();
                return tCPConnection;
            }
            finally {
                this.sock_creation_lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean connectionEstablishedTo(Address address) {
            this.lock.lock();
            try {
                TCPConnection conn = (TCPConnection)this.conns.get(address);
                boolean bl = conn != null && conn.isConnected();
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        public int size() {
            return this.conns.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.getLock().lock();
            try {
                for (Map.Entry entry : this.conns.entrySet()) {
                    sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
                }
                String string = sb.toString();
                return string;
            }
            finally {
                this.getLock().unlock();
            }
        }
    }

    public class TCPConnection
    implements Connection {
        protected final Socket sock;
        protected final ReentrantLock send_lock = new ReentrantLock();
        protected final byte[] cookie = new byte[]{98, 101, 108, 97};
        protected DataOutputStream out;
        protected DataInputStream in;
        protected Address peer_addr;
        protected long last_access = this.getTimestamp();
        protected Sender sender;
        protected Receiver receiver;

        public TCPConnection(Address peer_addr) throws Exception {
            if (peer_addr == null) {
                throw new IllegalArgumentException("Invalid parameter peer_addr=" + peer_addr);
            }
            this.peer_addr = peer_addr;
            this.sock = TCPConnectionMap.this.socket_factory.createSocket("jgroups.tcp.sock");
            TCPConnectionMap.this.setSocketParameters(this.sock);
        }

        public TCPConnection(Socket s) throws Exception {
            if (s == null) {
                throw new IllegalArgumentException("Invalid parameter s=" + s);
            }
            TCPConnectionMap.this.setSocketParameters(s);
            this.out = new DataOutputStream(new BufferedOutputStream(s.getOutputStream()));
            this.in = new DataInputStream(new BufferedInputStream(s.getInputStream()));
            this.peer_addr = this.readPeerAddress(s);
            this.sock = s;
        }

        protected long getTimestamp() {
            return TCPConnectionMap.this.time_service != null ? TCPConnectionMap.this.time_service.timestamp() : System.nanoTime();
        }

        protected Address getPeerAddress() {
            return this.peer_addr;
        }

        protected boolean isSenderUsed() {
            return TCPConnectionMap.this.getSenderQueueSize() > 0 && TCPConnectionMap.this.use_send_queues;
        }

        protected String getSockAddress() {
            StringBuilder sb = new StringBuilder();
            if (this.sock != null) {
                sb.append(this.sock.getLocalAddress().getHostAddress()).append(':').append(this.sock.getLocalPort());
                sb.append(" - ").append(this.sock.getInetAddress().getHostAddress()).append(':').append(this.sock.getPort());
            }
            return sb.toString();
        }

        protected void updateLastAccessed() {
            if (TCPConnectionMap.this.conn_expire_time > 0L) {
                this.last_access = this.getTimestamp();
            }
        }

        protected void connect(SocketAddress destAddr) throws Exception {
            try {
                if (!TCPConnectionMap.this.defer_client_binding) {
                    this.sock.bind(new InetSocketAddress(TCPConnectionMap.this.client_bind_addr, TCPConnectionMap.this.client_bind_port));
                }
                if (this.sock.getLocalSocketAddress() != null && this.sock.getLocalSocketAddress().equals(destAddr)) {
                    throw new IllegalStateException("socket's bind and connect address are the same: " + destAddr);
                }
                Util.connect(this.sock, destAddr, TCPConnectionMap.this.sock_conn_timeout);
                this.out = new DataOutputStream(new BufferedOutputStream(this.sock.getOutputStream()));
                this.in = new DataInputStream(new BufferedInputStream(this.sock.getInputStream()));
                this.sendLocalAddress(TCPConnectionMap.this.getLocalAddress());
            }
            catch (Exception t) {
                TCPConnectionMap.this.socket_factory.close(this.sock);
                throw t;
            }
        }

        protected TCPConnection start(ThreadFactory f) {
            if (this.receiver != null) {
                this.receiver.stop();
            }
            this.receiver = new Receiver(f).start();
            if (this.isSenderUsed()) {
                if (this.sender != null) {
                    this.sender.stop();
                }
                this.sender = new Sender(f, TCPConnectionMap.this.getSenderQueueSize()).start();
            }
            return this;
        }

        protected void send(byte[] data, int offset, int length) throws Exception {
            if (this.sender != null) {
                byte[] tmp = new byte[length];
                System.arraycopy(data, offset, tmp, 0, length);
                this.sender.addToQueue(tmp);
            } else {
                this._send(data, offset, length, true, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void _send(byte[] data, int offset, int length, boolean acquire_lock, boolean flush) throws Exception {
            if (acquire_lock) {
                this.send_lock.lock();
            }
            try {
                this.doSend(data, offset, length, acquire_lock, flush);
                this.updateLastAccessed();
            }
            catch (InterruptedException iex) {
                Thread.currentThread().interrupt();
            }
            finally {
                if (acquire_lock) {
                    this.send_lock.unlock();
                }
            }
        }

        protected void doSend(byte[] data, int offset, int length, boolean acquire_lock, boolean flush) throws Exception {
            this.out.writeInt(length);
            this.out.write(data, offset, length);
            if (!flush || acquire_lock && this.send_lock.hasQueuedThreads()) {
                return;
            }
            this.out.flush();
        }

        protected void flush() throws Exception {
            if (this.out != null) {
                this.out.flush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Address readPeerAddress(Socket client_sock) throws Exception {
            int timeout = client_sock.getSoTimeout();
            client_sock.setSoTimeout(TCPConnectionMap.this.peer_addr_read_timeout);
            try {
                byte[] input_cookie = new byte[this.cookie.length];
                this.in.readFully(input_cookie, 0, input_cookie.length);
                if (!this.matchCookie(input_cookie)) {
                    throw new SocketException("ConnectionMap.Connection.readPeerAddress(): cookie read by " + TCPConnectionMap.this.getLocalAddress() + " does not match own cookie; terminating connection");
                }
                short version = this.in.readShort();
                if (!Version.isBinaryCompatible(version)) {
                    throw new IOException("packet from " + client_sock.getInetAddress() + ":" + client_sock.getPort() + " has different version (" + Version.print(version) + ") from ours (" + Version.printVersion() + "); discarding it");
                }
                IpAddress client_peer_addr = new IpAddress();
                client_peer_addr.readFrom(this.in);
                this.updateLastAccessed();
                IpAddress ipAddress = client_peer_addr;
                return ipAddress;
            }
            finally {
                client_sock.setSoTimeout(timeout);
            }
        }

        protected void sendLocalAddress(Address local_addr) throws Exception {
            this.out.write(this.cookie, 0, this.cookie.length);
            this.out.writeShort(Version.version);
            local_addr.writeTo(this.out);
            this.out.flush();
            this.updateLastAccessed();
        }

        protected boolean matchCookie(byte[] input) {
            if (input == null || input.length < this.cookie.length) {
                return false;
            }
            for (int i = 0; i < this.cookie.length; ++i) {
                if (this.cookie[i] == input[i]) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            StringBuilder ret = new StringBuilder();
            InetAddress local = null;
            InetAddress remote = null;
            Socket tmp_sock = this.sock;
            if (tmp_sock == null) {
                ret.append("<null socket>");
            } else {
                local = tmp_sock.getLocalAddress();
                remote = tmp_sock.getInetAddress();
                String local_str = local != null ? Util.shortName(local) : "<null>";
                String remote_str = remote != null ? Util.shortName(remote) : "<null>";
                ret.append('<' + local_str + ':' + tmp_sock.getLocalPort() + " --> " + remote_str + ':' + tmp_sock.getPort() + "> (" + TimeUnit.SECONDS.convert(this.getTimestamp() - this.last_access, TimeUnit.NANOSECONDS) + " secs old) [" + (this.isOpen() ? "open]" : "closed]"));
            }
            tmp_sock = null;
            return ret.toString();
        }

        @Override
        public boolean isExpired(long now) {
            return TCPConnectionMap.this.conn_expire_time > 0L && now - this.last_access >= TCPConnectionMap.this.conn_expire_time;
        }

        public boolean isConnected() {
            return !this.sock.isClosed() && this.sock.isConnected();
        }

        @Override
        public boolean isOpen() {
            return this.isConnected() && (!this.isSenderUsed() || this.sender.isRunning()) && this.receiver != null && this.receiver.isRunning();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            this.send_lock.lock();
            try {
                if (this.receiver != null) {
                    this.receiver.stop();
                    this.receiver = null;
                }
                if (this.sender != null) {
                    this.sender.stop();
                    this.sender = null;
                }
                try {
                    TCPConnectionMap.this.socket_factory.close(this.sock);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                Util.close((Closeable)this.out);
                Util.close((Closeable)this.in);
            }
            finally {
                this.send_lock.unlock();
            }
            TCPConnectionMap.this.mapper.notifyConnectionClosed(this.peer_addr);
        }

        protected class Sender
        implements Runnable {
            protected final BlockingQueue<byte[]> send_queue;
            protected final Thread runner;
            protected volatile boolean started = true;

            public Sender(ThreadFactory tf, int send_queue_size) {
                this.runner = tf.newThread(this, "Connection.Sender [" + TCPConnection.this.getSockAddress() + "]");
                this.send_queue = new LinkedBlockingQueue<byte[]>(send_queue_size);
            }

            public void addToQueue(byte[] data) throws Exception {
                if (this.canRun() && !this.send_queue.offer(data, TCPConnectionMap.this.sock_conn_timeout, TimeUnit.MILLISECONDS)) {
                    TCPConnectionMap.this.log.warn("Discarding message because TCP send_queue is full and hasn't been releasing for " + TCPConnectionMap.this.sock_conn_timeout + " ms");
                }
            }

            public Sender start() {
                this.started = true;
                this.runner.start();
                return this;
            }

            public Sender stop() {
                this.started = false;
                this.runner.interrupt();
                return this;
            }

            public boolean isRunning() {
                return this.started;
            }

            public boolean canRun() {
                return this.isRunning() && TCPConnection.this.isConnected();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block9: {
                    block7: while (true) {
                        while (!Thread.currentThread().isInterrupted() && this.canRun()) {
                            byte[] data = null;
                            try {
                                data = this.send_queue.take();
                            }
                            catch (InterruptedException e) {
                                break block9;
                            }
                            if (data == null) continue;
                            try {
                                TCPConnection.this._send(data, 0, data.length, false, this.send_queue.isEmpty());
                                continue block7;
                            }
                            catch (Throwable throwable) {
                            }
                        }
                        break block9;
                        {
                            continue block7;
                            break;
                        }
                        break;
                    }
                    finally {
                        TCPConnectionMap.this.mapper.removeConnectionIfPresent(TCPConnection.this.peer_addr, TCPConnection.this);
                    }
                }
            }
        }

        protected class Receiver
        implements Runnable {
            protected final Thread recv;
            protected volatile boolean receiving = true;

            public Receiver(ThreadFactory f) {
                this.recv = f.newThread(this, "Connection.Receiver [" + TCPConnection.this.getSockAddress() + "]");
            }

            public Receiver start() {
                this.receiving = true;
                this.recv.start();
                return this;
            }

            public Receiver stop() {
                this.receiving = false;
                this.recv.interrupt();
                return this;
            }

            public boolean isRunning() {
                return this.receiving;
            }

            public boolean canRun() {
                return this.isRunning() && TCPConnection.this.isConnected();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    while (!Thread.currentThread().isInterrupted() && this.canRun()) {
                        try {
                            int len = TCPConnection.this.in.readInt();
                            byte[] buf = new byte[len];
                            TCPConnection.this.in.readFully(buf, 0, len);
                            TCPConnection.this.updateLastAccessed();
                            TCPConnectionMap.this.recvr.receive(TCPConnection.this.peer_addr, buf, 0, len);
                        }
                        catch (OutOfMemoryError mem_ex) {
                            break;
                        }
                        catch (IOException io_ex) {
                            break;
                        }
                        catch (Throwable throwable) {
                        }
                    }
                }
                finally {
                    TCPConnectionMap.this.mapper.removeConnectionIfPresent(TCPConnection.this.peer_addr, TCPConnection.this);
                }
            }
        }
    }

    protected class Acceptor
    implements Runnable {
        protected Acceptor() {
        }

        @Override
        public void run() {
            while (!TCPConnectionMap.this.srv_sock.isClosed() && !Thread.currentThread().isInterrupted()) {
                Socket client_sock = null;
                try {
                    client_sock = TCPConnectionMap.this.srv_sock.accept();
                    this.handleAccept(client_sock);
                }
                catch (Exception ex) {
                    if (ex instanceof SocketException && TCPConnectionMap.this.srv_sock.isClosed() || Thread.currentThread().isInterrupted()) break;
                    if (TCPConnectionMap.this.log.isWarnEnabled()) {
                        TCPConnectionMap.this.log.warn(Util.getMessage("AcceptError"), ex);
                    }
                    Util.close(client_sock);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleAccept(Socket client_sock) throws Exception {
            TCPConnection conn = null;
            try {
                conn = new TCPConnection(client_sock);
                Address peer_addr = conn.getPeerAddress();
                if (TCPConnectionMap.this.log.isTraceEnabled()) {
                    TCPConnectionMap.this.log.trace(TCPConnectionMap.this.local_addr + ": " + peer_addr + " trying to connect to me");
                }
                TCPConnectionMap.this.mapper.getLock().lock();
                try {
                    boolean replace;
                    boolean conn_exists = TCPConnectionMap.this.mapper.hasConnection(peer_addr);
                    boolean bl = replace = conn_exists && TCPConnectionMap.this.local_addr.compareTo(peer_addr) < 0;
                    if (!conn_exists || replace) {
                        TCPConnectionMap.this.mapper.addConnection(peer_addr, conn);
                        conn.start(TCPConnectionMap.this.mapper.getThreadFactory());
                        if (TCPConnectionMap.this.log.isTraceEnabled()) {
                            TCPConnectionMap.this.log.trace(TCPConnectionMap.this.local_addr + ": accepted connection from " + peer_addr + TCPConnectionMap.explanation(conn_exists, replace));
                        }
                    } else {
                        if (TCPConnectionMap.this.log.isTraceEnabled()) {
                            TCPConnectionMap.this.log.trace(TCPConnectionMap.this.local_addr + ": rejected connection from " + peer_addr + TCPConnectionMap.explanation(conn_exists, replace));
                        }
                        Util.close((Closeable)conn);
                    }
                }
                finally {
                    TCPConnectionMap.this.mapper.getLock().unlock();
                }
            }
            catch (Exception ex) {
                Util.close(conn);
                throw ex;
            }
        }
    }

    public static interface Receiver {
        public void receive(Address var1, byte[] var2, int var3, int var4);
    }
}

