/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.PropertyValueException;
import org.hibernate.action.internal.AbstractEntityInsertAction;
import org.hibernate.action.internal.BulkOperationCleanupAction;
import org.hibernate.action.internal.CollectionRecreateAction;
import org.hibernate.action.internal.CollectionRemoveAction;
import org.hibernate.action.internal.CollectionUpdateAction;
import org.hibernate.action.internal.EntityDeleteAction;
import org.hibernate.action.internal.EntityIdentityInsertAction;
import org.hibernate.action.internal.EntityInsertAction;
import org.hibernate.action.internal.EntityUpdateAction;
import org.hibernate.action.internal.OrphanRemovalAction;
import org.hibernate.action.internal.QueuedOperationCollectionAction;
import org.hibernate.action.internal.UnresolvedEntityInsertActions;
import org.hibernate.action.spi.AfterTransactionCompletionProcess;
import org.hibernate.action.spi.BeforeTransactionCompletionProcess;
import org.hibernate.action.spi.Executable;
import org.hibernate.cache.CacheException;
import org.hibernate.engine.internal.NonNullableTransientDependencies;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ExecutableList;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.type.Type;

public class ActionQueue {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(ActionQueue.class);
    private SessionImplementor session;
    private UnresolvedEntityInsertActions unresolvedInsertions;
    private ExecutableList<AbstractEntityInsertAction> insertions;
    private ExecutableList<EntityDeleteAction> deletions;
    private ExecutableList<EntityUpdateAction> updates;
    private ExecutableList<CollectionRecreateAction> collectionCreations;
    private ExecutableList<CollectionUpdateAction> collectionUpdates;
    private ExecutableList<QueuedOperationCollectionAction> collectionQueuedOps;
    private ExecutableList<CollectionRemoveAction> collectionRemovals;
    private ExecutableList<OrphanRemovalAction> orphanRemovals;
    private transient boolean isTransactionCoordinatorShared;
    private AfterTransactionCompletionProcessQueue afterTransactionProcesses;
    private BeforeTransactionCompletionProcessQueue beforeTransactionProcesses;
    private static final ListProvider[] EXECUTABLE_LISTS = new ListProvider[8];

    public ActionQueue(SessionImplementor session) {
        this.session = session;
        this.isTransactionCoordinatorShared = false;
    }

    public void clear() {
        for (int i = 0; i < EXECUTABLE_LISTS.length; ++i) {
            ExecutableList<?> l = EXECUTABLE_LISTS[i].get(this);
            if (l == null) continue;
            l.clear();
        }
        if (this.unresolvedInsertions != null) {
            this.unresolvedInsertions.clear();
        }
    }

    public void addAction(EntityInsertAction action) {
        LOG.tracev("Adding an EntityInsertAction for [{0}] object", action.getEntityName());
        this.addInsertAction(action);
    }

    private void addInsertAction(AbstractEntityInsertAction insert) {
        NonNullableTransientDependencies nonNullableTransientDependencies;
        if (insert.isEarlyInsert()) {
            LOG.tracev("Executing inserts beforeQuery finding non-nullable transient entities for early insert: [{0}]", insert);
            this.executeInserts();
        }
        if ((nonNullableTransientDependencies = insert.findNonNullableTransientEntities()) == null) {
            LOG.tracev("Adding insert with no non-nullable, transient entities: [{0}]", insert);
            this.addResolvedEntityInsertAction(insert);
        } else {
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Adding insert with non-nullable, transient entities; insert=[{0}], dependencies=[{1}]", insert, nonNullableTransientDependencies.toLoggableString(insert.getSession()));
            }
            if (this.unresolvedInsertions == null) {
                this.unresolvedInsertions = new UnresolvedEntityInsertActions();
            }
            this.unresolvedInsertions.addUnresolvedEntityInsertAction(insert, nonNullableTransientDependencies);
        }
    }

    private void addResolvedEntityInsertAction(AbstractEntityInsertAction insert) {
        if (insert.isEarlyInsert()) {
            LOG.trace("Executing insertions beforeQuery resolved early-insert");
            this.executeInserts();
            LOG.debug("Executing identity-insert immediately");
            this.execute(insert);
        } else {
            LOG.trace("Adding resolved non-early insert action.");
            if (this.insertions == null) {
                this.insertions = new ExecutableList<AbstractEntityInsertAction>(new InsertActionSorter());
            }
            this.insertions.add(insert);
        }
        insert.makeEntityManaged();
        if (this.unresolvedInsertions != null) {
            for (AbstractEntityInsertAction resolvedAction : this.unresolvedInsertions.resolveDependentActions(insert.getInstance(), this.session)) {
                this.addResolvedEntityInsertAction(resolvedAction);
            }
        }
    }

    public void addAction(EntityIdentityInsertAction action) {
        LOG.tracev("Adding an EntityIdentityInsertAction for [{0}] object", action.getEntityName());
        this.addInsertAction(action);
    }

    public void addAction(EntityDeleteAction action) {
        if (this.deletions == null) {
            this.deletions = new ExecutableList();
        }
        this.deletions.add(action);
    }

    public void addAction(OrphanRemovalAction action) {
        if (this.orphanRemovals == null) {
            this.orphanRemovals = new ExecutableList();
        }
        this.orphanRemovals.add(action);
    }

    public void addAction(EntityUpdateAction action) {
        if (this.updates == null) {
            this.updates = new ExecutableList();
        }
        this.updates.add(action);
    }

    public void addAction(CollectionRecreateAction action) {
        if (this.collectionCreations == null) {
            this.collectionCreations = new ExecutableList();
        }
        this.collectionCreations.add(action);
    }

    public void addAction(CollectionRemoveAction action) {
        if (this.collectionRemovals == null) {
            this.collectionRemovals = new ExecutableList();
        }
        this.collectionRemovals.add(action);
    }

    public void addAction(CollectionUpdateAction action) {
        if (this.collectionUpdates == null) {
            this.collectionUpdates = new ExecutableList();
        }
        this.collectionUpdates.add(action);
    }

    public void addAction(QueuedOperationCollectionAction action) {
        if (this.collectionQueuedOps == null) {
            this.collectionQueuedOps = new ExecutableList();
        }
        this.collectionQueuedOps.add(action);
    }

    public void addAction(BulkOperationCleanupAction action) {
        this.registerCleanupActions(action);
    }

    private void registerCleanupActions(Executable executable) {
        if (executable.getBeforeTransactionCompletionProcess() != null) {
            if (this.beforeTransactionProcesses == null) {
                this.beforeTransactionProcesses = new BeforeTransactionCompletionProcessQueue(this.session);
            }
            this.beforeTransactionProcesses.register(executable.getBeforeTransactionCompletionProcess());
        }
        if (this.session.getFactory().getSessionFactoryOptions().isQueryCacheEnabled()) {
            this.invalidateSpaces(executable.getPropertySpaces());
        }
        if (executable.getAfterTransactionCompletionProcess() != null) {
            if (this.afterTransactionProcesses == null) {
                this.afterTransactionProcesses = new AfterTransactionCompletionProcessQueue(this.session);
            }
            this.afterTransactionProcesses.register(executable.getAfterTransactionCompletionProcess());
        }
    }

    public boolean hasUnresolvedEntityInsertActions() {
        return this.unresolvedInsertions != null && !this.unresolvedInsertions.isEmpty();
    }

    public void checkNoUnresolvedActionsAfterOperation() throws PropertyValueException {
        if (this.unresolvedInsertions != null) {
            this.unresolvedInsertions.checkNoUnresolvedActionsAfterOperation();
        }
    }

    public void registerProcess(AfterTransactionCompletionProcess process) {
        if (this.afterTransactionProcesses == null) {
            this.afterTransactionProcesses = new AfterTransactionCompletionProcessQueue(this.session);
        }
        this.afterTransactionProcesses.register(process);
    }

    public void registerProcess(BeforeTransactionCompletionProcess process) {
        if (this.beforeTransactionProcesses == null) {
            this.beforeTransactionProcesses = new BeforeTransactionCompletionProcessQueue(this.session);
        }
        this.beforeTransactionProcesses.register(process);
    }

    public void executeInserts() throws HibernateException {
        if (this.insertions != null && !this.insertions.isEmpty()) {
            this.executeActions(this.insertions);
        }
    }

    public void executeActions() throws HibernateException {
        if (this.hasUnresolvedEntityInsertActions()) {
            throw new IllegalStateException("About to execute actions, but there are unresolved entity insert actions.");
        }
        for (int i = 0; i < EXECUTABLE_LISTS.length; ++i) {
            ExecutableList<?> l = EXECUTABLE_LISTS[i].get(this);
            if (l == null || l.isEmpty()) continue;
            this.executeActions(l);
        }
    }

    public void prepareActions() throws HibernateException {
        this.prepareActions(this.collectionRemovals);
        this.prepareActions(this.collectionUpdates);
        this.prepareActions(this.collectionCreations);
        this.prepareActions(this.collectionQueuedOps);
    }

    private void prepareActions(ExecutableList<?> queue) throws HibernateException {
        if (queue == null) {
            return;
        }
        for (Executable executable : queue) {
            executable.beforeExecutions();
        }
    }

    public void afterTransactionCompletion(boolean success) {
        if (!this.isTransactionCoordinatorShared && this.afterTransactionProcesses != null) {
            this.afterTransactionProcesses.afterTransactionCompletion(success);
        }
    }

    public void beforeTransactionCompletion() {
        if (!this.isTransactionCoordinatorShared && this.beforeTransactionProcesses != null) {
            this.beforeTransactionProcesses.beforeTransactionCompletion();
        }
    }

    public boolean areInsertionsOrDeletionsQueued() {
        return this.insertions != null && !this.insertions.isEmpty() || this.hasUnresolvedEntityInsertActions() || this.deletions != null && !this.deletions.isEmpty() || this.orphanRemovals != null && !this.orphanRemovals.isEmpty();
    }

    public boolean areTablesToBeUpdated(Set tables) {
        if (tables.isEmpty()) {
            return false;
        }
        for (int i = 0; i < EXECUTABLE_LISTS.length; ++i) {
            ExecutableList<?> l = EXECUTABLE_LISTS[i].get(this);
            if (!ActionQueue.areTablesToBeUpdated(l, tables)) continue;
            return true;
        }
        if (this.unresolvedInsertions == null) {
            return false;
        }
        return ActionQueue.areTablesToBeUpdated(this.unresolvedInsertions, tables);
    }

    private static boolean areTablesToBeUpdated(ExecutableList<?> actions, Set tableSpaces) {
        if (actions == null || actions.isEmpty()) {
            return false;
        }
        for (Serializable actionSpace : actions.getQuerySpaces()) {
            if (!tableSpaces.contains(actionSpace)) continue;
            LOG.debugf("Changes must be flushed to space: %s", actionSpace);
            return true;
        }
        return false;
    }

    private static boolean areTablesToBeUpdated(UnresolvedEntityInsertActions actions, Set tableSpaces) {
        for (Executable executable : actions.getDependentEntityInsertActions()) {
            Serializable[] spaces;
            for (Serializable space : spaces = executable.getPropertySpaces()) {
                if (!tableSpaces.contains(space)) continue;
                LOG.debugf("Changes must be flushed to space: %s", space);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E extends Executable & Comparable<?>> void executeActions(ExecutableList<E> list) throws HibernateException {
        try {
            for (Executable e : list) {
                try {
                    e.execute();
                }
                finally {
                    if (e.getBeforeTransactionCompletionProcess() != null) {
                        if (this.beforeTransactionProcesses == null) {
                            this.beforeTransactionProcesses = new BeforeTransactionCompletionProcessQueue(this.session);
                        }
                        this.beforeTransactionProcesses.register(e.getBeforeTransactionCompletionProcess());
                    }
                    if (e.getAfterTransactionCompletionProcess() == null) continue;
                    if (this.afterTransactionProcesses == null) {
                        this.afterTransactionProcesses = new AfterTransactionCompletionProcessQueue(this.session);
                    }
                    this.afterTransactionProcesses.register(e.getAfterTransactionCompletionProcess());
                }
            }
        }
        finally {
            if (this.session.getFactory().getSessionFactoryOptions().isQueryCacheEnabled()) {
                Set<Serializable> propertySpaces = list.getQuerySpaces();
                this.invalidateSpaces(propertySpaces.toArray(new Serializable[propertySpaces.size()]));
            }
        }
        list.clear();
        this.session.getJdbcCoordinator().executeBatch();
    }

    public <E extends Executable & Comparable<?>> void execute(E executable) {
        try {
            executable.execute();
        }
        finally {
            this.registerCleanupActions(executable);
        }
    }

    private void invalidateSpaces(Serializable ... spaces) {
        if (spaces != null && spaces.length > 0) {
            for (Serializable s : spaces) {
                if (this.afterTransactionProcesses == null) {
                    this.afterTransactionProcesses = new AfterTransactionCompletionProcessQueue(this.session);
                }
                this.afterTransactionProcesses.addSpaceToInvalidate((String)((Object)s));
            }
            this.session.getFactory().getUpdateTimestampsCache().preInvalidate(spaces, this.session);
        }
    }

    public String toString() {
        return "ActionQueue[insertions=" + ActionQueue.toString(this.insertions) + " updates=" + ActionQueue.toString(this.updates) + " deletions=" + ActionQueue.toString(this.deletions) + " orphanRemovals=" + ActionQueue.toString(this.orphanRemovals) + " collectionCreations=" + ActionQueue.toString(this.collectionCreations) + " collectionRemovals=" + ActionQueue.toString(this.collectionRemovals) + " collectionUpdates=" + ActionQueue.toString(this.collectionUpdates) + " collectionQueuedOps=" + ActionQueue.toString(this.collectionQueuedOps) + " unresolvedInsertDependencies=" + this.unresolvedInsertions + "]";
    }

    private static String toString(ExecutableList q) {
        return q == null ? "ExecutableList{size=0}" : q.toString();
    }

    public int numberOfCollectionRemovals() {
        if (this.collectionRemovals == null) {
            return 0;
        }
        return this.collectionRemovals.size();
    }

    public int numberOfCollectionUpdates() {
        if (this.collectionUpdates == null) {
            return 0;
        }
        return this.collectionUpdates.size();
    }

    public int numberOfCollectionCreations() {
        if (this.collectionCreations == null) {
            return 0;
        }
        return this.collectionCreations.size();
    }

    public int numberOfDeletions() {
        int del = this.deletions == null ? 0 : this.deletions.size();
        int orph = this.orphanRemovals == null ? 0 : this.orphanRemovals.size();
        return del + orph;
    }

    public int numberOfUpdates() {
        if (this.updates == null) {
            return 0;
        }
        return this.updates.size();
    }

    public int numberOfInsertions() {
        if (this.insertions == null) {
            return 0;
        }
        return this.insertions.size();
    }

    public TransactionCompletionProcesses getTransactionCompletionProcesses() {
        if (this.beforeTransactionProcesses == null) {
            this.beforeTransactionProcesses = new BeforeTransactionCompletionProcessQueue(this.session);
        }
        if (this.afterTransactionProcesses == null) {
            this.afterTransactionProcesses = new AfterTransactionCompletionProcessQueue(this.session);
        }
        return new TransactionCompletionProcesses(this.beforeTransactionProcesses, this.afterTransactionProcesses);
    }

    public void setTransactionCompletionProcesses(TransactionCompletionProcesses processes, boolean isTransactionCoordinatorShared) {
        this.isTransactionCoordinatorShared = isTransactionCoordinatorShared;
        this.beforeTransactionProcesses = processes.beforeTransactionCompletionProcesses;
        this.afterTransactionProcesses = processes.afterTransactionCompletionProcesses;
    }

    public void sortCollectionActions() {
        if (this.session.getFactory().getSessionFactoryOptions().isOrderUpdatesEnabled()) {
            if (this.collectionCreations != null) {
                this.collectionCreations.sort();
            }
            if (this.collectionUpdates != null) {
                this.collectionUpdates.sort();
            }
            if (this.collectionQueuedOps != null) {
                this.collectionQueuedOps.sort();
            }
            if (this.collectionRemovals != null) {
                this.collectionRemovals.sort();
            }
        }
    }

    public void sortActions() {
        if (this.session.getFactory().getSessionFactoryOptions().isOrderUpdatesEnabled() && this.updates != null) {
            this.updates.sort();
        }
        if (this.session.getFactory().getSessionFactoryOptions().isOrderInsertsEnabled() && this.insertions != null) {
            this.insertions.sort();
        }
    }

    public void clearFromFlushNeededCheck(int previousCollectionRemovalSize) {
        if (this.collectionCreations != null) {
            this.collectionCreations.clear();
        }
        if (this.collectionUpdates != null) {
            this.collectionUpdates.clear();
        }
        if (this.collectionQueuedOps != null) {
            this.collectionQueuedOps.clear();
        }
        if (this.updates != null) {
            this.updates.clear();
        }
        if (this.collectionRemovals != null && this.collectionRemovals.size() > previousCollectionRemovalSize) {
            this.collectionRemovals.removeLastN(this.collectionRemovals.size() - previousCollectionRemovalSize);
        }
    }

    public boolean hasAfterTransactionActions() {
        return this.isTransactionCoordinatorShared ? false : this.afterTransactionProcesses != null && this.afterTransactionProcesses.hasActions();
    }

    public boolean hasBeforeTransactionActions() {
        return this.isTransactionCoordinatorShared ? false : this.beforeTransactionProcesses != null && this.beforeTransactionProcesses.hasActions();
    }

    public boolean hasAnyQueuedActions() {
        return this.updates != null && !this.updates.isEmpty() || this.insertions != null && !this.insertions.isEmpty() || this.hasUnresolvedEntityInsertActions() || this.deletions != null && !this.deletions.isEmpty() || this.collectionUpdates != null && !this.collectionUpdates.isEmpty() || this.collectionQueuedOps != null && !this.collectionQueuedOps.isEmpty() || this.collectionRemovals != null && !this.collectionRemovals.isEmpty() || this.collectionCreations != null && !this.collectionCreations.isEmpty();
    }

    public void unScheduleDeletion(EntityEntry entry, Object rescuedEntity) {
        EntityDeleteAction action;
        LazyInitializer initializer;
        if (rescuedEntity instanceof HibernateProxy && !(initializer = ((HibernateProxy)rescuedEntity).getHibernateLazyInitializer()).isUninitialized()) {
            rescuedEntity = initializer.getImplementation(this.session);
        }
        if (this.deletions != null) {
            for (int i = 0; i < this.deletions.size(); ++i) {
                action = this.deletions.get(i);
                if (action.getInstance() != rescuedEntity) continue;
                this.deletions.remove(i);
                return;
            }
        }
        if (this.orphanRemovals != null) {
            for (int i = 0; i < this.orphanRemovals.size(); ++i) {
                action = this.orphanRemovals.get(i);
                if (action.getInstance() != rescuedEntity) continue;
                this.orphanRemovals.remove(i);
                return;
            }
        }
        throw new AssertionFailure("Unable to perform un-delete for instance " + entry.getEntityName());
    }

    public void serialize(ObjectOutputStream oos) throws IOException {
        LOG.trace("Serializing action-queue");
        if (this.unresolvedInsertions == null) {
            this.unresolvedInsertions = new UnresolvedEntityInsertActions();
        }
        this.unresolvedInsertions.serialize(oos);
        for (ListProvider p : EXECUTABLE_LISTS) {
            ExecutableList<?> l = p.get(this);
            if (l == null) {
                oos.writeBoolean(false);
                continue;
            }
            oos.writeBoolean(true);
            l.writeExternal(oos);
        }
    }

    public static ActionQueue deserialize(ObjectInputStream ois, SessionImplementor session) throws IOException, ClassNotFoundException {
        boolean traceEnabled = LOG.isTraceEnabled();
        if (traceEnabled) {
            LOG.trace("Deserializing action-queue");
        }
        ActionQueue rtn = new ActionQueue(session);
        rtn.unresolvedInsertions = UnresolvedEntityInsertActions.deserialize(ois, session);
        for (int i = 0; i < EXECUTABLE_LISTS.length; ++i) {
            ListProvider provider = EXECUTABLE_LISTS[i];
            ExecutableList<?> l = provider.get(rtn);
            boolean notNull = ois.readBoolean();
            if (!notNull) continue;
            if (l == null) {
                l = provider.init(rtn);
            }
            l.readExternal(ois);
            if (traceEnabled) {
                LOG.tracev("Deserialized [{0}] entries", l.size());
            }
            l.afterDeserialize(session);
        }
        return rtn;
    }

    static {
        ActionQueue.EXECUTABLE_LISTS[0] = new ListProvider(){

            @Override
            ExecutableList<?> get(ActionQueue instance) {
                return instance.orphanRemovals;
            }

            @Override
            ExecutableList<?> init(ActionQueue instance) {
                return instance.orphanRemovals = new ExecutableList();
            }
        };
        ActionQueue.EXECUTABLE_LISTS[1] = new ListProvider(){

            @Override
            ExecutableList<?> get(ActionQueue instance) {
                return instance.insertions;
            }

            @Override
            ExecutableList<?> init(ActionQueue instance) {
                return instance.insertions = new ExecutableList<AbstractEntityInsertAction>(new InsertActionSorter());
            }
        };
        ActionQueue.EXECUTABLE_LISTS[2] = new ListProvider(){

            @Override
            ExecutableList<?> get(ActionQueue instance) {
                return instance.updates;
            }

            @Override
            ExecutableList<?> init(ActionQueue instance) {
                return instance.updates = new ExecutableList();
            }
        };
        ActionQueue.EXECUTABLE_LISTS[3] = new ListProvider(){

            @Override
            ExecutableList<?> get(ActionQueue instance) {
                return instance.collectionQueuedOps;
            }

            @Override
            ExecutableList<?> init(ActionQueue instance) {
                return instance.collectionQueuedOps = new ExecutableList();
            }
        };
        ActionQueue.EXECUTABLE_LISTS[4] = new ListProvider(){

            @Override
            ExecutableList<?> get(ActionQueue instance) {
                return instance.collectionRemovals;
            }

            @Override
            ExecutableList<?> init(ActionQueue instance) {
                return instance.collectionRemovals = new ExecutableList();
            }
        };
        ActionQueue.EXECUTABLE_LISTS[5] = new ListProvider(){

            @Override
            ExecutableList<?> get(ActionQueue instance) {
                return instance.collectionUpdates;
            }

            @Override
            ExecutableList<?> init(ActionQueue instance) {
                return instance.collectionUpdates = new ExecutableList();
            }
        };
        ActionQueue.EXECUTABLE_LISTS[6] = new ListProvider(){

            @Override
            ExecutableList<?> get(ActionQueue instance) {
                return instance.collectionCreations;
            }

            @Override
            ExecutableList<?> init(ActionQueue instance) {
                return instance.collectionCreations = new ExecutableList();
            }
        };
        ActionQueue.EXECUTABLE_LISTS[7] = new ListProvider(){

            @Override
            ExecutableList<?> get(ActionQueue instance) {
                return instance.deletions;
            }

            @Override
            ExecutableList<?> init(ActionQueue instance) {
                return instance.deletions = new ExecutableList();
            }
        };
    }

    private static abstract class ListProvider {
        private ListProvider() {
        }

        abstract ExecutableList<?> get(ActionQueue var1);

        abstract ExecutableList<?> init(ActionQueue var1);
    }

    private static class InsertActionSorter
    implements ExecutableList.Sorter<AbstractEntityInsertAction> {
        public static final InsertActionSorter INSTANCE = new InsertActionSorter();
        private Map<String, Integer> latestBatches;
        private Map<Object, Integer> entityBatchNumber;
        private Map<Integer, List<AbstractEntityInsertAction>> actionBatches;

        @Override
        public void sort(List<AbstractEntityInsertAction> insertions) {
            this.latestBatches = new HashMap<String, Integer>();
            this.entityBatchNumber = new HashMap<Object, Integer>(insertions.size() + 1, 1.0f);
            this.actionBatches = new HashMap<Integer, List<AbstractEntityInsertAction>>();
            for (AbstractEntityInsertAction action : insertions) {
                Integer batchNumber;
                String entityName = action.getEntityName();
                Object currentEntity = action.getInstance();
                if (this.latestBatches.containsKey(entityName)) {
                    batchNumber = this.findBatchNumber(action, entityName);
                } else {
                    batchNumber = this.actionBatches.size();
                    this.latestBatches.put(entityName, batchNumber);
                }
                this.entityBatchNumber.put(currentEntity, batchNumber);
                this.addToBatch(batchNumber, action);
            }
            insertions.clear();
            for (int i = 0; i < this.actionBatches.size(); ++i) {
                List<AbstractEntityInsertAction> batch = this.actionBatches.get(i);
                insertions.addAll(batch);
            }
        }

        private Integer findBatchNumber(AbstractEntityInsertAction action, String entityName) {
            Integer latestBatchNumberForType = this.latestBatches.get(entityName);
            Object[] propertyValues = action.getState();
            Type[] propertyTypes = action.getPersister().getClassMetadata().getPropertyTypes();
            for (int i = 0; i < propertyValues.length; ++i) {
                Integer associationBatchNumber;
                Object value = propertyValues[i];
                Type type = propertyTypes[i];
                if (!type.isEntityType() || value == null || (associationBatchNumber = this.entityBatchNumber.get(value)) == null || associationBatchNumber.compareTo(latestBatchNumberForType) <= 0) continue;
                latestBatchNumberForType = this.actionBatches.size();
                this.latestBatches.put(entityName, latestBatchNumberForType);
                break;
            }
            return latestBatchNumberForType;
        }

        private void addToBatch(Integer batchNumber, AbstractEntityInsertAction action) {
            List<AbstractEntityInsertAction> actions = this.actionBatches.get(batchNumber);
            if (actions == null) {
                actions = new LinkedList<AbstractEntityInsertAction>();
                this.actionBatches.put(batchNumber, actions);
            }
            actions.add(action);
        }
    }

    public static class TransactionCompletionProcesses {
        private final BeforeTransactionCompletionProcessQueue beforeTransactionCompletionProcesses;
        private final AfterTransactionCompletionProcessQueue afterTransactionCompletionProcesses;

        private TransactionCompletionProcesses(BeforeTransactionCompletionProcessQueue beforeTransactionCompletionProcessQueue, AfterTransactionCompletionProcessQueue afterTransactionCompletionProcessQueue) {
            this.beforeTransactionCompletionProcesses = beforeTransactionCompletionProcessQueue;
            this.afterTransactionCompletionProcesses = afterTransactionCompletionProcessQueue;
        }
    }

    private static class AfterTransactionCompletionProcessQueue
    extends AbstractTransactionCompletionProcessQueue<AfterTransactionCompletionProcess> {
        private Set<String> querySpacesToInvalidate = new HashSet<String>();

        private AfterTransactionCompletionProcessQueue(SessionImplementor session) {
            super(session);
        }

        public void addSpaceToInvalidate(String space) {
            this.querySpacesToInvalidate.add(space);
        }

        public void afterTransactionCompletion(boolean success) {
            while (!this.processes.isEmpty()) {
                try {
                    ((AfterTransactionCompletionProcess)this.processes.poll()).doAfterTransactionCompletion(success, this.session);
                }
                catch (CacheException ce) {
                    LOG.unableToReleaseCacheLock(ce);
                }
                catch (Exception e) {
                    throw new AssertionFailure("Exception releasing cache locks", e);
                }
            }
            if (this.session.getFactory().getSessionFactoryOptions().isQueryCacheEnabled()) {
                this.session.getFactory().getUpdateTimestampsCache().invalidate((Serializable[])this.querySpacesToInvalidate.toArray(new String[this.querySpacesToInvalidate.size()]), this.session);
            }
            this.querySpacesToInvalidate.clear();
        }
    }

    private static class BeforeTransactionCompletionProcessQueue
    extends AbstractTransactionCompletionProcessQueue<BeforeTransactionCompletionProcess> {
        private BeforeTransactionCompletionProcessQueue(SessionImplementor session) {
            super(session);
        }

        public void beforeTransactionCompletion() {
            while (!this.processes.isEmpty()) {
                try {
                    ((BeforeTransactionCompletionProcess)this.processes.poll()).doBeforeTransactionCompletion(this.session);
                }
                catch (HibernateException he) {
                    throw he;
                }
                catch (Exception e) {
                    throw new AssertionFailure("Unable to perform beforeTransactionCompletion callback", e);
                }
            }
        }
    }

    private static abstract class AbstractTransactionCompletionProcessQueue<T> {
        protected SessionImplementor session;
        protected Queue<T> processes = new ConcurrentLinkedQueue<T>();

        private AbstractTransactionCompletionProcessQueue(SessionImplementor session) {
            this.session = session;
        }

        public void register(T process) {
            if (process == null) {
                return;
            }
            this.processes.add(process);
        }

        public boolean hasActions() {
            return !this.processes.isEmpty();
        }
    }
}

