/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.transaction.internal;

import javax.transaction.Synchronization;
import org.hibernate.HibernateException;
import org.hibernate.TransactionException;
import org.hibernate.engine.spi.ExceptionConverter;
import org.hibernate.engine.transaction.spi.TransactionImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.resource.transaction.spi.TransactionCoordinator;
import org.hibernate.resource.transaction.spi.TransactionStatus;
import org.jboss.logging.Logger;

public class TransactionImpl
implements TransactionImplementor {
    private static final Logger LOG = CoreLogging.logger(TransactionImpl.class);
    private final TransactionCoordinator transactionCoordinator;
    private final ExceptionConverter exceptionConverter;
    private TransactionCoordinator.TransactionDriver transactionDriverControl;

    public TransactionImpl(TransactionCoordinator transactionCoordinator, ExceptionConverter exceptionConverter) {
        this.transactionCoordinator = transactionCoordinator;
        this.exceptionConverter = exceptionConverter;
        this.transactionDriverControl = transactionCoordinator.getTransactionDriverControl();
    }

    public void begin() {
        if (!this.transactionCoordinator.isActive()) {
            throw new TransactionException("Cannot begin Transaction on closed Session/EntityManager");
        }
        if (this.transactionDriverControl == null) {
            this.transactionDriverControl = this.transactionCoordinator.getTransactionDriverControl();
        }
        if (this.isActive()) {
            throw new IllegalStateException("Transaction already active");
        }
        LOG.debug((Object)"begin");
        this.transactionDriverControl.begin();
    }

    public void commit() {
        if (!this.isActive()) {
            throw new IllegalStateException("Transaction not successfully started");
        }
        LOG.debug((Object)"committing");
        try {
            this.internalGetTransactionDriverControl().commit();
        }
        catch (RuntimeException e) {
            throw this.exceptionConverter.convertCommitException(e);
        }
    }

    public TransactionCoordinator.TransactionDriver internalGetTransactionDriverControl() {
        if (this.transactionDriverControl == null) {
            throw new IllegalStateException("Transaction was not properly begun/started");
        }
        return this.transactionDriverControl;
    }

    public void rollback() {
        TransactionStatus status = this.getStatus();
        if (status == TransactionStatus.ROLLED_BACK || status == TransactionStatus.NOT_ACTIVE) {
            LOG.debug((Object)"rollback() called on an inactive transaction");
            return;
        }
        if (!status.canRollback()) {
            throw new TransactionException("Cannot rollback transaction in current status [" + status.name() + "]");
        }
        LOG.debug((Object)"rolling back");
        if (status != TransactionStatus.FAILED_COMMIT || this.allowFailedCommitToPhysicallyRollback()) {
            this.internalGetTransactionDriverControl().rollback();
        }
    }

    public boolean isActive() {
        return this.getStatus() == TransactionStatus.ACTIVE || this.getStatus() == TransactionStatus.MARKED_ROLLBACK;
    }

    @Override
    public TransactionStatus getStatus() {
        if (this.transactionDriverControl == null) {
            this.transactionDriverControl = this.transactionCoordinator.getTransactionDriverControl();
        }
        return this.transactionDriverControl.getStatus();
    }

    @Override
    public void registerSynchronization(Synchronization synchronization) throws HibernateException {
        this.transactionCoordinator.getLocalSynchronizations().registerSynchronization(synchronization);
    }

    @Override
    public void setTimeout(int seconds) {
        this.transactionCoordinator.setTimeOut(seconds);
    }

    @Override
    public int getTimeout() {
        return this.transactionCoordinator.getTimeOut();
    }

    public void setRollbackOnly() {
        this.internalGetTransactionDriverControl().markRollbackOnly();
    }

    public boolean getRollbackOnly() {
        return this.getStatus() == TransactionStatus.MARKED_ROLLBACK;
    }

    protected boolean allowFailedCommitToPhysicallyRollback() {
        return false;
    }
}

