/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.hibernate.HibernateException;
import org.hibernate.Incubating;
import org.hibernate.QueryException;
import org.hibernate.QueryParameterException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.query.spi.NamedParameterDescriptor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.TypedValue;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.query.ParameterMetadata;
import org.hibernate.query.QueryParameter;
import org.hibernate.query.internal.QueryParameterBindingImpl;
import org.hibernate.query.internal.QueryParameterListBindingImpl;
import org.hibernate.query.internal.QueryParameterNamedImpl;
import org.hibernate.query.spi.QueryParameterBinding;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.QueryParameterListBinding;
import org.hibernate.type.SerializableType;
import org.hibernate.type.Type;

@Incubating
public class QueryParameterBindingsImpl
implements QueryParameterBindings {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(QueryParameterBindingsImpl.class);
    private final SessionFactoryImplementor sessionFactory;
    private final ParameterMetadata parameterMetadata;
    private Map<QueryParameter, QueryParameterBinding> parameterBindingMap;
    private Map<QueryParameter, QueryParameterListBinding> parameterListBindingMap;
    private List<QueryParameterBinding> positionalParameterBindings;

    public static QueryParameterBindingsImpl from(ParameterMetadata parameterMetadata, SessionFactoryImplementor sessionFactory) {
        if (parameterMetadata == null) {
            return new QueryParameterBindingsImpl(sessionFactory, parameterMetadata);
        }
        return new QueryParameterBindingsImpl(sessionFactory, parameterMetadata.collectAllParameters(), parameterMetadata);
    }

    public QueryParameterBindingsImpl(SessionFactoryImplementor sessionFactory, ParameterMetadata parameterMetadata) {
        this(sessionFactory, Collections.emptySet(), parameterMetadata);
    }

    public QueryParameterBindingsImpl(SessionFactoryImplementor sessionFactory, Set<QueryParameter<?>> queryParameters, ParameterMetadata parameterMetadata) {
        this.sessionFactory = sessionFactory;
        this.parameterMetadata = parameterMetadata;
        this.positionalParameterBindings = new ArrayList<QueryParameterBinding>(4);
        if (queryParameters == null || queryParameters.isEmpty()) {
            this.parameterBindingMap = Collections.emptyMap();
        } else {
            this.parameterBindingMap = new HashMap<QueryParameter, QueryParameterBinding>();
            for (QueryParameter<?> queryParameter : queryParameters) {
                if (queryParameter.getPosition() != null) continue;
                this.parameterBindingMap.put(queryParameter, this.makeBinding(queryParameter));
            }
        }
        this.parameterListBindingMap = new HashMap<QueryParameter, QueryParameterListBinding>();
    }

    protected QueryParameterBinding makeBinding(QueryParameter queryParameter) {
        return this.makeBinding(queryParameter.getType());
    }

    protected QueryParameterBinding makeBinding(Type bindType) {
        return new QueryParameterBindingImpl(bindType, this.sessionFactory);
    }

    @Override
    public boolean isBound(QueryParameter parameter) {
        QueryParameterBinding binding = this.locateBinding(parameter);
        if (binding != null) {
            return binding.getBindValue() != null;
        }
        QueryParameterListBinding listBinding = this.locateQueryParameterListBinding(parameter);
        if (listBinding != null) {
            return listBinding.getBindValues() != null;
        }
        return false;
    }

    @Override
    public <T> QueryParameterBinding<T> getBinding(QueryParameter<T> parameter) {
        QueryParameterBinding<T> binding = this.locateBinding(parameter);
        if (binding == null) {
            throw new IllegalArgumentException("Could not resolve QueryParameter reference [" + parameter + "] to QueryParameterBinding");
        }
        return binding;
    }

    public <T> QueryParameterBinding<T> locateBinding(QueryParameter<T> parameter) {
        QueryParameterBinding binding;
        if (this.parameterBindingMap.containsKey(parameter)) {
            return this.parameterBindingMap.get(parameter);
        }
        if (StringHelper.isNotEmpty(parameter.getName()) && (binding = this.locateBinding(parameter.getName())) != null) {
            return binding;
        }
        if (parameter.getPosition() != null && (binding = this.locateBinding(parameter.getPosition())) != null) {
            return binding;
        }
        return null;
    }

    protected QueryParameterBinding locateBinding(String name) {
        for (Map.Entry<QueryParameter, QueryParameterBinding> entry : this.parameterBindingMap.entrySet()) {
            if (!name.equals(entry.getKey().getName())) continue;
            return entry.getValue();
        }
        return null;
    }

    protected QueryParameterBinding locateAndRemoveBinding(String name) {
        Iterator<Map.Entry<QueryParameter, QueryParameterBinding>> entryIterator = this.parameterBindingMap.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry<QueryParameter, QueryParameterBinding> entry = entryIterator.next();
            if (!name.equals(entry.getKey().getName())) continue;
            entryIterator.remove();
            return entry.getValue();
        }
        return null;
    }

    protected QueryParameterBinding locateBinding(int position) {
        if (position < this.positionalParameterBindings.size()) {
            return this.positionalParameterBindings.get(position);
        }
        return null;
    }

    public QueryParameterBinding getBinding(String name) {
        QueryParameterBinding binding = this.locateBinding(name);
        if (binding == null) {
            throw new IllegalArgumentException("Unknown parameter name : " + name);
        }
        return binding;
    }

    public QueryParameterBinding getBinding(int position) {
        QueryParameterBinding binding = null;
        if (this.parameterMetadata != null) {
            if (!this.parameterMetadata.hasPositionalParameters()) {
                binding = this.locateBinding(Integer.toString(position));
            } else {
                try {
                    if (position < this.positionalParameterBindings.size()) {
                        binding = this.positionalParameterBindings.get(position);
                        if (binding == null) {
                            binding = this.makeBinding(this.parameterMetadata.getQueryParameter(position));
                            this.positionalParameterBindings.set(position, binding);
                        }
                    } else {
                        for (int i = 0; i < position - this.positionalParameterBindings.size(); ++i) {
                            this.positionalParameterBindings.add(null);
                        }
                        QueryParameter queryParameter = this.parameterMetadata.getQueryParameter(position);
                        binding = this.makeBinding(queryParameter);
                        this.positionalParameterBindings.add(binding);
                    }
                }
                catch (QueryParameterException queryParameterException) {
                    // empty catch block
                }
            }
        }
        if (binding == null) {
            throw new IllegalArgumentException("Unknown parameter position: " + position);
        }
        return binding;
    }

    public void verifyParametersBound(boolean reserveFirstParameter) {
        for (Map.Entry<QueryParameter, QueryParameterBinding> bindEntry : this.parameterBindingMap.entrySet()) {
            if (bindEntry.getValue().isBound()) continue;
            if (bindEntry.getKey().getName() != null) {
                throw new QueryException("Named parameter [" + bindEntry.getKey().getName() + "] not set");
            }
            throw new QueryException("Parameter memento [" + bindEntry.getKey() + "] not set");
        }
        for (int i = 0; i < this.positionalParameterBindings.size(); ++i) {
            QueryParameterBinding binding = this.positionalParameterBindings.get(i);
            if (binding != null && binding.isBound()) continue;
            throw new QueryException("Positional parameter [" + i + "] not set");
        }
        int positionalValueSpan = this.calculatePositionalValueSpan(reserveFirstParameter);
        int positionCounts = this.parameterMetadata.getPositionalParameterCount();
        if (positionCounts != positionalValueSpan) {
            if (reserveFirstParameter && positionCounts - 1 != positionalValueSpan) {
                throw new QueryException("Expected positional parameter count: " + (positionCounts - 1) + ", actually detected " + positionalValueSpan);
            }
            if (!reserveFirstParameter) {
                throw new QueryException("Expected positional parameter count: " + positionCounts + ", actually detected " + positionalValueSpan);
            }
        }
    }

    private int calculatePositionalValueSpan(boolean reserveFirstParameter) {
        int positionalValueSpan = 0;
        for (QueryParameterBinding binding : this.positionalParameterBindings) {
            if (!binding.isBound()) continue;
            SerializableType<Serializable> bindType = binding.getBindType();
            if (bindType == null) {
                bindType = SerializableType.INSTANCE;
            }
            Object object = binding.getBindValue();
            positionalValueSpan += bindType.getColumnSpan(this.sessionFactory);
        }
        return positionalValueSpan;
    }

    @Deprecated
    public Collection<Type> collectBindTypes() {
        return this.parameterBindingMap.values().stream().map(QueryParameterBinding::getBindType).collect(Collectors.toList());
    }

    @Deprecated
    public Collection<Object> collectBindValues() {
        return this.parameterBindingMap.values().stream().map(QueryParameterBinding::getBindValue).collect(Collectors.toList());
    }

    @Deprecated
    public Type[] collectPositionalBindTypes() {
        TreeMap<Integer, QueryParameterBinding> positionalParameterBindingMap = this.collectPositionalParameterBindings();
        Type[] types = new Type[positionalParameterBindingMap.size()];
        for (Map.Entry<Integer, QueryParameterBinding> entry : positionalParameterBindingMap.entrySet()) {
            int position = entry.getKey();
            SerializableType<Serializable> type = entry.getValue().getBindType();
            if (type == null) {
                log.debugf("Binding for positional-parameter [%s] did not define type, using SerializableType", position);
                type = SerializableType.INSTANCE;
            }
            types[position] = type;
        }
        return types;
    }

    private TreeMap<Integer, QueryParameterBinding> collectPositionalParameterBindings() {
        TreeMap<Integer, QueryParameterBinding> bindings = new TreeMap<Integer, QueryParameterBinding>();
        for (int i = 0; i < this.positionalParameterBindings.size(); ++i) {
            bindings.put(i, this.positionalParameterBindings.get(i));
        }
        return bindings;
    }

    @Deprecated
    public Object[] collectPositionalBindValues() {
        TreeMap<Integer, QueryParameterBinding> positionalParameterBindingMap = this.collectPositionalParameterBindings();
        Object[] values = new Object[positionalParameterBindingMap.size()];
        for (Map.Entry<Integer, QueryParameterBinding> entry : positionalParameterBindingMap.entrySet()) {
            int position = entry.getKey();
            values[position] = entry.getValue().getBindValue();
        }
        return values;
    }

    @Deprecated
    public Map<String, TypedValue> collectNamedParameterBindings() {
        HashMap<String, TypedValue> collectedBindings = new HashMap<String, TypedValue>();
        for (Map.Entry<QueryParameter, QueryParameterBinding> entry : this.parameterBindingMap.entrySet()) {
            if (entry.getKey().getName() == null) continue;
            SerializableType<Serializable> bindType = entry.getValue().getBindType();
            if (bindType == null) {
                log.debugf("Binding for named-parameter [%s] did not define type", entry.getKey().getName());
                bindType = SerializableType.INSTANCE;
            }
            collectedBindings.put(entry.getKey().getName(), new TypedValue(bindType, entry.getValue().getBindValue()));
        }
        return collectedBindings;
    }

    @Deprecated
    public <T> QueryParameterListBinding<T> getQueryParameterListBinding(QueryParameter<T> queryParameter) {
        QueryParameterListBinding<T> result = this.parameterListBindingMap.get(queryParameter);
        if (result == null) {
            result = this.transformQueryParameterBindingToQueryParameterListBinding(queryParameter);
        }
        return result;
    }

    @Deprecated
    private QueryParameterListBinding locateQueryParameterListBinding(QueryParameter queryParameter) {
        QueryParameterListBinding result = this.parameterListBindingMap.get(queryParameter);
        if (result == null && queryParameter.getName() != null) {
            for (Map.Entry<QueryParameter, QueryParameterListBinding> entry : this.parameterListBindingMap.entrySet()) {
                if (!queryParameter.getName().equals(entry.getKey().getName())) continue;
                result = entry.getValue();
                break;
            }
        }
        return result;
    }

    @Deprecated
    private <T> QueryParameterListBinding<T> transformQueryParameterBindingToQueryParameterListBinding(QueryParameter<T> queryParameter) {
        log.debugf("Converting QueryParameterBinding to QueryParameterListBinding for given QueryParameter : %s", queryParameter);
        QueryParameterBinding<T> binding = this.getAndRemoveBinding(queryParameter);
        if (binding == null) {
            throw new IllegalArgumentException("Could not locate QueryParameterBinding for given QueryParameter : " + queryParameter + "; parameter list must be defined using named parameter");
        }
        QueryParameterListBindingImpl convertedBinding = new QueryParameterListBindingImpl(binding.getBindType());
        this.parameterListBindingMap.put(queryParameter, convertedBinding);
        return convertedBinding;
    }

    @Deprecated
    private <T> QueryParameterBinding<T> getAndRemoveBinding(QueryParameter<T> parameter) {
        QueryParameterBinding binding;
        if (this.parameterBindingMap.containsKey(parameter)) {
            return this.parameterBindingMap.remove(parameter);
        }
        if (StringHelper.isNotEmpty(parameter.getName()) && (binding = this.locateAndRemoveBinding(parameter.getName())) != null) {
            return binding;
        }
        throw new IllegalArgumentException("Could not resolve QueryParameter reference [" + parameter + "] to QueryParameterBinding");
    }

    @Deprecated
    public <T> QueryParameterListBinding<T> getQueryParameterListBinding(String name) {
        QueryParameter<T> queryParameter = this.resolveQueryParameter(name);
        return this.getQueryParameterListBinding(queryParameter);
    }

    @Deprecated
    private <T> QueryParameter<T> resolveQueryParameter(String name) {
        for (QueryParameter queryParameter : this.parameterListBindingMap.keySet()) {
            if (!name.equals(queryParameter.getName())) continue;
            return queryParameter;
        }
        for (QueryParameter queryParameter : this.parameterBindingMap.keySet()) {
            if (!name.equals(queryParameter.getName())) continue;
            return queryParameter;
        }
        throw new IllegalArgumentException("Unable to resolve given parameter name [" + name + "] to QueryParameter reference");
    }

    @Deprecated
    public String expandListValuedParameters(String queryString, SharedSessionContractImplementor session) {
        if (queryString == null) {
            return null;
        }
        Dialect dialect = session.getFactory().getServiceRegistry().getService(JdbcServices.class).getJdbcEnvironment().getDialect();
        int inExprLimit = dialect.getInExpressionCountLimit();
        for (Map.Entry<QueryParameter, QueryParameterListBinding> entry : this.parameterListBindingMap.entrySet()) {
            boolean isEnclosedInParens;
            boolean isJpaPositionalParam;
            String paramPrefix;
            String placeholder;
            int loc;
            NamedParameterDescriptor sourceParam = (NamedParameterDescriptor)entry.getKey();
            Collection bindValues = entry.getValue().getBindValues();
            if (inExprLimit > 0 && bindValues.size() > inExprLimit) {
                log.tooManyInExpressions(dialect.getClass().getName(), inExprLimit, sourceParam.getName(), bindValues.size());
            }
            if ((loc = queryString.indexOf(placeholder = (paramPrefix = (isJpaPositionalParam = sourceParam.isJpaPositionalParameter()) ? "?" : ":") + sourceParam.getName())) < 0) continue;
            String beforePlaceholder = queryString.substring(0, loc);
            String afterPlaceholder = queryString.substring(loc + placeholder.length());
            boolean bl = isEnclosedInParens = StringHelper.getLastNonWhitespaceCharacter(beforePlaceholder) == '(' && StringHelper.getFirstNonWhitespaceCharacter(afterPlaceholder) == ')';
            if (bindValues.size() == 1 && isEnclosedInParens) {
                QueryParameterBinding syntheticBinding = this.makeBinding(entry.getValue().getBindType());
                syntheticBinding.setBindValue(bindValues.iterator().next());
                this.parameterBindingMap.put(sourceParam, syntheticBinding);
                continue;
            }
            StringBuilder expansionList = new StringBuilder();
            int i = 0;
            for (Object bindValue : entry.getValue().getBindValues()) {
                String syntheticName = (isJpaPositionalParam ? Character.valueOf('x') : "") + sourceParam.getName() + '_' + i;
                if (i > 0) {
                    expansionList.append(", ");
                }
                expansionList.append(":").append(syntheticName);
                QueryParameterNamedImpl syntheticParam = new QueryParameterNamedImpl(syntheticName, sourceParam.getSourceLocations(), sourceParam.isJpaPositionalParameter(), sourceParam.getType());
                QueryParameterBinding syntheticBinding = this.makeBinding(entry.getValue().getBindType());
                syntheticBinding.setBindValue(bindValue);
                if (this.parameterBindingMap.put(syntheticParam, syntheticBinding) != null) {
                    throw new HibernateException("Repeated usage of synthetic parameter name [" + syntheticName + "] while expanding list parameter.");
                }
                ++i;
            }
            queryString = StringHelper.replace(beforePlaceholder, afterPlaceholder, placeholder, expansionList.toString(), true, true);
        }
        return queryString;
    }
}

