/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.asm.util;

import java.util.HashMap;
import org.logicalcobwebs.asm.Attribute;
import org.logicalcobwebs.asm.CodeVisitor;
import org.logicalcobwebs.asm.Label;
import org.logicalcobwebs.asm.util.PrintCodeVisitor;

public class TraceCodeVisitor
extends PrintCodeVisitor {
    protected final CodeVisitor cv;
    private final HashMap labelNames;

    public TraceCodeVisitor(CodeVisitor cv) {
        this.cv = cv;
        this.labelNames = new HashMap();
    }

    public void printInsn(int opcode) {
        this.buf.append("    ").append(OPCODES[opcode]).append("\n");
        if (this.cv != null) {
            this.cv.visitInsn(opcode);
        }
    }

    public void printIntInsn(int opcode, int operand) {
        this.buf.append("    ").append(OPCODES[opcode]).append(" ").append(operand).append("\n");
        if (this.cv != null) {
            this.cv.visitIntInsn(opcode, operand);
        }
    }

    public void printVarInsn(int opcode, int var) {
        this.buf.append("    ").append(OPCODES[opcode]).append(" ").append(var).append("\n");
        if (this.cv != null) {
            this.cv.visitVarInsn(opcode, var);
        }
    }

    public void printTypeInsn(int opcode, String desc) {
        this.buf.append("    ").append(OPCODES[opcode]).append(" ").append(desc).append("\n");
        if (this.cv != null) {
            this.cv.visitTypeInsn(opcode, desc);
        }
    }

    public void printFieldInsn(int opcode, String owner, String name, String desc) {
        this.buf.append("    ").append(OPCODES[opcode]).append(" ").append(owner).append(" ").append(name).append(" ").append(desc).append("\n");
        if (this.cv != null) {
            this.cv.visitFieldInsn(opcode, owner, name, desc);
        }
    }

    public void printMethodInsn(int opcode, String owner, String name, String desc) {
        this.buf.append("    ").append(OPCODES[opcode]).append(" ").append(owner).append(" ").append(name).append(" ").append(desc).append("\n");
        if (this.cv != null) {
            this.cv.visitMethodInsn(opcode, owner, name, desc);
        }
    }

    public void printJumpInsn(int opcode, Label label) {
        this.buf.append("    ").append(OPCODES[opcode]).append(" ");
        this.appendLabel(label);
        this.buf.append("\n");
        if (this.cv != null) {
            this.cv.visitJumpInsn(opcode, label);
        }
    }

    public void printLabel(Label label) {
        this.buf.append("   ");
        this.appendLabel(label);
        this.buf.append(":\n");
        if (this.cv != null) {
            this.cv.visitLabel(label);
        }
    }

    public void printLdcInsn(Object cst) {
        this.buf.append("    LDC ");
        if (cst instanceof String) {
            this.buf.append("\"").append(cst).append("\"");
        } else {
            this.buf.append(cst);
        }
        this.buf.append("\n");
        if (this.cv != null) {
            this.cv.visitLdcInsn(cst);
        }
    }

    public void printIincInsn(int var, int increment) {
        this.buf.append("    IINC ").append(var).append(" ").append(increment).append("\n");
        if (this.cv != null) {
            this.cv.visitIincInsn(var, increment);
        }
    }

    public void printTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        this.buf.append("    TABLESWITCH\n");
        for (int i = 0; i < labels.length; ++i) {
            this.buf.append("      ").append(min + i).append(": ");
            this.appendLabel(labels[i]);
            this.buf.append("\n");
        }
        this.buf.append("      default: ");
        this.appendLabel(dflt);
        this.buf.append("\n");
        if (this.cv != null) {
            this.cv.visitTableSwitchInsn(min, max, dflt, labels);
        }
    }

    public void printLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.buf.append("    LOOKUPSWITCH\n");
        for (int i = 0; i < labels.length; ++i) {
            this.buf.append("      ").append(keys[i]).append(": ");
            this.appendLabel(labels[i]);
            this.buf.append("\n");
        }
        this.buf.append("      default: ");
        this.appendLabel(dflt);
        this.buf.append("\n");
        if (this.cv != null) {
            this.cv.visitLookupSwitchInsn(dflt, keys, labels);
        }
    }

    public void printMultiANewArrayInsn(String desc, int dims) {
        this.buf.append("    MULTIANEWARRAY ").append(desc).append(" ").append(dims).append("\n");
        if (this.cv != null) {
            this.cv.visitMultiANewArrayInsn(desc, dims);
        }
    }

    public void printTryCatchBlock(Label start, Label end, Label handler, String type) {
        this.buf.append("    TRYCATCHBLOCK ");
        this.appendLabel(start);
        this.buf.append(" ");
        this.appendLabel(end);
        this.buf.append(" ");
        this.appendLabel(handler);
        this.buf.append(" ").append(type).append("\n");
        if (this.cv != null) {
            this.cv.visitTryCatchBlock(start, end, handler, type);
        }
    }

    public void printMaxs(int maxStack, int maxLocals) {
        this.buf.append("    MAXSTACK = ").append(maxStack).append("\n    MAXLOCALS = ").append(maxLocals).append("\n\n");
        if (this.cv != null) {
            this.cv.visitMaxs(maxStack, maxLocals);
        }
    }

    public void printLocalVariable(String name, String desc, Label start, Label end, int index) {
        this.buf.append("    LOCALVARIABLE ").append(name).append(" ").append(desc).append(" ");
        this.appendLabel(start);
        this.buf.append(" ");
        this.appendLabel(end);
        this.buf.append(" ").append(index).append("\n");
        if (this.cv != null) {
            this.cv.visitLocalVariable(name, desc, start, end, index);
        }
    }

    public void printLineNumber(int line, Label start) {
        this.buf.append("    LINENUMBER ").append(line).append(" ");
        this.appendLabel(start);
        this.buf.append("\n");
        if (this.cv != null) {
            this.cv.visitLineNumber(line, start);
        }
    }

    public void printAttribute(Attribute attr) {
        this.buf.append("    CODE ATTRIBUTE ").append(attr.type).append("\n");
        if (this.cv != null) {
            this.cv.visitAttribute(attr);
        }
    }

    private void appendLabel(Label l) {
        String name = (String)this.labelNames.get(l);
        if (name == null) {
            name = "L" + this.labelNames.size();
            this.labelNames.put(l, name);
        }
        this.buf.append(name);
    }
}

