/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.ap;

import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.hibernate.validator.ap.ConstraintAnnotationVisitor;
import org.hibernate.validator.ap.util.AnnotationApiHelper;
import org.hibernate.validator.ap.util.Configuration;
import org.hibernate.validator.ap.util.MessagerAdapter;

@SupportedAnnotationTypes(value={"*"})
@SupportedOptions(value={"diagnosticKind", "verbose", "methodConstraintsSupported"})
public class ConstraintValidationProcessor
extends AbstractProcessor {
    private static final boolean ANNOTATIONS_CLAIMED_EXCLUSIVELY = false;
    private MessagerAdapter messager;
    private Configuration configuration;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.configuration = new Configuration(processingEnv.getOptions(), processingEnv.getMessager());
        this.messager = new MessagerAdapter(processingEnv.getMessager(), this.configuration.getDiagnosticKind());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnvironment) {
        AnnotationApiHelper typeHelper = new AnnotationApiHelper(this.processingEnv.getElementUtils(), this.processingEnv.getTypeUtils());
        ConstraintAnnotationVisitor visitor = new ConstraintAnnotationVisitor(this.processingEnv, this.messager, this.configuration);
        for (TypeElement typeElement : annotations) {
            if (typeElement.getKind() != ElementKind.ANNOTATION_TYPE) continue;
            Set<? extends Element> elementsWithConstraintAnnotation = roundEnvironment.getElementsAnnotatedWith(typeElement);
            for (Element element : elementsWithConstraintAnnotation) {
                List<AnnotationMirror> mirrorsOfCurrentAnnotation = typeHelper.filterByType(element.getAnnotationMirrors(), typeElement.asType());
                element.accept(visitor, mirrorsOfCurrentAnnotation);
            }
        }
        return false;
    }
}

