/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.cfg.context;

import java.lang.annotation.ElementType;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.hibernate.validator.cfg.context.MethodConstraintMappingContext;
import org.hibernate.validator.cfg.context.PropertyConstraintMappingContext;
import org.hibernate.validator.cfg.context.TypeConstraintMappingContext;
import org.hibernate.validator.internal.cfg.context.ConstraintMappingContext;
import org.hibernate.validator.internal.cfg.context.MethodConstraintMappingContextImpl;
import org.hibernate.validator.internal.cfg.context.PropertyConstraintMappingContextImpl;
import org.hibernate.validator.internal.cfg.context.TypeConstraintMappingContextImpl;
import org.hibernate.validator.internal.util.Contracts;
import org.hibernate.validator.internal.util.ReflectionHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.internal.util.logging.Messages;
import org.hibernate.validator.internal.util.privilegedactions.GetDeclaredField;
import org.hibernate.validator.internal.util.privilegedactions.GetDeclaredMethod;
import org.hibernate.validator.internal.util.privilegedactions.GetMethod;

abstract class ConstraintMappingContextImplBase {
    private static final Log log = LoggerFactory.make();
    protected final Class<?> beanClass;
    protected final ConstraintMappingContext mapping;

    public ConstraintMappingContextImplBase(Class<?> beanClass, ConstraintMappingContext mapping) {
        this.beanClass = beanClass;
        this.mapping = mapping;
    }

    public <C> TypeConstraintMappingContext<C> type(Class<C> type) {
        Contracts.assertNotNull(this.beanClass, Messages.MESSAGES.beanTypeMustNotBeNull());
        return new TypeConstraintMappingContextImpl(type, this.mapping);
    }

    public PropertyConstraintMappingContext property(String property, ElementType elementType) {
        Contracts.assertNotNull(property, "The property name must not be null.");
        Contracts.assertNotNull((Object)elementType, "The element type must not be null.");
        Contracts.assertNotEmpty(property, Messages.MESSAGES.propertyNameMustNotBeEmpty());
        Member member = this.getMember(this.beanClass, property, elementType);
        if (member == null) {
            throw log.getUnableToFindPropertyWithAccessException(this.beanClass, property, elementType);
        }
        return new PropertyConstraintMappingContextImpl(this.beanClass, member, this.mapping);
    }

    public MethodConstraintMappingContext method(String name, Class<?> ... parameterTypes) {
        Contracts.assertNotNull(name, Messages.MESSAGES.methodNameMustNotBeNull());
        Method method = ConstraintMappingContextImplBase.run(GetDeclaredMethod.action(this.beanClass, name, parameterTypes));
        if (method == null) {
            StringBuilder sb = new StringBuilder();
            for (Class<?> oneParameterType : parameterTypes) {
                sb.append(oneParameterType.getName()).append(", ");
            }
            String parameterTypesAsString = sb.length() > 2 ? sb.substring(0, sb.length() - 2) : sb.toString();
            throw log.getUnableToFindMethodException(this.beanClass, name, parameterTypesAsString);
        }
        return new MethodConstraintMappingContextImpl(this.beanClass, method, this.mapping);
    }

    private Member getMember(Class<?> clazz, String property, ElementType elementType) {
        Contracts.assertNotNull(clazz, Messages.MESSAGES.classCannotBeNull());
        if (property == null || property.length() == 0) {
            throw log.getPropertyNameCannotBeNullOrEmptyException();
        }
        if (!ElementType.FIELD.equals((Object)elementType) && !ElementType.METHOD.equals((Object)elementType)) {
            throw log.getElementTypeHasToBeFieldOrMethodException();
        }
        Member member = null;
        if (ElementType.FIELD.equals((Object)elementType)) {
            GetDeclaredField action = GetDeclaredField.action(clazz, property);
            member = System.getSecurityManager() != null ? (Member)AccessController.doPrivileged(action) : action.run();
        } else {
            String methodName = property.substring(0, 1).toUpperCase() + property.substring(1);
            for (String prefix : ReflectionHelper.PROPERTY_ACCESSOR_PREFIXES) {
                GetMethod action = GetMethod.action(clazz, prefix + methodName);
                member = System.getSecurityManager() != null ? (Member)AccessController.doPrivileged(action) : action.run();
                if (member != null) break;
            }
        }
        return member;
    }

    private static <T> T run(PrivilegedAction<T> action) {
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
    }
}

