/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine.groups;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.validation.GroupSequence;
import javax.validation.groups.Default;
import org.hibernate.validator.internal.engine.groups.DefaultValidationOrder;
import org.hibernate.validator.internal.engine.groups.Group;
import org.hibernate.validator.internal.engine.groups.Sequence;
import org.hibernate.validator.internal.engine.groups.ValidationOrder;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public class ValidationOrderGenerator {
    private static final Log log = LoggerFactory.make();
    private final ConcurrentMap<Class<?>, Sequence> resolvedSequences = new ConcurrentHashMap();
    private final DefaultValidationOrder validationOrderForDefaultGroup = new DefaultValidationOrder();

    public ValidationOrderGenerator() {
        this.validationOrderForDefaultGroup.insertGroup(new Group(Default.class));
    }

    public ValidationOrder getValidationOrder(Collection<Class<?>> groups) {
        if (groups == null || groups.size() == 0) {
            throw log.getAtLeastOneGroupHasToBeSpecifiedException();
        }
        if (groups.size() == 1 && groups.contains(Default.class)) {
            return this.validationOrderForDefaultGroup;
        }
        for (Class<?> clazz : groups) {
            if (clazz.isInterface()) continue;
            throw log.getGroupHasToBeAnInterfaceException(clazz.getName());
        }
        DefaultValidationOrder validationOrder = new DefaultValidationOrder();
        for (Class<?> clazz : groups) {
            Group group;
            if (Default.class.equals(clazz)) {
                group = new Group(clazz);
                validationOrder.insertGroup(group);
                continue;
            }
            if (this.isGroupSequence(clazz)) {
                this.insertSequence(clazz, validationOrder);
                continue;
            }
            group = new Group(clazz);
            validationOrder.insertGroup(group);
            this.insertInheritedGroups(clazz, validationOrder);
        }
        return validationOrder;
    }

    private boolean isGroupSequence(Class<?> clazz) {
        return clazz.getAnnotation(GroupSequence.class) != null;
    }

    private void insertInheritedGroups(Class<?> clazz, DefaultValidationOrder chain) {
        for (Class<?> inheritedGroup : clazz.getInterfaces()) {
            Group group = new Group(inheritedGroup);
            chain.insertGroup(group);
            this.insertInheritedGroups(inheritedGroup, chain);
        }
    }

    private void insertSequence(Class<?> sequenceClass, DefaultValidationOrder validationOrder) {
        Sequence sequence = (Sequence)this.resolvedSequences.get(sequenceClass);
        if (sequence == null) {
            sequence = this.resolveSequence(sequenceClass, new ArrayList());
            sequence.expandInheritedGroups();
            Sequence cachedResolvedSequence = this.resolvedSequences.putIfAbsent(sequenceClass, sequence);
            if (cachedResolvedSequence != null) {
                sequence = cachedResolvedSequence;
            }
        }
        validationOrder.insertSequence(sequence);
    }

    private Sequence resolveSequence(Class<?> sequenceClass, List<Class<?>> processedSequences) {
        Class[] sequenceArray;
        if (processedSequences.contains(sequenceClass)) {
            throw log.getCyclicDependencyInGroupsDefinitionException();
        }
        processedSequences.add(sequenceClass);
        ArrayList<Group> resolvedSequenceGroups = new ArrayList<Group>();
        GroupSequence sequenceAnnotation = sequenceClass.getAnnotation(GroupSequence.class);
        for (Class clazz : sequenceArray = sequenceAnnotation.value()) {
            if (this.isGroupSequence(clazz)) {
                Sequence tmpSequence = this.resolveSequence(clazz, processedSequences);
                this.addGroups(resolvedSequenceGroups, tmpSequence.getComposingGroups());
                continue;
            }
            ArrayList<Group> list = new ArrayList<Group>();
            list.add(new Group(clazz));
            this.addGroups(resolvedSequenceGroups, list);
        }
        return new Sequence(sequenceClass, resolvedSequenceGroups);
    }

    private void addGroups(List<Group> resolvedGroupSequence, List<Group> groups) {
        for (Group tmpGroup : groups) {
            if (resolvedGroupSequence.contains(tmpGroup) && resolvedGroupSequence.indexOf(tmpGroup) < resolvedGroupSequence.size() - 1) {
                throw log.getUnableToExpandGroupSequenceException();
            }
            resolvedGroupSequence.add(tmpGroup);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ValidationOrderGenerator");
        sb.append("{resolvedSequences=").append(this.resolvedSequences);
        sb.append('}');
        return sb.toString();
    }
}

