/*
 * Decompiled with CFR 0.152.
 */
package org.aopalliance.intercept;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInvocation;

public class Call
implements Serializable {
    static final long serialVersionUID = -3336463259251779539L;
    protected Object target;
    protected Object[] args;
    private Class declaringClass;
    private Class[] parameterTypes;
    private String methodName;

    public Call(MethodInvocation invocation) {
        Method method = invocation.getMethod();
        this.methodName = method.getName();
        this.declaringClass = method.getDeclaringClass();
        this.parameterTypes = invocation.getMethod().getParameterTypes();
        this.target = invocation.getThis();
        int argumentCount = invocation.getArgumentCount();
        this.args = new Object[argumentCount];
        int i = 0;
        while (i < this.args.length) {
            this.args[i] = invocation.getArgument(i);
            ++i;
        }
    }

    public Method getMethod() {
        try {
            return this.declaringClass.getMethod(this.methodName, this.parameterTypes);
        }
        catch (Exception e) {
            throw new IllegalStateException("did not find method " + this.methodName);
        }
    }

    public Class getDeclaringClass() {
        return this.declaringClass;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public Object getTarget() {
        return this.target;
    }
}

