/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.access;

import java.util.Comparator;
import java.util.concurrent.TimeUnit;
import javax.transaction.Synchronization;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.infinispan.access.AccessDelegate;
import org.hibernate.cache.infinispan.access.RemovalSynchronization;
import org.hibernate.cache.infinispan.impl.BaseTransactionalDataRegion;
import org.hibernate.cache.infinispan.util.Caches;
import org.hibernate.cache.infinispan.util.InfinispanMessageLogger;
import org.hibernate.cache.infinispan.util.VersionedEntry;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.cache.spi.entry.CacheEntry;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.resource.transaction.spi.TransactionCoordinator;
import org.infinispan.AdvancedCache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.context.Flag;

public class NonStrictAccessDelegate
implements AccessDelegate {
    private static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(NonStrictAccessDelegate.class);
    private static final boolean trace = log.isTraceEnabled();
    private final BaseTransactionalDataRegion region;
    private final AdvancedCache cache;
    private final AdvancedCache writeCache;
    private final AdvancedCache putFromLoadCache;
    private final Comparator versionComparator;

    public NonStrictAccessDelegate(BaseTransactionalDataRegion region) {
        this.region = region;
        this.cache = region.getCache();
        this.writeCache = Caches.ignoreReturnValuesCache(this.cache);
        this.putFromLoadCache = this.writeCache.withFlags(new Flag[]{Flag.ZERO_LOCK_ACQUISITION_TIMEOUT, Flag.FAIL_SILENTLY});
        Configuration configuration = this.cache.getCacheConfiguration();
        if (configuration.clustering().cacheMode().isInvalidation()) {
            throw new IllegalArgumentException("Nonstrict-read-write mode cannot use invalidation.");
        }
        if (configuration.transaction().transactionMode().isTransactional()) {
            throw new IllegalArgumentException("Currently transactional caches are not supported.");
        }
        this.versionComparator = region.getCacheDataDescription().getVersionComparator();
        if (this.versionComparator == null) {
            throw new IllegalArgumentException("This strategy requires versioned entities/collections but region " + region.getName() + " contains non-versioned data!");
        }
    }

    @Override
    public Object get(SharedSessionContractImplementor session, Object key, long txTimestamp) throws CacheException {
        if (txTimestamp < this.region.getLastRegionInvalidation()) {
            return null;
        }
        Object value = this.cache.get(key);
        if (value instanceof VersionedEntry) {
            return ((VersionedEntry)value).getValue();
        }
        return value;
    }

    @Override
    public boolean putFromLoad(SharedSessionContractImplementor session, Object key, Object value, long txTimestamp, Object version) {
        return this.putFromLoad(session, key, value, txTimestamp, version, false);
    }

    @Override
    public boolean putFromLoad(SharedSessionContractImplementor session, Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) throws CacheException {
        Object prev;
        long lastRegionInvalidation = this.region.getLastRegionInvalidation();
        if (txTimestamp < lastRegionInvalidation) {
            log.tracef("putFromLoad not executed since tx started at %d, beforeQuery last region invalidation finished = %d", txTimestamp, lastRegionInvalidation);
            return false;
        }
        assert (version != null);
        if (minimalPutOverride && (prev = this.cache.get(key)) != null) {
            Object oldVersion = this.getVersion(prev);
            if (oldVersion != null) {
                if (this.versionComparator.compare(version, oldVersion) <= 0) {
                    if (trace) {
                        log.tracef("putFromLoad not executed since version(%s) <= oldVersion(%s)", version, oldVersion);
                    }
                    return false;
                }
            } else if (prev instanceof VersionedEntry && txTimestamp <= ((VersionedEntry)prev).getTimestamp()) {
                if (trace) {
                    log.tracef("putFromLoad not executed since tx started at %d and entry was invalidated at %d", txTimestamp, ((VersionedEntry)prev).getTimestamp());
                }
                return false;
            }
        }
        if (!(value instanceof CacheEntry)) {
            value = new VersionedEntry(value, version, txTimestamp);
        }
        this.putFromLoadCache.put(key, value);
        return true;
    }

    @Override
    public boolean insert(SharedSessionContractImplementor session, Object key, Object value, Object version) throws CacheException {
        return false;
    }

    @Override
    public boolean update(SharedSessionContractImplementor session, Object key, Object value, Object currentVersion, Object previousVersion) throws CacheException {
        return false;
    }

    @Override
    public void remove(SharedSessionContractImplementor session, Object key) throws CacheException {
        TransactionCoordinator transactionCoordinator = session.getTransactionCoordinator();
        RemovalSynchronization sync = new RemovalSynchronization(transactionCoordinator, this.writeCache, false, this.region, key);
        transactionCoordinator.getLocalSynchronizations().registerSynchronization((Synchronization)sync);
    }

    @Override
    public void removeAll() throws CacheException {
        this.region.beginInvalidation();
        try {
            Caches.broadcastEvictAll(this.cache);
        }
        finally {
            this.region.endInvalidation();
        }
    }

    @Override
    public void evict(Object key) throws CacheException {
        this.writeCache.put(key, (Object)new VersionedEntry(null, null, this.region.nextTimestamp()), this.region.getTombstoneExpiration(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void evictAll() throws CacheException {
        this.region.beginInvalidation();
        try {
            Caches.broadcastEvictAll(this.cache);
        }
        finally {
            this.region.endInvalidation();
        }
    }

    @Override
    public void unlockItem(SharedSessionContractImplementor session, Object key) throws CacheException {
    }

    @Override
    public boolean afterInsert(SharedSessionContractImplementor session, Object key, Object value, Object version) {
        this.writeCache.put(key, this.getVersioned(value, version, session.getTimestamp()));
        return true;
    }

    @Override
    public boolean afterUpdate(SharedSessionContractImplementor session, Object key, Object value, Object currentVersion, Object previousVersion, SoftLock lock) {
        this.writeCache.put(key, this.getVersioned(value, currentVersion, session.getTimestamp()));
        return true;
    }

    protected Object getVersion(Object value) {
        if (value instanceof CacheEntry) {
            return ((CacheEntry)value).getVersion();
        }
        if (value instanceof VersionedEntry) {
            return ((VersionedEntry)value).getVersion();
        }
        return null;
    }

    protected Object getVersioned(Object value, Object version, long timestamp) {
        assert (value != null);
        assert (version != null);
        return new VersionedEntry(value, version, timestamp);
    }
}

