/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.access;

import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.hibernate.cache.infinispan.util.FutureUpdate;
import org.hibernate.cache.infinispan.util.Tombstone;
import org.hibernate.cache.infinispan.util.TombstoneUpdate;
import org.infinispan.AdvancedCache;
import org.infinispan.commands.read.SizeCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commons.util.CloseableIterable;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.filter.Converter;
import org.infinispan.filter.KeyValueFilter;
import org.infinispan.interceptors.CallInterceptor;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;

public class TombstoneCallInterceptor
extends CallInterceptor {
    private static final UUID ZERO = new UUID(0L, 0L);
    private AdvancedCache cache;
    private final Metadata expiringMetadata;

    public TombstoneCallInterceptor(long tombstoneExpiration) {
        this.expiringMetadata = new EmbeddedMetadata.Builder().lifespan(tombstoneExpiration, TimeUnit.MILLISECONDS).build();
    }

    @Inject
    public void injectDependencies(AdvancedCache cache) {
        this.cache = cache;
    }

    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        MVCCEntry e = (MVCCEntry)ctx.lookupEntry(command.getKey());
        if (e == null) {
            return null;
        }
        Object value = command.getValue();
        if (value instanceof TombstoneUpdate) {
            return this.handleTombstoneUpdate(e, (TombstoneUpdate)value);
        }
        if (value instanceof Tombstone) {
            return this.handleTombstone(e, (Tombstone)value);
        }
        if (value instanceof FutureUpdate) {
            return this.handleFutureUpdate(e, (FutureUpdate)value, command);
        }
        return super.visitPutKeyValueCommand(ctx, command);
    }

    private Object handleFutureUpdate(MVCCEntry e, FutureUpdate futureUpdate, PutKeyValueCommand command) {
        Object storedValue = e.getValue();
        if (storedValue instanceof FutureUpdate) {
            FutureUpdate storedFutureUpdate = (FutureUpdate)storedValue;
            if (futureUpdate.getUuid().equals(storedFutureUpdate.getUuid())) {
                if (futureUpdate.getValue() != null) {
                    this.setValue(e, futureUpdate.getValue());
                } else {
                    this.setValue(e, storedFutureUpdate.getValue());
                }
            } else {
                this.setValue(e, new FutureUpdate(ZERO, null));
                e.setMetadata(this.expiringMetadata);
                command.setMetadata(this.expiringMetadata);
            }
        } else {
            if (storedValue instanceof Tombstone) {
                return null;
            }
            if (futureUpdate.getValue() != null) {
                this.removeValue(e);
            } else {
                this.setValue(e, new FutureUpdate(futureUpdate.getUuid(), null));
            }
        }
        return null;
    }

    private Object handleTombstone(MVCCEntry e, Tombstone tombstone) {
        Object storedValue = e.getValue();
        if (storedValue instanceof Tombstone) {
            e.setChanged(true);
            e.setValue((Object)tombstone.merge((Tombstone)storedValue));
        } else {
            this.setValue(e, tombstone);
        }
        return null;
    }

    protected Object handleTombstoneUpdate(MVCCEntry e, TombstoneUpdate tombstoneUpdate) {
        Object storedValue = e.getValue();
        Object value = tombstoneUpdate.getValue();
        if (storedValue instanceof Tombstone) {
            Tombstone tombstone = (Tombstone)storedValue;
            if (tombstone.getLastTimestamp() < tombstoneUpdate.getTimestamp()) {
                e.setChanged(true);
                e.setValue(value);
            }
        } else if (storedValue == null) {
            this.setValue(e, value);
        } else if (value == null) {
            this.removeValue(e);
        }
        return null;
    }

    private Object setValue(MVCCEntry e, Object value) {
        if (e.isRemoved()) {
            e.setRemoved(false);
            e.setCreated(true);
            e.setValid(true);
        } else {
            e.setChanged(true);
        }
        return e.setValue(value);
    }

    private void removeValue(MVCCEntry e) {
        e.setRemoved(true);
        e.setChanged(true);
        e.setCreated(false);
        e.setValid(false);
        e.setValue(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visitSizeCommand(InvocationContext ctx, SizeCommand command) throws Throwable {
        Set flags = command.getFlags();
        int size = 0;
        Map contextEntries = ctx.getLookedUpEntries();
        AdvancedCache decoratedCache = this.cache.getAdvancedCache().withFlags(flags != null ? flags.toArray(new Flag[flags.size()]) : null);
        try (CloseableIterable iterable = decoratedCache.filterEntries((KeyValueFilter)Tombstone.EXCLUDE_TOMBSTONES).converter((Converter)FutureUpdate.VALUE_EXTRACTOR);){
            for (CacheEntry entry : iterable) {
                if (entry.getValue() == null || size++ != Integer.MAX_VALUE) continue;
                Integer n = Integer.MAX_VALUE;
                return n;
            }
        }
        return size;
    }
}

