/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.entity;

import org.hibernate.cache.CacheException;
import org.hibernate.cache.infinispan.access.AccessDelegate;
import org.hibernate.cache.infinispan.entity.EntityRegionImpl;
import org.hibernate.cache.spi.EntityRegion;
import org.hibernate.cache.spi.access.EntityRegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.entity.EntityPersister;

class ReadOnlyAccess
implements EntityRegionAccessStrategy {
    protected final EntityRegionImpl region;
    protected final AccessDelegate delegate;

    ReadOnlyAccess(EntityRegionImpl region, AccessDelegate delegate) {
        this.region = region;
        this.delegate = delegate;
    }

    public void evict(Object key) throws CacheException {
        this.delegate.evict(key);
    }

    public void evictAll() throws CacheException {
        this.delegate.evictAll();
    }

    public Object get(SharedSessionContractImplementor session, Object key, long txTimestamp) throws CacheException {
        return this.delegate.get(session, key, txTimestamp);
    }

    public EntityRegion getRegion() {
        return this.region;
    }

    public boolean putFromLoad(SharedSessionContractImplementor session, Object key, Object value, long txTimestamp, Object version) throws CacheException {
        return this.delegate.putFromLoad(session, key, value, txTimestamp, version);
    }

    public boolean putFromLoad(SharedSessionContractImplementor session, Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) throws CacheException {
        return this.delegate.putFromLoad(session, key, value, txTimestamp, version, minimalPutOverride);
    }

    public void remove(SharedSessionContractImplementor session, Object key) throws CacheException {
        this.delegate.remove(session, key);
    }

    public void removeAll() throws CacheException {
        this.delegate.removeAll();
    }

    public boolean insert(SharedSessionContractImplementor session, Object key, Object value, Object version) throws CacheException {
        return this.delegate.insert(session, key, value, version);
    }

    public boolean update(SharedSessionContractImplementor session, Object key, Object value, Object currentVersion, Object previousVersion) throws CacheException {
        throw new UnsupportedOperationException("Illegal attempt to edit read only item");
    }

    public SoftLock lockItem(SharedSessionContractImplementor session, Object key, Object version) throws CacheException {
        return null;
    }

    public SoftLock lockRegion() throws CacheException {
        return null;
    }

    public void unlockItem(SharedSessionContractImplementor session, Object key, SoftLock lock) throws CacheException {
        this.delegate.unlockItem(session, key);
    }

    public void unlockRegion(SoftLock lock) throws CacheException {
    }

    public boolean afterInsert(SharedSessionContractImplementor session, Object key, Object value, Object version) throws CacheException {
        return this.delegate.afterInsert(session, key, value, version);
    }

    public boolean afterUpdate(SharedSessionContractImplementor session, Object key, Object value, Object currentVersion, Object previousVersion, SoftLock lock) throws CacheException {
        throw new UnsupportedOperationException("Illegal attempt to edit read only item");
    }

    public Object generateCacheKey(Object id, EntityPersister persister, SessionFactoryImplementor factory, String tenantIdentifier) {
        return this.region.getCacheKeysFactory().createEntityKey(id, persister, factory, tenantIdentifier);
    }

    public Object getCacheKeyId(Object cacheKey) {
        return this.region.getCacheKeysFactory().getEntityId(cacheKey);
    }
}

