/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.dialect.Oracle8iDialect;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.internal.entities.PropertyData;
import org.hibernate.envers.internal.entities.mapper.PersistentCollectionChangeData;
import org.hibernate.envers.internal.entities.mapper.PropertyMapper;
import org.hibernate.envers.internal.entities.mapper.SimpleMapperBuilder;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.internal.tools.ReflectionTools;
import org.hibernate.envers.internal.tools.StringTools;
import org.hibernate.internal.util.compare.EqualsHelper;
import org.hibernate.property.access.spi.Setter;
import org.hibernate.property.access.spi.SetterFieldImpl;

public class SinglePropertyMapper
implements PropertyMapper,
SimpleMapperBuilder {
    private PropertyData propertyData;

    public SinglePropertyMapper(PropertyData propertyData) {
        this.propertyData = propertyData;
    }

    public SinglePropertyMapper() {
    }

    @Override
    public void add(PropertyData propertyData) {
        if (this.propertyData != null) {
            throw new AuditException("Only one property can be added!");
        }
        this.propertyData = propertyData;
    }

    @Override
    public boolean mapToMapFromEntity(SessionImplementor session, Map<String, Object> data, Object newObj, Object oldObj) {
        data.put(this.propertyData.getName(), newObj);
        boolean dbLogicallyDifferent = true;
        if (session.getFactory().getJdbcServices().getDialect() instanceof Oracle8iDialect && (newObj instanceof String || oldObj instanceof String)) {
            dbLogicallyDifferent = !StringTools.isEmpty(newObj) || !StringTools.isEmpty(oldObj);
        }
        return dbLogicallyDifferent && !EqualsHelper.areEqual((Object)newObj, (Object)oldObj);
    }

    @Override
    public void mapModifiedFlagsToMapFromEntity(SessionImplementor session, Map<String, Object> data, Object newObj, Object oldObj) {
        if (this.propertyData.isUsingModifiedFlag()) {
            data.put(this.propertyData.getModifiedFlagPropertyName(), !EqualsHelper.areEqual((Object)newObj, (Object)oldObj));
        }
    }

    @Override
    public void mapModifiedFlagsToMapForCollectionChange(String collectionPropertyName, Map<String, Object> data) {
    }

    @Override
    public void mapToEntityFromMap(EnversService enversService, Object obj, Map data, Object primaryKey, AuditReaderImplementor versionsReader, Number revision) {
        if (data == null || obj == null) {
            return;
        }
        Setter setter = ReflectionTools.getSetter(obj.getClass(), this.propertyData, enversService.getServiceRegistry());
        Object value = data.get(this.propertyData.getName());
        if (value != null || !this.isPrimitive(setter, this.propertyData, obj.getClass())) {
            setter.set(obj, value, null);
        }
    }

    private boolean isPrimitive(Setter setter, PropertyData propertyData, Class<?> cls) {
        if (cls == null) {
            throw new HibernateException("No field found for property: " + propertyData.getName());
        }
        if (setter instanceof SetterFieldImpl) {
            try {
                return cls.getDeclaredField(propertyData.getBeanName()).getType().isPrimitive();
            }
            catch (NoSuchFieldException e) {
                return this.isPrimitive(setter, propertyData, cls.getSuperclass());
            }
        }
        return setter.getMethod().getParameterTypes()[0].isPrimitive();
    }

    @Override
    public List<PersistentCollectionChangeData> mapCollectionChanges(SessionImplementor sessionImplementor, String referencingPropertyName, PersistentCollection newColl, Serializable oldColl, Serializable id) {
        return null;
    }
}

