/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.jdbc;

import com.sybase.jdbc4.jdbc.RawInputStream;
import com.sybase.jdbc4.utils.CacheManager;
import java.io.IOException;
import java.io.InputStream;

public abstract class PadByteInputStream
extends RawInputStream {
    protected int _padByteLengthRemaining;
    protected int[] _bytes = new int[2];
    protected boolean _even;

    public PadByteInputStream(InputStream inputStream, int n2, int n3, CacheManager cacheManager) throws IOException {
        super(inputStream, n2, n3, cacheManager);
        this._padByteLengthRemaining = n3 * 2;
        this._even = true;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (this._padByteLengthRemaining == 0) {
            return -1;
        }
        n3 = n3 < this._padByteLengthRemaining ? n3 : this._padByteLengthRemaining;
        for (int i2 = n2; i2 < n3; ++i2) {
            byArray[i2] = (byte)this.read();
        }
        return n3;
    }

    @Override
    public int available() throws IOException {
        int n2 = super.available() * 2;
        return this._even ? n2 : ++n2;
    }

    @Override
    public long skip(long l2) throws IOException {
        l2 = l2 < (long)this._padByteLengthRemaining ? l2 : (long)this._padByteLengthRemaining;
        int n2 = 0;
        while ((long)n2 < l2) {
            this.read();
            ++n2;
        }
        return l2;
    }
}

