/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan;

import org.hibernate.cache.internal.CacheDataDescriptionImpl;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.access.RegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.compare.ComparableComparator;
import org.hibernate.test.cache.infinispan.AbstractNonFunctionalTest;
import org.hibernate.test.cache.infinispan.NodeEnvironment;
import org.hibernate.test.cache.infinispan.util.InfinispanTestingSetup;
import org.hibernate.test.cache.infinispan.util.TestingKeyFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;

public abstract class AbstractExtraAPITest<S extends RegionAccessStrategy>
extends AbstractNonFunctionalTest {
    @Rule
    public InfinispanTestingSetup infinispanTestIdentifier = new InfinispanTestingSetup();
    public static final String REGION_NAME = "test/com.foo.test";
    public static final Object KEY = TestingKeyFactory.generateCollectionCacheKey("KEY");
    public static final CacheDataDescription CACHE_DATA_DESCRIPTION = new CacheDataDescriptionImpl(true, true, ComparableComparator.INSTANCE, null);
    protected static final SharedSessionContractImplementor SESSION = (SharedSessionContractImplementor)Mockito.mock(SharedSessionContractImplementor.class);
    protected S accessStrategy;
    protected NodeEnvironment environment;

    @Before
    public final void prepareLocalAccessStrategy() throws Exception {
        this.environment = new NodeEnvironment(this.createStandardServiceRegistryBuilder());
        this.environment.prepare();
        this.avoidConcurrentFlush();
        this.accessStrategy = this.getAccessStrategy();
    }

    protected abstract S getAccessStrategy();

    @After
    public final void releaseLocalAccessStrategy() throws Exception {
        if (this.environment != null) {
            this.environment.release();
        }
    }

    @Test
    public void testLockItem() {
        Assert.assertNull((Object)this.accessStrategy.lockItem(SESSION, KEY, (Object)1));
    }

    @Test
    public void testLockRegion() {
        Assert.assertNull((Object)this.accessStrategy.lockRegion());
    }

    @Test
    public void testUnlockItem() {
        this.accessStrategy.unlockItem(SESSION, KEY, (SoftLock)new MockSoftLock());
    }

    @Test
    public void testUnlockRegion() {
        this.accessStrategy.unlockItem(SESSION, KEY, (SoftLock)new MockSoftLock());
    }

    public static class MockSoftLock
    implements SoftLock {
    }
}

