/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cache.infinispan.InfinispanRegionFactory;
import org.hibernate.cache.infinispan.impl.BaseGeneralDataRegion;
import org.hibernate.cache.spi.GeneralDataRegion;
import org.hibernate.cache.spi.Region;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.test.cache.infinispan.AbstractRegionImplTest;
import org.hibernate.test.cache.infinispan.util.CacheTestUtil;
import org.hibernate.test.cache.infinispan.util.TestInfinispanRegionFactory;
import org.infinispan.AdvancedCache;
import org.infinispan.CacheSet;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractGeneralDataRegionTest
extends AbstractRegionImplTest {
    private static final Logger log = Logger.getLogger(AbstractGeneralDataRegionTest.class);
    protected static final String KEY = "Key";
    protected static final String VALUE1 = "value1";
    protected static final String VALUE2 = "value2";
    protected static final String VALUE3 = "value3";

    @Override
    protected void putInRegion(Region region, Object key, Object value) {
        ((GeneralDataRegion)region).put(null, key, value);
    }

    @Override
    protected void removeFromRegion(Region region, Object key) {
        ((GeneralDataRegion)region).evict(key);
    }

    @Test
    public void testEvict() throws Exception {
        this.evictOrRemoveTest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void withSessionFactoriesAndRegions(int num, SFRConsumer consumer) throws Exception {
        StandardServiceRegistryBuilder ssrb = this.createStandardServiceRegistryBuilder().applySetting("hibernate.cache.region.factory_class", (Object)TestInfinispanRegionFactory.class.getName());
        Properties properties = CacheTestUtil.toProperties(ssrb.getSettings());
        ArrayList<StandardServiceRegistry> registries = new ArrayList<StandardServiceRegistry>();
        ArrayList<SessionFactory> sessionFactories = new ArrayList<SessionFactory>();
        ArrayList<GeneralDataRegion> regions = new ArrayList<GeneralDataRegion>();
        for (int i = 0; i < num; ++i) {
            StandardServiceRegistry registry = ssrb.build();
            registries.add(registry);
            SessionFactory sessionFactory = new MetadataSources((ServiceRegistry)registry).buildMetadata().buildSessionFactory();
            sessionFactories.add(sessionFactory);
            InfinispanRegionFactory regionFactory = (InfinispanRegionFactory)registry.getService(RegionFactory.class);
            GeneralDataRegion region = (GeneralDataRegion)this.createRegion(regionFactory, this.getStandardRegionName("test"), properties, null);
            regions.add(region);
        }
        try {
            consumer.accept(sessionFactories, regions);
        }
        finally {
            for (SessionFactory sessionFactory : sessionFactories) {
                sessionFactory.close();
            }
            for (StandardServiceRegistry registry : registries) {
                StandardServiceRegistryBuilder.destroy((ServiceRegistry)registry);
            }
        }
    }

    private void evictOrRemoveTest() throws Exception {
        this.withSessionFactoriesAndRegions(2, (sessionFactories, regions) -> {
            GeneralDataRegion localRegion = (GeneralDataRegion)regions.get(0);
            GeneralDataRegion remoteRegion = (GeneralDataRegion)regions.get(1);
            SharedSessionContractImplementor localSession = (SharedSessionContractImplementor)((SessionFactory)sessionFactories.get(0)).openSession();
            SharedSessionContractImplementor remoteSession = (SharedSessionContractImplementor)((SessionFactory)sessionFactories.get(1)).openSession();
            try {
                Assert.assertNull((String)"local is clean", (Object)localRegion.get(localSession, (Object)KEY));
                Assert.assertNull((String)"remote is clean", (Object)remoteRegion.get(remoteSession, (Object)KEY));
                Transaction tx = ((Session)localSession).getTransaction();
                tx.begin();
                try {
                    localRegion.put(localSession, (Object)KEY, (Object)VALUE1);
                    tx.commit();
                }
                catch (Exception e) {
                    tx.rollback();
                    throw e;
                }
                Callable<Object> getFromLocalRegion = () -> localRegion.get(localSession, (Object)KEY);
                Callable<Object> getFromRemoteRegion = () -> remoteRegion.get(remoteSession, (Object)KEY);
                CacheTestUtil.assertEqualsEventually(VALUE1, getFromLocalRegion, 10L, TimeUnit.SECONDS);
                CacheTestUtil.assertEqualsEventually(VALUE1, getFromRemoteRegion, 10L, TimeUnit.SECONDS);
                this.regionEvict(localRegion);
                CacheTestUtil.assertEqualsEventually(null, getFromLocalRegion, 10L, TimeUnit.SECONDS);
                CacheTestUtil.assertEqualsEventually(null, getFromRemoteRegion, 10L, TimeUnit.SECONDS);
            }
            finally {
                ((Session)localSession).close();
                ((Session)remoteSession).close();
            }
        });
    }

    protected void regionEvict(GeneralDataRegion region) throws Exception {
        region.evict((Object)KEY);
    }

    protected abstract String getStandardRegionName(String var1);

    public void testEvictAll() throws Exception {
        this.evictOrRemoveAllTest("entity");
    }

    private void evictOrRemoveAllTest(String configName) throws Exception {
        this.withSessionFactoriesAndRegions(2, (sessionFactories, regions) -> {
            GeneralDataRegion localRegion = (GeneralDataRegion)regions.get(0);
            GeneralDataRegion remoteRegion = (GeneralDataRegion)regions.get(1);
            AdvancedCache localCache = ((BaseGeneralDataRegion)localRegion).getCache();
            AdvancedCache remoteCache = ((BaseGeneralDataRegion)remoteRegion).getCache();
            SharedSessionContractImplementor localSession = (SharedSessionContractImplementor)((SessionFactory)sessionFactories.get(0)).openSession();
            SharedSessionContractImplementor remoteSession = (SharedSessionContractImplementor)((SessionFactory)sessionFactories.get(1)).openSession();
            try {
                CacheSet localKeys = localCache.keySet();
                Assert.assertEquals((String)("No valid children in " + localKeys), (long)0L, (long)localKeys.size());
                CacheSet remoteKeys = remoteCache.keySet();
                Assert.assertEquals((String)("No valid children in " + remoteKeys), (long)0L, (long)remoteKeys.size());
                Assert.assertNull((String)"local is clean", (Object)localRegion.get(null, (Object)KEY));
                Assert.assertNull((String)"remote is clean", (Object)remoteRegion.get(null, (Object)KEY));
                localRegion.put(localSession, (Object)KEY, (Object)VALUE1);
                Assert.assertEquals((Object)VALUE1, (Object)localRegion.get(null, (Object)KEY));
                this.sleep(250L);
                remoteRegion.put(remoteSession, (Object)KEY, (Object)VALUE1);
                Assert.assertEquals((Object)VALUE1, (Object)remoteRegion.get(null, (Object)KEY));
                this.sleep(250L);
                localRegion.evictAll();
                this.sleep(250L);
                Assert.assertNull((Object)localRegion.get(null, (Object)KEY));
                localKeys = localCache.keySet();
                Assert.assertEquals((String)("No valid children in " + localKeys), (long)0L, (long)localKeys.size());
                Assert.assertEquals(null, (Object)remoteRegion.get(null, (Object)KEY));
                remoteKeys = remoteCache.keySet();
                Assert.assertEquals((String)("No valid children in " + remoteKeys), (long)0L, (long)remoteKeys.size());
                Assert.assertEquals((String)"local is clean", null, (Object)localRegion.get(null, (Object)KEY));
                Assert.assertEquals((String)"remote is clean", null, (Object)remoteRegion.get(null, (Object)KEY));
            }
            finally {
                ((Session)localSession).close();
                ((Session)remoteSession).close();
            }
        });
    }

    protected static interface SFRConsumer {
        public void accept(List<SessionFactory> var1, List<GeneralDataRegion> var2) throws Exception;
    }
}

