/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import junit.framework.AssertionFailedError;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cache.infinispan.impl.BaseRegion;
import org.hibernate.cache.infinispan.util.Caches;
import org.hibernate.cache.internal.CacheDataDescriptionImpl;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.access.RegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.transaction.internal.TransactionImpl;
import org.hibernate.internal.util.compare.ComparableComparator;
import org.hibernate.resource.jdbc.spi.JdbcSessionContext;
import org.hibernate.resource.jdbc.spi.JdbcSessionOwner;
import org.hibernate.resource.transaction.backend.jdbc.internal.JdbcResourceLocalTransactionCoordinatorBuilderImpl;
import org.hibernate.resource.transaction.backend.jdbc.spi.JdbcResourceTransactionAccess;
import org.hibernate.resource.transaction.spi.TransactionCoordinator;
import org.hibernate.resource.transaction.spi.TransactionCoordinatorOwner;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.test.cache.infinispan.AbstractNonFunctionalTest;
import org.hibernate.test.cache.infinispan.NodeEnvironment;
import org.hibernate.test.cache.infinispan.util.BatchModeJtaPlatform;
import org.hibernate.test.cache.infinispan.util.BatchModeTransactionCoordinator;
import org.hibernate.test.cache.infinispan.util.InfinispanTestingSetup;
import org.hibernate.test.cache.infinispan.util.JdbcResourceTransactionMock;
import org.hibernate.test.cache.infinispan.util.TestSynchronization;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.test.TestingUtil;
import org.jboss.logging.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;

public abstract class AbstractRegionAccessStrategyTest<R extends BaseRegion, S extends RegionAccessStrategy>
extends AbstractNonFunctionalTest {
    protected final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    @Rule
    public InfinispanTestingSetup infinispanTestIdentifier = new InfinispanTestingSetup();
    public static final String REGION_NAME = "test/com.foo.test";
    public static final String KEY_BASE = "KEY";
    public static final String VALUE1 = "VALUE1";
    public static final String VALUE2 = "VALUE2";
    public static final CacheDataDescription CACHE_DATA_DESCRIPTION = new CacheDataDescriptionImpl(true, true, ComparableComparator.INSTANCE, null);
    protected NodeEnvironment localEnvironment;
    protected R localRegion;
    protected S localAccessStrategy;
    protected NodeEnvironment remoteEnvironment;
    protected R remoteRegion;
    protected S remoteAccessStrategy;
    protected boolean transactional;
    protected boolean invalidation;
    protected boolean synchronous;
    protected Exception node1Exception;
    protected Exception node2Exception;
    protected AssertionFailedError node1Failure;
    protected AssertionFailedError node2Failure;

    @Override
    protected boolean canUseLocalMode() {
        return false;
    }

    @Before
    public void prepareResources() throws Exception {
        StandardServiceRegistryBuilder ssrb = this.createStandardServiceRegistryBuilder();
        this.localEnvironment = new NodeEnvironment(ssrb);
        this.localEnvironment.prepare();
        this.localRegion = this.getRegion(this.localEnvironment);
        this.localAccessStrategy = this.getAccessStrategy(this.localRegion);
        this.transactional = Caches.isTransactionalCache((AdvancedCache)this.localRegion.getCache());
        this.invalidation = Caches.isInvalidationCache((AdvancedCache)this.localRegion.getCache());
        this.synchronous = Caches.isSynchronousCache((AdvancedCache)this.localRegion.getCache());
        this.avoidConcurrentFlush();
        this.remoteEnvironment = new NodeEnvironment(ssrb);
        this.remoteEnvironment.prepare();
        this.remoteRegion = this.getRegion(this.remoteEnvironment);
        this.remoteAccessStrategy = this.getAccessStrategy(this.remoteRegion);
        this.waitForClusterToForm(new Cache[]{this.localRegion.getCache(), this.remoteRegion.getCache()});
    }

    protected SharedSessionContractImplementor mockedSession() {
        SessionMock session = (SessionMock)Mockito.mock(SessionMock.class);
        Mockito.when((Object)session.isClosed()).thenReturn((Object)false);
        Mockito.when((Object)session.getTimestamp()).thenReturn((Object)System.currentTimeMillis());
        if (this.jtaPlatform == BatchModeJtaPlatform.class) {
            BatchModeTransactionCoordinator txCoord = new BatchModeTransactionCoordinator();
            Mockito.when((Object)session.getTransactionCoordinator()).thenReturn((Object)txCoord);
            Mockito.when((Object)session.beginTransaction()).then(invocation -> {
                Transaction tx = txCoord.newTransaction();
                tx.begin();
                return tx;
            });
        } else if (this.jtaPlatform == null) {
            Connection connection = (Connection)Mockito.mock(Connection.class);
            JdbcConnectionAccess jdbcConnectionAccess = (JdbcConnectionAccess)Mockito.mock(JdbcConnectionAccess.class);
            try {
                Mockito.when((Object)jdbcConnectionAccess.obtainConnection()).thenReturn((Object)connection);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            JdbcSessionOwner jdbcSessionOwner = (JdbcSessionOwner)Mockito.mock(JdbcSessionOwner.class);
            Mockito.when((Object)jdbcSessionOwner.getJdbcConnectionAccess()).thenReturn((Object)jdbcConnectionAccess);
            SqlExceptionHelper sqlExceptionHelper = (SqlExceptionHelper)Mockito.mock(SqlExceptionHelper.class);
            JdbcServices jdbcServices = (JdbcServices)Mockito.mock(JdbcServices.class);
            Mockito.when((Object)jdbcServices.getSqlExceptionHelper()).thenReturn((Object)sqlExceptionHelper);
            ServiceRegistry serviceRegistry = (ServiceRegistry)Mockito.mock(ServiceRegistry.class);
            Mockito.when((Object)serviceRegistry.getService(JdbcServices.class)).thenReturn((Object)jdbcServices);
            JdbcSessionContext jdbcSessionContext = (JdbcSessionContext)Mockito.mock(JdbcSessionContext.class);
            Mockito.when((Object)jdbcSessionContext.getServiceRegistry()).thenReturn((Object)serviceRegistry);
            Mockito.when((Object)jdbcSessionOwner.getJdbcSessionContext()).thenReturn((Object)jdbcSessionContext);
            NonJtaTransactionCoordinator txOwner = (NonJtaTransactionCoordinator)Mockito.mock(NonJtaTransactionCoordinator.class);
            Mockito.when((Object)txOwner.getResourceLocalTransaction()).thenReturn((Object)new JdbcResourceTransactionMock());
            Mockito.when((Object)txOwner.getJdbcSessionOwner()).thenReturn((Object)jdbcSessionOwner);
            TransactionCoordinator txCoord = JdbcResourceLocalTransactionCoordinatorBuilderImpl.INSTANCE.buildTransactionCoordinator((TransactionCoordinatorOwner)txOwner, null);
            Mockito.when((Object)session.getTransactionCoordinator()).thenReturn((Object)txCoord);
            Mockito.when((Object)session.beginTransaction()).then(invocation -> {
                TransactionImpl tx = new TransactionImpl(txCoord, session.getExceptionConverter());
                tx.begin();
                return tx;
            });
        } else {
            throw new IllegalStateException("Unknown JtaPlatform: " + this.jtaPlatform);
        }
        return session;
    }

    protected abstract S getAccessStrategy(R var1);

    @Test
    public void testRemove() throws Exception {
        this.evictOrRemoveTest(false);
    }

    @Test
    public void testEvict() throws Exception {
        this.evictOrRemoveTest(true);
    }

    protected abstract R getRegion(NodeEnvironment var1);

    protected void waitForClusterToForm(Cache ... caches) {
        TestingUtil.blockUntilViewsReceived((int)10000, Arrays.asList(caches));
    }

    @After
    public void releaseResources() throws Exception {
        try {
            if (this.localEnvironment != null) {
                this.localEnvironment.release();
            }
        }
        finally {
            if (this.remoteEnvironment != null) {
                this.remoteEnvironment.release();
            }
        }
    }

    protected boolean isTransactional() {
        return this.transactional;
    }

    protected boolean isUsingInvalidation() {
        return this.invalidation;
    }

    protected boolean isSynchronous() {
        return this.synchronous;
    }

    protected void evictOrRemoveTest(boolean evict) throws Exception {
        Object KEY = this.generateNextKey();
        Assert.assertEquals((long)0L, (long)this.localRegion.getCache().size());
        Assert.assertEquals((long)0L, (long)this.remoteRegion.getCache().size());
        SharedSessionContractImplementor s1 = this.mockedSession();
        Assert.assertNull((String)"local is clean", (Object)this.localAccessStrategy.get(s1, KEY, s1.getTimestamp()));
        SharedSessionContractImplementor s2 = this.mockedSession();
        Assert.assertNull((String)"remote is clean", (Object)this.remoteAccessStrategy.get(s2, KEY, s2.getTimestamp()));
        SharedSessionContractImplementor s3 = this.mockedSession();
        this.localAccessStrategy.putFromLoad(s3, KEY, (Object)VALUE1, s3.getTimestamp(), (Object)1);
        SharedSessionContractImplementor s4 = this.mockedSession();
        Assert.assertEquals((Object)VALUE1, (Object)this.localAccessStrategy.get(s4, KEY, s4.getTimestamp()));
        SharedSessionContractImplementor s5 = this.mockedSession();
        this.remoteAccessStrategy.putFromLoad(s5, KEY, (Object)VALUE1, s5.getTimestamp(), (Object)new Integer(1));
        SharedSessionContractImplementor s6 = this.mockedSession();
        Assert.assertEquals((Object)VALUE1, (Object)this.remoteAccessStrategy.get(s6, KEY, s6.getTimestamp()));
        SharedSessionContractImplementor session = this.mockedSession();
        this.withTx(this.localEnvironment, session, () -> {
            if (evict) {
                this.localAccessStrategy.evict(KEY);
            } else {
                this.doRemove(this.localRegion.getTransactionManager(), this.localAccessStrategy, session, KEY);
            }
            return null;
        });
        SharedSessionContractImplementor s7 = this.mockedSession();
        Assert.assertNull((Object)this.localAccessStrategy.get(s7, KEY, s7.getTimestamp()));
        Assert.assertEquals((long)0L, (long)this.localRegion.getCache().size());
        SharedSessionContractImplementor s8 = this.mockedSession();
        Assert.assertNull((Object)this.remoteAccessStrategy.get(s8, KEY, s8.getTimestamp()));
        Assert.assertEquals((long)0L, (long)this.remoteRegion.getCache().size());
    }

    protected void doRemove(TransactionManager tm, S strategy, SharedSessionContractImplementor session, Object key) throws SystemException, RollbackException {
        SoftLock softLock = strategy.lockItem(session, key, null);
        strategy.remove(session, key);
        session.getTransactionCoordinator().getLocalSynchronizations().registerSynchronization((Synchronization)new TestSynchronization.UnlockItem((RegionAccessStrategy)strategy, session, key, softLock));
    }

    @Test
    public void testRemoveAll() throws Exception {
        this.evictOrRemoveAllTest(false);
    }

    @Test
    public void testEvictAll() throws Exception {
        this.evictOrRemoveAllTest(true);
    }

    protected void assertThreadsRanCleanly() {
        if (this.node1Failure != null) {
            throw this.node1Failure;
        }
        if (this.node2Failure != null) {
            throw this.node2Failure;
        }
        if (this.node1Exception != null) {
            this.log.error((Object)"node1 saw an exception", (Throwable)this.node1Exception);
            Assert.assertEquals((String)"node1 saw no exceptions", null, (Object)this.node1Exception);
        }
        if (this.node2Exception != null) {
            this.log.error((Object)"node2 saw an exception", (Throwable)this.node2Exception);
            Assert.assertEquals((String)"node2 saw no exceptions", null, (Object)this.node2Exception);
        }
    }

    protected abstract Object generateNextKey();

    protected void evictOrRemoveAllTest(boolean evict) throws Exception {
        Object KEY = this.generateNextKey();
        Assert.assertEquals((long)0L, (long)this.localRegion.getCache().size());
        Assert.assertEquals((long)0L, (long)this.remoteRegion.getCache().size());
        SharedSessionContractImplementor s1 = this.mockedSession();
        Assert.assertNull((String)"local is clean", (Object)this.localAccessStrategy.get(s1, KEY, s1.getTimestamp()));
        SharedSessionContractImplementor s2 = this.mockedSession();
        Assert.assertNull((String)"remote is clean", (Object)this.remoteAccessStrategy.get(s2, KEY, s2.getTimestamp()));
        SharedSessionContractImplementor s3 = this.mockedSession();
        this.localAccessStrategy.putFromLoad(s3, KEY, (Object)VALUE1, s3.getTimestamp(), (Object)1);
        SharedSessionContractImplementor s4 = this.mockedSession();
        Assert.assertEquals((Object)VALUE1, (Object)this.localAccessStrategy.get(s4, KEY, s4.getTimestamp()));
        SharedSessionContractImplementor s5 = this.mockedSession();
        this.remoteAccessStrategy.putFromLoad(s5, KEY, (Object)VALUE1, s5.getTimestamp(), (Object)1);
        SharedSessionContractImplementor s6 = this.mockedSession();
        Assert.assertEquals((Object)VALUE1, (Object)this.remoteAccessStrategy.get(s6, KEY, s6.getTimestamp()));
        this.sleep(250L);
        this.withTx(this.localEnvironment, this.mockedSession(), () -> {
            if (evict) {
                this.localAccessStrategy.evictAll();
            } else {
                SoftLock softLock = this.localAccessStrategy.lockRegion();
                this.localAccessStrategy.removeAll();
                this.localAccessStrategy.unlockRegion(softLock);
            }
            return null;
        });
        SharedSessionContractImplementor s7 = this.mockedSession();
        Assert.assertNull((Object)this.localAccessStrategy.get(s7, KEY, s7.getTimestamp()));
        Assert.assertEquals((long)0L, (long)this.localRegion.getCache().size());
        SharedSessionContractImplementor s8 = this.mockedSession();
        Assert.assertNull((Object)this.remoteAccessStrategy.get(s8, KEY, s8.getTimestamp()));
        Assert.assertEquals((long)0L, (long)this.remoteRegion.getCache().size());
        this.sleep(250L);
        SharedSessionContractImplementor s9 = this.mockedSession();
        Assert.assertTrue((boolean)this.remoteAccessStrategy.putFromLoad(s9, KEY, (Object)VALUE1, s9.getTimestamp(), (Object)1));
        SharedSessionContractImplementor s10 = this.mockedSession();
        Assert.assertEquals((Object)VALUE1, (Object)this.remoteAccessStrategy.get(s10, KEY, s10.getTimestamp()));
        Assert.assertEquals((long)1L, (long)this.remoteRegion.getCache().size());
        this.sleep(250L);
        SharedSessionContractImplementor s11 = this.mockedSession();
        Assert.assertEquals((Object)(this.isUsingInvalidation() ? null : VALUE1), (Object)this.localAccessStrategy.get(s11, KEY, s11.getTimestamp()));
        SharedSessionContractImplementor s12 = this.mockedSession();
        Assert.assertEquals((Object)VALUE1, (Object)this.remoteAccessStrategy.get(s12, KEY, s12.getTimestamp()));
    }

    protected class PutFromLoadNode2
    extends Thread {
        private final Object KEY;
        private final CountDownLatch writeLatch1;
        private final CountDownLatch writeLatch2;
        private final boolean useMinimalAPI;
        private final CountDownLatch completionLatch;

        public PutFromLoadNode2(Object KEY, CountDownLatch writeLatch1, CountDownLatch writeLatch2, boolean useMinimalAPI, CountDownLatch completionLatch) {
            this.KEY = KEY;
            this.writeLatch1 = writeLatch1;
            this.writeLatch2 = writeLatch2;
            this.useMinimalAPI = useMinimalAPI;
            this.completionLatch = completionLatch;
        }

        @Override
        public void run() {
            try {
                SharedSessionContractImplementor session = AbstractRegionAccessStrategyTest.this.mockedSession();
                AbstractRegionAccessStrategyTest.this.withTx(AbstractRegionAccessStrategyTest.this.remoteEnvironment, session, () -> {
                    Assert.assertNull((Object)AbstractRegionAccessStrategyTest.this.remoteAccessStrategy.get(session, this.KEY, session.getTimestamp()));
                    this.writeLatch1.countDown();
                    this.writeLatch2.await();
                    if (this.useMinimalAPI) {
                        AbstractRegionAccessStrategyTest.this.remoteAccessStrategy.putFromLoad(session, this.KEY, (Object)AbstractRegionAccessStrategyTest.VALUE1, session.getTimestamp(), (Object)1, true);
                    } else {
                        AbstractRegionAccessStrategyTest.this.remoteAccessStrategy.putFromLoad(session, this.KEY, (Object)AbstractRegionAccessStrategyTest.VALUE1, session.getTimestamp(), (Object)1);
                    }
                    return null;
                });
            }
            catch (Exception e) {
                AbstractRegionAccessStrategyTest.this.log.error((Object)"node2 caught exception", (Throwable)e);
                AbstractRegionAccessStrategyTest.this.node2Exception = e;
            }
            catch (AssertionFailedError e) {
                AbstractRegionAccessStrategyTest.this.node2Failure = e;
            }
            finally {
                this.completionLatch.countDown();
            }
        }
    }

    private static interface NonJtaTransactionCoordinator
    extends TransactionCoordinatorOwner,
    JdbcResourceTransactionAccess {
    }

    private static interface SessionMock
    extends Session,
    SharedSessionContractImplementor {
    }
}

