/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan.access;

import java.lang.reflect.Method;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.transaction.TransactionManager;
import org.hibernate.cache.infinispan.InfinispanRegionFactory;
import org.hibernate.cache.infinispan.access.PutFromLoadValidator;
import org.hibernate.cache.infinispan.util.InfinispanMessageLogger;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.test.cache.infinispan.functional.cluster.DualNodeJtaTransactionManagerImpl;
import org.hibernate.test.cache.infinispan.util.CacheTestUtil;
import org.hibernate.test.cache.infinispan.util.InfinispanTestingSetup;
import org.hibernate.testing.TestForIssue;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;

public class PutFromLoadValidatorUnitTest {
    private static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(PutFromLoadValidatorUnitTest.class);
    @Rule
    public InfinispanTestingSetup infinispanTestIdentifier = new InfinispanTestingSetup();
    private Object KEY1 = "KEY1";
    private TransactionManager tm;

    @Before
    public void setUp() throws Exception {
        this.tm = DualNodeJtaTransactionManagerImpl.getInstance("test");
    }

    @After
    public void tearDown() throws Exception {
        this.tm = null;
        try {
            DualNodeJtaTransactionManagerImpl.cleanupTransactions();
        }
        finally {
            DualNodeJtaTransactionManagerImpl.cleanupTransactionManagers();
        }
    }

    private static EmbeddedCacheManager createCacheManager() {
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createCacheManager((boolean)false);
        return cacheManager;
    }

    private static InfinispanRegionFactory regionFactory(EmbeddedCacheManager cm) {
        InfinispanRegionFactory regionFactory = new InfinispanRegionFactory();
        regionFactory.setCacheManager(cm);
        regionFactory.start(CacheTestUtil.sfOptionsForStart(), new Properties());
        return regionFactory;
    }

    @Test
    public void testNakedPut() throws Exception {
        this.nakedPutTest(false);
    }

    @Test
    public void testNakedPutTransactional() throws Exception {
        this.nakedPutTest(true);
    }

    private void nakedPutTest(final boolean transactional) throws Exception {
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(PutFromLoadValidatorUnitTest.createCacheManager()){

            public void call() {
                PutFromLoadValidator testee = new PutFromLoadValidator(this.cm.getCache().getAdvancedCache(), PutFromLoadValidatorUnitTest.regionFactory(this.cm));
                PutFromLoadValidatorUnitTest.this.exec(transactional, new NakedPut(testee, true));
            }
        });
    }

    @Test
    public void testRegisteredPut() throws Exception {
        this.registeredPutTest(false);
    }

    @Test
    public void testRegisteredPutTransactional() throws Exception {
        this.registeredPutTest(true);
    }

    private void registeredPutTest(final boolean transactional) throws Exception {
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(PutFromLoadValidatorUnitTest.createCacheManager()){

            public void call() {
                PutFromLoadValidator testee = new PutFromLoadValidator(this.cm.getCache().getAdvancedCache(), PutFromLoadValidatorUnitTest.regionFactory(this.cm));
                PutFromLoadValidatorUnitTest.this.exec(transactional, new RegularPut(testee));
            }
        });
    }

    @Test
    public void testNakedPutAfterKeyRemoval() throws Exception {
        this.nakedPutAfterRemovalTest(false, false);
    }

    @Test
    public void testNakedPutAfterKeyRemovalTransactional() throws Exception {
        this.nakedPutAfterRemovalTest(true, false);
    }

    @Test
    public void testNakedPutAfterRegionRemoval() throws Exception {
        this.nakedPutAfterRemovalTest(false, true);
    }

    @Test
    public void testNakedPutAfterRegionRemovalTransactional() throws Exception {
        this.nakedPutAfterRemovalTest(true, true);
    }

    private void nakedPutAfterRemovalTest(final boolean transactional, final boolean removeRegion) throws Exception {
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(PutFromLoadValidatorUnitTest.createCacheManager()){

            public void call() {
                PutFromLoadValidator testee = new PutFromLoadValidator(this.cm.getCache().getAdvancedCache(), PutFromLoadValidatorUnitTest.regionFactory(this.cm));
                Invalidation invalidation = new Invalidation(testee, removeRegion);
                NakedPut nakedPut = new NakedPut(testee, true);
                PutFromLoadValidatorUnitTest.this.exec(transactional, invalidation, nakedPut);
            }
        });
    }

    @Test
    public void testRegisteredPutAfterKeyRemoval() throws Exception {
        this.registeredPutAfterRemovalTest(false, false);
    }

    @Test
    public void testRegisteredPutAfterKeyRemovalTransactional() throws Exception {
        this.registeredPutAfterRemovalTest(true, false);
    }

    @Test
    public void testRegisteredPutAfterRegionRemoval() throws Exception {
        this.registeredPutAfterRemovalTest(false, true);
    }

    @Test
    public void testRegisteredPutAfterRegionRemovalTransactional() throws Exception {
        this.registeredPutAfterRemovalTest(true, true);
    }

    private void registeredPutAfterRemovalTest(final boolean transactional, final boolean removeRegion) throws Exception {
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(PutFromLoadValidatorUnitTest.createCacheManager()){

            public void call() {
                PutFromLoadValidator testee = new PutFromLoadValidator(this.cm.getCache().getAdvancedCache(), PutFromLoadValidatorUnitTest.regionFactory(this.cm));
                Invalidation invalidation = new Invalidation(testee, removeRegion);
                RegularPut regularPut = new RegularPut(testee);
                PutFromLoadValidatorUnitTest.this.exec(transactional, invalidation, regularPut);
            }
        });
    }

    @Test
    public void testRegisteredPutWithInterveningKeyRemoval() throws Exception {
        this.registeredPutWithInterveningRemovalTest(false, false);
    }

    @Test
    public void testRegisteredPutWithInterveningKeyRemovalTransactional() throws Exception {
        this.registeredPutWithInterveningRemovalTest(true, false);
    }

    @Test
    public void testRegisteredPutWithInterveningRegionRemoval() throws Exception {
        this.registeredPutWithInterveningRemovalTest(false, true);
    }

    @Test
    public void testRegisteredPutWithInterveningRegionRemovalTransactional() throws Exception {
        this.registeredPutWithInterveningRemovalTest(true, true);
    }

    private void registeredPutWithInterveningRemovalTest(final boolean transactional, final boolean removeRegion) throws Exception {
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(PutFromLoadValidatorUnitTest.createCacheManager()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void call() {
                PutFromLoadValidator testee = new PutFromLoadValidator(this.cm.getCache().getAdvancedCache(), PutFromLoadValidatorUnitTest.regionFactory(this.cm));
                try {
                    long txTimestamp = System.currentTimeMillis();
                    if (transactional) {
                        PutFromLoadValidatorUnitTest.this.tm.begin();
                    }
                    SharedSessionContractImplementor session1 = (SharedSessionContractImplementor)Mockito.mock(SharedSessionContractImplementor.class);
                    SharedSessionContractImplementor session2 = (SharedSessionContractImplementor)Mockito.mock(SharedSessionContractImplementor.class);
                    testee.registerPendingPut(session1, PutFromLoadValidatorUnitTest.this.KEY1, txTimestamp);
                    if (removeRegion) {
                        testee.beginInvalidatingRegion();
                    } else {
                        testee.beginInvalidatingKey((Object)session2, PutFromLoadValidatorUnitTest.this.KEY1);
                    }
                    PutFromLoadValidator.Lock lock = testee.acquirePutFromLoadLock(session1, PutFromLoadValidatorUnitTest.this.KEY1, txTimestamp);
                    try {
                        Assert.assertNull((Object)lock);
                    }
                    finally {
                        if (lock != null) {
                            testee.releasePutFromLoadLock(PutFromLoadValidatorUnitTest.this.KEY1, lock);
                        }
                        if (removeRegion) {
                            testee.endInvalidatingRegion();
                        } else {
                            testee.endInvalidatingKey((Object)session2, PutFromLoadValidatorUnitTest.this.KEY1);
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Test
    public void testMultipleRegistrations() throws Exception {
        this.multipleRegistrationtest(false);
    }

    @Test
    public void testMultipleRegistrationsTransactional() throws Exception {
        this.multipleRegistrationtest(true);
    }

    private void multipleRegistrationtest(final boolean transactional) throws Exception {
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(PutFromLoadValidatorUnitTest.createCacheManager()){

            public void call() {
                final PutFromLoadValidator testee = new PutFromLoadValidator(this.cm.getCache().getAdvancedCache(), PutFromLoadValidatorUnitTest.regionFactory(this.cm));
                final CountDownLatch registeredLatch = new CountDownLatch(3);
                final CountDownLatch finishedLatch = new CountDownLatch(3);
                final AtomicInteger success = new AtomicInteger();
                Runnable r = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            long txTimestamp = System.currentTimeMillis();
                            if (transactional) {
                                PutFromLoadValidatorUnitTest.this.tm.begin();
                            }
                            SharedSessionContractImplementor session = (SharedSessionContractImplementor)Mockito.mock(SharedSessionContractImplementor.class);
                            testee.registerPendingPut(session, PutFromLoadValidatorUnitTest.this.KEY1, txTimestamp);
                            registeredLatch.countDown();
                            registeredLatch.await(5L, TimeUnit.SECONDS);
                            PutFromLoadValidator.Lock lock = testee.acquirePutFromLoadLock(session, PutFromLoadValidatorUnitTest.this.KEY1, txTimestamp);
                            if (lock != null) {
                                try {
                                    log.trace((Object)("Put from load lock acquired for key = " + PutFromLoadValidatorUnitTest.this.KEY1));
                                    success.incrementAndGet();
                                }
                                finally {
                                    testee.releasePutFromLoadLock(PutFromLoadValidatorUnitTest.this.KEY1, lock);
                                }
                            } else {
                                log.trace((Object)("Unable to acquired putFromLoad lock for key = " + PutFromLoadValidatorUnitTest.this.KEY1));
                            }
                            finishedLatch.countDown();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                };
                ExecutorService executor = Executors.newFixedThreadPool(3);
                testee.beginInvalidatingRegion();
                testee.endInvalidatingRegion();
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                executor.execute(r);
                executor.execute(r);
                executor.execute(r);
                try {
                    finishedLatch.await(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                Assert.assertEquals((String)"All threads succeeded", (long)3L, (long)success.get());
            }
        });
    }

    @Test
    public void testInvalidateKeyBlocksForInProgressPut() throws Exception {
        this.invalidationBlocksForInProgressPutTest(true);
    }

    @Test
    public void testInvalidateRegionBlocksForInProgressPut() throws Exception {
        this.invalidationBlocksForInProgressPutTest(false);
    }

    private void invalidationBlocksForInProgressPutTest(final boolean keyOnly) throws Exception {
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(PutFromLoadValidatorUnitTest.createCacheManager()){

            public void call() {
                final PutFromLoadValidator testee = new PutFromLoadValidator(this.cm.getCache().getAdvancedCache(), PutFromLoadValidatorUnitTest.regionFactory(this.cm));
                final CountDownLatch removeLatch = new CountDownLatch(1);
                final CountDownLatch pferLatch = new CountDownLatch(1);
                final AtomicReference<String> cache = new AtomicReference<String>("INITIAL");
                Callable<Boolean> pferCallable = new Callable<Boolean>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Boolean call() throws Exception {
                        long txTimestamp = System.currentTimeMillis();
                        SharedSessionContractImplementor session = (SharedSessionContractImplementor)Mockito.mock(SharedSessionContractImplementor.class);
                        testee.registerPendingPut(session, PutFromLoadValidatorUnitTest.this.KEY1, txTimestamp);
                        PutFromLoadValidator.Lock lock = testee.acquirePutFromLoadLock(session, PutFromLoadValidatorUnitTest.this.KEY1, txTimestamp);
                        if (lock != null) {
                            try {
                                removeLatch.countDown();
                                pferLatch.await();
                                cache.set("PFER");
                                Boolean bl = Boolean.TRUE;
                                return bl;
                            }
                            finally {
                                testee.releasePutFromLoadLock(PutFromLoadValidatorUnitTest.this.KEY1, lock);
                            }
                        }
                        return Boolean.FALSE;
                    }
                };
                Callable<Void> invalidateCallable = new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        removeLatch.await();
                        if (keyOnly) {
                            SharedSessionContractImplementor session = (SharedSessionContractImplementor)Mockito.mock(SharedSessionContractImplementor.class);
                            testee.beginInvalidatingKey((Object)session, PutFromLoadValidatorUnitTest.this.KEY1);
                        } else {
                            testee.beginInvalidatingRegion();
                        }
                        cache.set(null);
                        return null;
                    }
                };
                ExecutorService executorService = Executors.newCachedThreadPool();
                Future<Boolean> pferFuture = executorService.submit(pferCallable);
                Future<Void> invalidateFuture = executorService.submit(invalidateCallable);
                try {
                    try {
                        invalidateFuture.get(1L, TimeUnit.SECONDS);
                        Assert.fail((String)"invalidateFuture did not block");
                    }
                    catch (TimeoutException timeoutException) {
                        // empty catch block
                    }
                    pferLatch.countDown();
                    Assert.assertTrue((boolean)pferFuture.get(5L, TimeUnit.SECONDS));
                    invalidateFuture.get(5L, TimeUnit.SECONDS);
                    Assert.assertNull((Object)cache.get());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    protected void exec(boolean transactional, Callable<?> ... callables) {
        try {
            if (transactional) {
                for (Callable<?> c : callables) {
                    TestingUtil.withTx((TransactionManager)this.tm, c);
                }
            } else {
                for (Callable<?> c : callables) {
                    c.call();
                }
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    @TestForIssue(jiraKey="HHH-9928")
    public void testGetForNullReleasePuts() {
        EmbeddedCacheManager cm = PutFromLoadValidatorUnitTest.createCacheManager();
        InfinispanRegionFactory tmp = new InfinispanRegionFactory();
        tmp.setCacheManager(cm);
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.simpleCache(true).expiration().maxIdle(500L);
        Configuration ppCfg = cb.build();
        cm.defineConfiguration("pending-puts", cb.build());
        final InfinispanRegionFactory regionFactory = (InfinispanRegionFactory)Mockito.mock(InfinispanRegionFactory.class);
        ((InfinispanRegionFactory)Mockito.doReturn((Object)ppCfg).when((Object)regionFactory)).getPendingPutsCacheConfiguration();
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(cm){

            public void call() {
                int size;
                final PutFromLoadValidator testee = new PutFromLoadValidator(this.cm.getCache().getAdvancedCache(), regionFactory, this.cm);
                long lastInsert = Long.MAX_VALUE;
                for (int i = 0; i < 100; ++i) {
                    lastInsert = System.currentTimeMillis();
                    try {
                        TestingUtil.withTx((TransactionManager)PutFromLoadValidatorUnitTest.this.tm, (Callable)new Callable<Object>(){

                            @Override
                            public Object call() throws Exception {
                                SharedSessionContractImplementor session = (SharedSessionContractImplementor)Mockito.mock(SharedSessionContractImplementor.class);
                                testee.registerPendingPut(session, PutFromLoadValidatorUnitTest.this.KEY1, 0L);
                                return null;
                            }
                        });
                        Thread.sleep(10L);
                        continue;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                String ppName = this.cm.getCache().getName() + "-" + "pending-puts";
                Cache ppCache = this.cm.getCache(ppName, false);
                Assert.assertNotNull((Object)ppCache);
                Object pendingPutMap = ppCache.get(PutFromLoadValidatorUnitTest.this.KEY1);
                long end = System.currentTimeMillis();
                if (end - lastInsert > 500L) {
                    log.warn((Object)"Test took too long");
                    return;
                }
                Assert.assertNotNull(pendingPutMap);
                try {
                    Method sizeMethod = pendingPutMap.getClass().getMethod("size", new Class[0]);
                    sizeMethod.setAccessible(true);
                    size = (Integer)sizeMethod.invoke(pendingPutMap, new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                Assert.assertTrue((size < 100 ? 1 : 0) != 0);
                Assert.assertTrue((size > 0 ? 1 : 0) != 0);
            }
        });
    }

    private class NakedPut
    implements Callable<Void> {
        private final PutFromLoadValidator testee;
        private final boolean expectSuccess;

        public NakedPut(PutFromLoadValidator testee, boolean expectSuccess) {
            this.testee = testee;
            this.expectSuccess = expectSuccess;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            try {
                long txTimestamp = System.currentTimeMillis();
                SharedSessionContractImplementor session = (SharedSessionContractImplementor)Mockito.mock(SharedSessionContractImplementor.class);
                PutFromLoadValidator.Lock lock = this.testee.acquirePutFromLoadLock(session, PutFromLoadValidatorUnitTest.this.KEY1, txTimestamp);
                try {
                    if (this.expectSuccess) {
                        Assert.assertNotNull((Object)lock);
                    } else {
                        Assert.assertNull((Object)lock);
                    }
                }
                finally {
                    if (lock != null) {
                        this.testee.releasePutFromLoadLock(PutFromLoadValidatorUnitTest.this.KEY1, lock);
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return null;
        }
    }

    private class RegularPut
    implements Callable<Void> {
        private PutFromLoadValidator putFromLoadValidator;

        public RegularPut(PutFromLoadValidator putFromLoadValidator) {
            this.putFromLoadValidator = putFromLoadValidator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            try {
                long txTimestamp = System.currentTimeMillis();
                SharedSessionContractImplementor session = (SharedSessionContractImplementor)Mockito.mock(SharedSessionContractImplementor.class);
                this.putFromLoadValidator.registerPendingPut(session, PutFromLoadValidatorUnitTest.this.KEY1, txTimestamp);
                PutFromLoadValidator.Lock lock = this.putFromLoadValidator.acquirePutFromLoadLock(session, PutFromLoadValidatorUnitTest.this.KEY1, txTimestamp);
                try {
                    Assert.assertNotNull((Object)lock);
                }
                finally {
                    if (lock != null) {
                        this.putFromLoadValidator.releasePutFromLoadLock(PutFromLoadValidatorUnitTest.this.KEY1, lock);
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return null;
        }
    }

    private class Invalidation
    implements Callable<Void> {
        private PutFromLoadValidator putFromLoadValidator;
        private boolean removeRegion;

        public Invalidation(PutFromLoadValidator putFromLoadValidator, boolean removeRegion) {
            this.putFromLoadValidator = putFromLoadValidator;
            this.removeRegion = removeRegion;
        }

        @Override
        public Void call() throws Exception {
            if (this.removeRegion) {
                boolean success = this.putFromLoadValidator.beginInvalidatingRegion();
                Assert.assertTrue((boolean)success);
                this.putFromLoadValidator.endInvalidatingRegion();
            } else {
                SharedSessionContractImplementor session = (SharedSessionContractImplementor)Mockito.mock(SharedSessionContractImplementor.class);
                boolean success = this.putFromLoadValidator.beginInvalidatingKey((Object)session, PutFromLoadValidatorUnitTest.this.KEY1);
                Assert.assertTrue((boolean)success);
                success = this.putFromLoadValidator.endInvalidatingKey((Object)session, PutFromLoadValidatorUnitTest.this.KEY1);
                Assert.assertTrue((boolean)success);
            }
            Thread.sleep(10L);
            return null;
        }
    }
}

