/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan.collection;

import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import junit.framework.AssertionFailedError;
import org.hibernate.cache.infinispan.InfinispanRegionFactory;
import org.hibernate.cache.infinispan.access.AccessDelegate;
import org.hibernate.cache.infinispan.access.NonTxInvalidationCacheAccessDelegate;
import org.hibernate.cache.infinispan.access.PutFromLoadValidator;
import org.hibernate.cache.infinispan.access.TxInvalidationCacheAccessDelegate;
import org.hibernate.cache.infinispan.collection.CollectionRegionImpl;
import org.hibernate.cache.spi.access.CollectionRegionAccessStrategy;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.test.cache.infinispan.AbstractRegionAccessStrategyTest;
import org.hibernate.test.cache.infinispan.NodeEnvironment;
import org.hibernate.test.cache.infinispan.util.CacheTestUtil;
import org.hibernate.test.cache.infinispan.util.TestingKeyFactory;
import org.infinispan.AdvancedCache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.junit.Assert;
import org.junit.Test;

public class CollectionRegionAccessStrategyTest
extends AbstractRegionAccessStrategyTest<CollectionRegionImpl, CollectionRegionAccessStrategy> {
    protected static int testCount;

    @Override
    protected Object generateNextKey() {
        return TestingKeyFactory.generateCollectionCacheKey("KEY" + testCount++);
    }

    @Override
    protected CollectionRegionImpl getRegion(NodeEnvironment environment) {
        return environment.getCollectionRegion("test/com.foo.test", CACHE_DATA_DESCRIPTION);
    }

    @Override
    protected CollectionRegionAccessStrategy getAccessStrategy(CollectionRegionImpl region) {
        return region.buildAccessStrategy(this.accessType);
    }

    @Test
    public void testGetRegion() {
        Assert.assertEquals((String)"Correct region", (Object)this.localRegion, (Object)((CollectionRegionAccessStrategy)this.localAccessStrategy).getRegion());
    }

    @Test
    public void testPutFromLoadRemoveDoesNotProduceStaleData() throws Exception {
        if (this.cacheMode.isInvalidation()) {
            this.doPutFromLoadRemoveDoesNotProduceStaleDataInvalidation();
        }
    }

    public void doPutFromLoadRemoveDoesNotProduceStaleDataInvalidation() {
        final CountDownLatch pferLatch = new CountDownLatch(1);
        final CountDownLatch removeLatch = new CountDownLatch(1);
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(CollectionRegionAccessStrategyTest.createCacheManager(((CollectionRegionImpl)this.localRegion).getRegionFactory())){

            public void call() {
                PutFromLoadValidator validator = CollectionRegionAccessStrategyTest.this.getPutFromLoadValidator(((CollectionRegionImpl)CollectionRegionAccessStrategyTest.this.remoteRegion).getCache(), this.cm, removeLatch, pferLatch);
                TxInvalidationCacheAccessDelegate delegate = ((CollectionRegionImpl)CollectionRegionAccessStrategyTest.this.localRegion).getCache().getCacheConfiguration().transaction().transactionMode().isTransactional() ? new TxInvalidationCacheAccessDelegate(CollectionRegionAccessStrategyTest.this.localRegion, validator) : new NonTxInvalidationCacheAccessDelegate(CollectionRegionAccessStrategyTest.this.localRegion, validator);
                Callable<Void> pferCallable = new Callable<Void>((AccessDelegate)delegate){
                    final /* synthetic */ AccessDelegate val$delegate;
                    {
                        this.val$delegate = accessDelegate;
                    }

                    @Override
                    public Void call() throws Exception {
                        SharedSessionContractImplementor session = CollectionRegionAccessStrategyTest.this.mockedSession();
                        this.val$delegate.putFromLoad(session, (Object)"k1", (Object)"v1", session.getTimestamp(), null);
                        return null;
                    }
                };
                Callable<Void> removeCallable = new Callable<Void>((AccessDelegate)delegate){
                    final /* synthetic */ AccessDelegate val$delegate;
                    {
                        this.val$delegate = accessDelegate;
                    }

                    @Override
                    public Void call() throws Exception {
                        removeLatch.await();
                        final SharedSessionContractImplementor session = CollectionRegionAccessStrategyTest.this.mockedSession();
                        CollectionRegionAccessStrategyTest.this.withTx(CollectionRegionAccessStrategyTest.this.localEnvironment, session, new Callable<Void>(){

                            @Override
                            public Void call() throws Exception {
                                val$delegate.remove(session, (Object)"k1");
                                return null;
                            }
                        });
                        pferLatch.countDown();
                        return null;
                    }
                };
                ExecutorService executorService = Executors.newCachedThreadPool();
                Future<Void> pferFuture = executorService.submit(pferCallable);
                Future<Void> removeFuture = executorService.submit(removeCallable);
                try {
                    pferFuture.get();
                    removeFuture.get();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                Assert.assertFalse((boolean)((CollectionRegionImpl)CollectionRegionAccessStrategyTest.this.localRegion).getCache().containsKey((Object)"k1"));
            }
        });
    }

    private static EmbeddedCacheManager createCacheManager(InfinispanRegionFactory regionFactory) {
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createCacheManager((boolean)false);
        return cacheManager;
    }

    protected PutFromLoadValidator getPutFromLoadValidator(AdvancedCache cache, EmbeddedCacheManager cm, final CountDownLatch removeLatch, final CountDownLatch pferLatch) {
        PutFromLoadValidator.removeFromCache((AdvancedCache)cache);
        InfinispanRegionFactory regionFactory = new InfinispanRegionFactory();
        regionFactory.setCacheManager(cm);
        regionFactory.start(CacheTestUtil.sfOptionsForStart(), new Properties());
        return new PutFromLoadValidator(cache, regionFactory, cm){

            public PutFromLoadValidator.Lock acquirePutFromLoadLock(SharedSessionContractImplementor session, Object key, long txTimestamp) {
                PutFromLoadValidator.Lock lock = super.acquirePutFromLoadLock(session, key, txTimestamp);
                try {
                    removeLatch.countDown();
                    Assert.assertFalse((boolean)pferLatch.await(2L, TimeUnit.SECONDS));
                }
                catch (InterruptedException e) {
                    CollectionRegionAccessStrategyTest.this.log.debug((Object)"Interrupted");
                    Thread.currentThread().interrupt();
                }
                catch (Exception e) {
                    CollectionRegionAccessStrategyTest.this.log.error((Object)"Error", (Throwable)e);
                    throw new RuntimeException("Error", e);
                }
                return lock;
            }
        };
    }

    @Test
    public void testPutFromLoad() throws Exception {
        this.putFromLoadTest(false);
    }

    @Test
    public void testPutFromLoadMinimal() throws Exception {
        this.putFromLoadTest(true);
    }

    protected void putFromLoadTest(final boolean useMinimalAPI) throws Exception {
        final Object KEY = this.generateNextKey();
        final CountDownLatch writeLatch1 = new CountDownLatch(1);
        final CountDownLatch writeLatch2 = new CountDownLatch(1);
        final CountDownLatch completionLatch = new CountDownLatch(2);
        Thread node1 = new Thread(){

            @Override
            public void run() {
                try {
                    SharedSessionContractImplementor session = CollectionRegionAccessStrategyTest.this.mockedSession();
                    CollectionRegionAccessStrategyTest.this.withTx(CollectionRegionAccessStrategyTest.this.localEnvironment, session, () -> {
                        Assert.assertNull((Object)((CollectionRegionAccessStrategy)CollectionRegionAccessStrategyTest.this.localAccessStrategy).get(session, KEY, session.getTimestamp()));
                        writeLatch1.await();
                        if (useMinimalAPI) {
                            ((CollectionRegionAccessStrategy)CollectionRegionAccessStrategyTest.this.localAccessStrategy).putFromLoad(session, KEY, (Object)"VALUE2", session.getTimestamp(), (Object)2, true);
                        } else {
                            ((CollectionRegionAccessStrategy)CollectionRegionAccessStrategyTest.this.localAccessStrategy).putFromLoad(session, KEY, (Object)"VALUE2", session.getTimestamp(), (Object)2);
                        }
                        return null;
                    });
                }
                catch (Exception e) {
                    CollectionRegionAccessStrategyTest.this.log.error((Object)"node1 caught exception", (Throwable)e);
                    CollectionRegionAccessStrategyTest.this.node1Exception = e;
                }
                catch (AssertionFailedError e) {
                    CollectionRegionAccessStrategyTest.this.node1Failure = e;
                }
                finally {
                    writeLatch2.countDown();
                    completionLatch.countDown();
                }
            }
        };
        AbstractRegionAccessStrategyTest.PutFromLoadNode2 node2 = new AbstractRegionAccessStrategyTest.PutFromLoadNode2(KEY, writeLatch1, writeLatch2, useMinimalAPI, completionLatch);
        node1.setDaemon(true);
        node2.setDaemon(true);
        node1.start();
        node2.start();
        Assert.assertTrue((String)"Threads completed", (boolean)completionLatch.await(2L, TimeUnit.SECONDS));
        this.assertThreadsRanCleanly();
        long txTimestamp = System.currentTimeMillis();
        SharedSessionContractImplementor s1 = this.mockedSession();
        Assert.assertEquals((Object)"VALUE2", (Object)((CollectionRegionAccessStrategy)this.localAccessStrategy).get(s1, KEY, s1.getTimestamp()));
        SharedSessionContractImplementor s2 = this.mockedSession();
        Object remoteValue = ((CollectionRegionAccessStrategy)this.remoteAccessStrategy).get(s2, KEY, s2.getTimestamp());
        if (this.isUsingInvalidation()) {
            Assert.assertEquals((Object)"VALUE1", (Object)remoteValue);
        } else {
            Assert.assertEquals((Object)"VALUE2", (Object)remoteValue);
        }
    }
}

