/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan.entity;

import java.util.Properties;
import org.hibernate.cache.infinispan.InfinispanRegionFactory;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.EntityRegion;
import org.hibernate.cache.spi.Region;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.test.cache.infinispan.AbstractEntityCollectionRegionTest;
import org.infinispan.AdvancedCache;
import org.junit.Assert;

public class EntityRegionImplTest
extends AbstractEntityCollectionRegionTest {
    protected static final String CACHE_NAME = "test";

    @Override
    protected void supportedAccessTypeTest(RegionFactory regionFactory, Properties properties) {
        EntityRegion region = regionFactory.buildEntityRegion(CACHE_NAME, properties, MUTABLE_NON_VERSIONED);
        Assert.assertNotNull((Object)region.buildAccessStrategy(this.accessType));
        ((InfinispanRegionFactory)regionFactory).getCacheManager().removeCache(CACHE_NAME);
    }

    @Override
    protected void putInRegion(Region region, Object key, Object value) {
        ((EntityRegion)region).buildAccessStrategy(AccessType.TRANSACTIONAL).insert(null, key, value, (Object)1);
    }

    @Override
    protected void removeFromRegion(Region region, Object key) {
        ((EntityRegion)region).buildAccessStrategy(AccessType.TRANSACTIONAL).remove(null, key);
    }

    @Override
    protected Region createRegion(InfinispanRegionFactory regionFactory, String regionName, Properties properties, CacheDataDescription cdd) {
        return regionFactory.buildEntityRegion(regionName, properties, cdd);
    }

    @Override
    protected AdvancedCache getInfinispanCache(InfinispanRegionFactory regionFactory) {
        return regionFactory.getCacheManager().getCache("entity").getAdvancedCache();
    }
}

