/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan.functional;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Value;
import org.hibernate.resource.transaction.backend.jdbc.internal.JdbcResourceLocalTransactionCoordinatorBuilderImpl;
import org.hibernate.resource.transaction.backend.jta.internal.JtaTransactionCoordinatorBuilderImpl;
import org.hibernate.resource.transaction.spi.TransactionCoordinatorBuilder;
import org.hibernate.test.cache.infinispan.tm.JtaPlatformImpl;
import org.hibernate.test.cache.infinispan.tm.XaConnectionProvider;
import org.hibernate.test.cache.infinispan.util.InfinispanTestingSetup;
import org.hibernate.test.cache.infinispan.util.TestInfinispanRegionFactory;
import org.hibernate.test.cache.infinispan.util.TxUtil;
import org.hibernate.testing.BeforeClassOnce;
import org.hibernate.testing.junit4.BaseNonConfigCoreFunctionalTestCase;
import org.hibernate.testing.junit4.CustomParameterized;
import org.infinispan.configuration.cache.CacheMode;
import org.junit.ClassRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=CustomParameterized.class)
public abstract class AbstractFunctionalTest
extends BaseNonConfigCoreFunctionalTestCase {
    protected static final Object[] TRANSACTIONAL = new Object[]{"transactional", JtaPlatformImpl.class, JtaTransactionCoordinatorBuilderImpl.class, XaConnectionProvider.class, AccessType.TRANSACTIONAL, true, CacheMode.INVALIDATION_SYNC, false};
    protected static final Object[] READ_WRITE_INVALIDATION = new Object[]{"read-write", null, JdbcResourceLocalTransactionCoordinatorBuilderImpl.class, null, AccessType.READ_WRITE, false, CacheMode.INVALIDATION_SYNC, false};
    protected static final Object[] READ_ONLY_INVALIDATION = new Object[]{"read-only", null, JdbcResourceLocalTransactionCoordinatorBuilderImpl.class, null, AccessType.READ_ONLY, false, CacheMode.INVALIDATION_SYNC, false};
    protected static final Object[] READ_WRITE_REPLICATED = new Object[]{"read-write", null, JdbcResourceLocalTransactionCoordinatorBuilderImpl.class, null, AccessType.READ_WRITE, false, CacheMode.REPL_SYNC, false};
    protected static final Object[] READ_ONLY_REPLICATED = new Object[]{"read-only", null, JdbcResourceLocalTransactionCoordinatorBuilderImpl.class, null, AccessType.READ_ONLY, false, CacheMode.REPL_SYNC, false};
    protected static final Object[] READ_WRITE_DISTRIBUTED = new Object[]{"read-write", null, JdbcResourceLocalTransactionCoordinatorBuilderImpl.class, null, AccessType.READ_WRITE, false, CacheMode.DIST_SYNC, false};
    protected static final Object[] READ_ONLY_DISTRIBUTED = new Object[]{"read-only", null, JdbcResourceLocalTransactionCoordinatorBuilderImpl.class, null, AccessType.READ_ONLY, false, CacheMode.DIST_SYNC, false};
    protected static final Object[] NONSTRICT_REPLICATED = new Object[]{"nonstrict", null, JdbcResourceLocalTransactionCoordinatorBuilderImpl.class, null, AccessType.NONSTRICT_READ_WRITE, false, CacheMode.REPL_SYNC, true};
    protected static final Object[] NONSTRICT_DISTRIBUTED = new Object[]{"nonstrict", null, JdbcResourceLocalTransactionCoordinatorBuilderImpl.class, null, AccessType.NONSTRICT_READ_WRITE, false, CacheMode.DIST_SYNC, true};
    @ClassRule
    public static final InfinispanTestingSetup infinispanTestIdentifier = new InfinispanTestingSetup();
    @Parameterized.Parameter(value=0)
    public String mode;
    @Parameterized.Parameter(value=1)
    public Class<? extends JtaPlatform> jtaPlatformClass;
    @Parameterized.Parameter(value=2)
    public Class<? extends TransactionCoordinatorBuilder> transactionCoordinatorBuilderClass;
    @Parameterized.Parameter(value=3)
    public Class<? extends ConnectionProvider> connectionProviderClass;
    @Parameterized.Parameter(value=4)
    public AccessType accessType;
    @Parameterized.Parameter(value=5)
    public boolean useTransactionalCache;
    @Parameterized.Parameter(value=6)
    public CacheMode cacheMode;
    @Parameterized.Parameter(value=7)
    public boolean addVersions;
    protected boolean useJta;

    @CustomParameterized.Order(value=0)
    @Parameterized.Parameters(name="{0}, {6}")
    public abstract List<Object[]> getParameters();

    public List<Object[]> getParameters(boolean tx, boolean rw, boolean ro, boolean nonstrict) {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        if (tx) {
            parameters.add(TRANSACTIONAL);
        }
        if (rw) {
            parameters.add(READ_WRITE_INVALIDATION);
            parameters.add(READ_WRITE_REPLICATED);
            parameters.add(READ_WRITE_DISTRIBUTED);
        }
        if (ro) {
            parameters.add(READ_ONLY_INVALIDATION);
            parameters.add(READ_ONLY_REPLICATED);
            parameters.add(READ_ONLY_DISTRIBUTED);
        }
        if (nonstrict) {
            parameters.add(NONSTRICT_REPLICATED);
            parameters.add(NONSTRICT_DISTRIBUTED);
        }
        return parameters;
    }

    @BeforeClassOnce
    public void setUseJta() {
        this.useJta = this.jtaPlatformClass != null;
    }

    public String[] getMappings() {
        return new String[]{"cache/infinispan/functional/entities/Item.hbm.xml", "cache/infinispan/functional/entities/Customer.hbm.xml", "cache/infinispan/functional/entities/Contact.hbm.xml"};
    }

    protected void afterMetadataBuilt(Metadata metadata) {
        if (this.addVersions) {
            for (PersistentClass clazz : metadata.getEntityBindings()) {
                if (clazz.getVersion() != null) continue;
                try {
                    clazz.getMappedClass().getMethod("getVersion", new Class[0]);
                    clazz.getMappedClass().getMethod("setVersion", Long.TYPE);
                }
                catch (NoSuchMethodException e) {
                    continue;
                }
                RootClass rootClazz = clazz.getRootClass();
                Property versionProperty = new Property();
                versionProperty.setName("version");
                SimpleValue value = new SimpleValue((MetadataImplementor)metadata, rootClazz.getTable());
                value.setTypeName("long");
                Column column = new Column();
                column.setValue((Value)value);
                column.setName("version");
                value.addColumn(column);
                rootClazz.getTable().addColumn(column);
                versionProperty.setValue((Value)value);
                rootClazz.setVersion(versionProperty);
                rootClazz.addProperty(versionProperty);
            }
        }
    }

    public String getCacheConcurrencyStrategy() {
        return this.accessType.getExternalName();
    }

    protected Class<? extends RegionFactory> getRegionFactoryClass() {
        return TestInfinispanRegionFactory.class;
    }

    protected boolean getUseQueryCache() {
        return true;
    }

    protected void addSettings(Map settings) {
        super.addSettings(settings);
        settings.put("hibernate.cache.use_second_level_cache", "true");
        settings.put("hibernate.generate_statistics", "true");
        settings.put("hibernate.cache.use_query_cache", String.valueOf(this.getUseQueryCache()));
        settings.put("hibernate.cache.region.factory_class", this.getRegionFactoryClass().getName());
        settings.put(TestInfinispanRegionFactory.TRANSACTIONAL, this.useTransactionalCache);
        settings.put(TestInfinispanRegionFactory.CACHE_MODE, this.cacheMode);
        if (this.jtaPlatformClass != null) {
            settings.put("hibernate.transaction.jta.platform", this.jtaPlatformClass.getName());
        }
        settings.put("hibernate.transaction.coordinator_class", this.transactionCoordinatorBuilderClass.getName());
        if (this.connectionProviderClass != null) {
            settings.put("hibernate.connection.provider_class", this.connectionProviderClass.getName());
        }
    }

    protected void markRollbackOnly(Session session) {
        TxUtil.markRollbackOnly(this.useJta, session);
    }
}

