/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan.functional;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.hibernate.PessimisticLockException;
import org.hibernate.Session;
import org.hibernate.StaleStateException;
import org.hibernate.cache.infinispan.InfinispanRegionFactory;
import org.hibernate.cache.infinispan.entity.EntityRegionImpl;
import org.hibernate.cache.infinispan.util.InfinispanMessageLogger;
import org.hibernate.cache.spi.Region;
import org.hibernate.test.cache.infinispan.functional.SingleNodeTest;
import org.hibernate.test.cache.infinispan.functional.entities.Item;
import org.hibernate.test.cache.infinispan.util.TestInfinispanRegionFactory;
import org.hibernate.test.cache.infinispan.util.TestTimeService;
import org.hibernate.testing.AfterClassOnce;
import org.hibernate.testing.BeforeClassOnce;
import org.infinispan.AdvancedCache;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class AbstractNonInvalidationTest
extends SingleNodeTest {
    protected static final int WAIT_TIMEOUT = 2000;
    protected static final TestTimeService TIME_SERVICE = new TestTimeService();
    protected long TIMEOUT;
    protected ExecutorService executor;
    protected InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(((Object)((Object)this)).getClass());
    protected AdvancedCache entityCache;
    protected long itemId;
    protected Region region;
    protected long timeout;

    @BeforeClassOnce
    public void setup() {
        this.executor = Executors.newCachedThreadPool(new ThreadFactory(){
            AtomicInteger counter = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "Executor-" + this.counter.incrementAndGet());
            }
        });
    }

    @AfterClassOnce
    public void shutdown() {
        this.executor.shutdown();
    }

    protected void startUp() {
        super.startUp();
        InfinispanRegionFactory regionFactory = (InfinispanRegionFactory)this.sessionFactory().getSettings().getRegionFactory();
        this.TIMEOUT = regionFactory.getPendingPutsCacheConfiguration().expiration().maxIdle();
        this.region = this.sessionFactory().getSecondLevelCacheRegion(Item.class.getName());
        this.entityCache = ((EntityRegionImpl)this.region).getCache();
    }

    @Before
    public void insertAndClearCache() throws Exception {
        this.region = this.sessionFactory().getSecondLevelCacheRegion(Item.class.getName());
        this.entityCache = ((EntityRegionImpl)this.region).getCache();
        this.timeout = ((EntityRegionImpl)this.region).getRegionFactory().getPendingPutsCacheConfiguration().expiration().maxIdle();
        Item item = new Item("my item", "Original item");
        this.withTxSession(s -> s.persist((Object)item));
        this.entityCache.clear();
        Assert.assertEquals((String)"Cache is not empty", (Object)Collections.EMPTY_SET, (Object)this.entityCache.keySet());
        this.itemId = item.getId();
        this.log.info((Object)"Insert and clear finished");
    }

    @After
    public void cleanup() throws Exception {
        this.withTxSession(s -> s.createQuery("delete from Item").executeUpdate());
    }

    protected Future<Boolean> removeFlushWait(long id, CyclicBarrier loadBarrier, CountDownLatch preFlushLatch, CountDownLatch flushLatch, CountDownLatch commitLatch) throws Exception {
        return this.executor.submit(() -> this.withTxSessionApply(s -> {
            try {
                Item item = (Item)s.load(Item.class, (Serializable)Long.valueOf(id));
                item.getName();
                loadBarrier.await(2000L, TimeUnit.SECONDS);
                s.delete((Object)item);
                if (preFlushLatch != null) {
                    this.awaitOrThrow(preFlushLatch);
                }
                s.flush();
            }
            catch (StaleStateException e) {
                this.log.info((Object)"Exception thrown: ", (Throwable)e);
                this.markRollbackOnly((Session)s);
                Boolean bl = false;
                return bl;
            }
            catch (PessimisticLockException e) {
                this.log.info((Object)"Exception thrown: ", (Throwable)e);
                this.markRollbackOnly((Session)s);
                Boolean bl = false;
                return bl;
            }
            finally {
                if (flushLatch != null) {
                    flushLatch.countDown();
                }
            }
            this.awaitOrThrow(commitLatch);
            return true;
        }));
    }

    protected Future<Boolean> updateFlushWait(long id, CyclicBarrier loadBarrier, CountDownLatch preFlushLatch, CountDownLatch flushLatch, CountDownLatch commitLatch) throws Exception {
        return this.executor.submit(() -> this.withTxSessionApply(s -> {
            try {
                Item item = (Item)s.load(Item.class, (Serializable)Long.valueOf(id));
                item.getName();
                loadBarrier.await(2000L, TimeUnit.SECONDS);
                item.setDescription("Updated item");
                s.update((Object)item);
                if (preFlushLatch != null) {
                    this.awaitOrThrow(preFlushLatch);
                }
                s.flush();
            }
            catch (StaleStateException e) {
                this.log.info((Object)"Exception thrown: ", (Throwable)e);
                this.markRollbackOnly((Session)s);
                Boolean bl = false;
                return bl;
            }
            catch (PessimisticLockException e) {
                this.log.info((Object)"Exception thrown: ", (Throwable)e);
                this.markRollbackOnly((Session)s);
                Boolean bl = false;
                return bl;
            }
            finally {
                if (flushLatch != null) {
                    flushLatch.countDown();
                }
            }
            this.awaitOrThrow(commitLatch);
            return true;
        }));
    }

    protected Future<Boolean> evictWait(long id, CyclicBarrier loadBarrier, CountDownLatch preEvictLatch, CountDownLatch postEvictLatch) throws Exception {
        return this.executor.submit(() -> {
            try {
                loadBarrier.await(2000L, TimeUnit.SECONDS);
                if (preEvictLatch != null) {
                    this.awaitOrThrow(preEvictLatch);
                }
                this.sessionFactory().getCache().evictEntity(Item.class, (Serializable)Long.valueOf(id));
            }
            finally {
                if (postEvictLatch != null) {
                    postEvictLatch.countDown();
                }
            }
            return true;
        });
    }

    protected void awaitOrThrow(CountDownLatch latch) throws InterruptedException, TimeoutException {
        if (!latch.await(2000L, TimeUnit.SECONDS)) {
            throw new TimeoutException();
        }
    }

    @Override
    protected void addSettings(Map settings) {
        super.addSettings(settings);
        settings.put(TestInfinispanRegionFactory.TIME_SERVICE, TIME_SERVICE);
    }
}

