/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan.functional;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hibernate.PessimisticLockException;
import org.hibernate.cache.infinispan.entity.EntityRegionImpl;
import org.hibernate.cache.infinispan.util.InfinispanMessageLogger;
import org.hibernate.cache.spi.Region;
import org.hibernate.test.cache.infinispan.functional.ReadOnlyTest;
import org.hibernate.test.cache.infinispan.functional.SingleNodeTest;
import org.hibernate.test.cache.infinispan.functional.entities.Item;
import org.hibernate.test.cache.infinispan.util.TestInfinispanRegionFactory;
import org.hibernate.testing.TestForIssue;
import org.infinispan.AdvancedCache;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.base.BaseCustomInterceptor;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.junit.Assert;
import org.junit.Test;

public class InvalidationTest
extends SingleNodeTest {
    static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(ReadOnlyTest.class);

    @Override
    public List<Object[]> getParameters() {
        return Arrays.asList(TRANSACTIONAL, READ_WRITE_INVALIDATION);
    }

    @Override
    protected void addSettings(Map settings) {
        super.addSettings(settings);
        settings.put(TestInfinispanRegionFactory.PENDING_PUTS_SIMPLE, false);
    }

    @Test
    @TestForIssue(jiraKey="HHH-9868")
    public void testConcurrentRemoveAndPutFromLoad() throws Exception {
        Region region = this.sessionFactory().getSecondLevelCacheRegion(Item.class.getName());
        AdvancedCache entityCache = ((EntityRegionImpl)region).getCache();
        Item item = new Item("chris", "Chris's Item");
        this.withTxSession(s -> s.persist((Object)item));
        Phaser deletePhaser = new Phaser(2);
        Phaser getPhaser = new Phaser(2);
        HookInterceptor hook = new HookInterceptor();
        AdvancedCache pendingPutsCache = entityCache.getCacheManager().getCache(entityCache.getName() + "-" + "pending-puts").getAdvancedCache();
        pendingPutsCache.addInterceptor((CommandInterceptor)hook, 0);
        AtomicBoolean getThreadBlockedInDB = new AtomicBoolean(false);
        Thread deleteThread = new Thread(() -> {
            try {
                this.withTxSession(s -> {
                    Item loadedItem = (Item)s.get(Item.class, (Serializable)item.getId());
                    Assert.assertNotNull((Object)loadedItem);
                    InvalidationTest.arriveAndAwait(deletePhaser, 2000);
                    InvalidationTest.arriveAndAwait(deletePhaser, 2000);
                    log.trace((Object)"Item loaded");
                    s.delete((Object)loadedItem);
                    s.flush();
                    log.trace((Object)"Item deleted");
                    InvalidationTest.arriveAndAwait(deletePhaser, 2000);
                    InvalidationTest.arriveAndAwait(deletePhaser, 4000);
                });
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, "delete-thread");
        Thread getThread = new Thread(() -> {
            try {
                this.withTxSession(s -> {
                    Item loadedItem = (Item)s.get(Item.class, (Serializable)item.getId());
                    if (getThreadBlockedInDB.get()) {
                        Assert.assertNull((Object)loadedItem);
                    } else {
                        Assert.assertNotNull((Object)loadedItem);
                    }
                });
            }
            catch (PessimisticLockException e) {
                try {
                    InvalidationTest.arriveAndAwait(getPhaser, 2000);
                    InvalidationTest.arriveAndAwait(getPhaser, 2000);
                }
                catch (Exception e1) {
                    throw new RuntimeException(e1);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, "get-thread");
        deleteThread.start();
        InvalidationTest.arriveAndAwait(deletePhaser, 2000);
        this.withTx(() -> {
            this.sessionFactory().getCache().evictEntity(Item.class, (Serializable)item.getId());
            Assert.assertFalse((boolean)this.sessionFactory().getCache().containsEntity(Item.class, (Serializable)item.getId()));
            return null;
        });
        InvalidationTest.arriveAndAwait(deletePhaser, 2000);
        InvalidationTest.arriveAndAwait(deletePhaser, 2000);
        hook.block(getPhaser, getThread);
        getThread.start();
        try {
            InvalidationTest.arriveAndAwait(getPhaser, 2000);
        }
        catch (TimeoutException e) {
            getThreadBlockedInDB.set(true);
        }
        InvalidationTest.arriveAndAwait(deletePhaser, 2000);
        deleteThread.join();
        hook.unblock();
        InvalidationTest.arriveAndAwait(getPhaser, 2000);
        getThread.join();
        this.withTxSession(s -> {
            Item loadedItem = (Item)s.get(Item.class, (Serializable)item.getId());
            Assert.assertNull((Object)loadedItem);
        });
    }

    protected static void arriveAndAwait(Phaser phaser, int timeout) throws TimeoutException, InterruptedException {
        phaser.awaitAdvanceInterruptibly(phaser.arrive(), timeout, TimeUnit.MILLISECONDS);
    }

    private static class HookInterceptor
    extends BaseCustomInterceptor {
        Phaser phaser;
        Thread thread;

        private HookInterceptor() {
        }

        public synchronized void block(Phaser phaser, Thread thread) {
            this.phaser = phaser;
            this.thread = thread;
        }

        public synchronized void unblock() {
            this.phaser = null;
            this.thread = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
            Thread thread;
            Phaser phaser;
            HookInterceptor hookInterceptor = this;
            synchronized (hookInterceptor) {
                phaser = this.phaser;
                thread = this.thread;
            }
            if (phaser != null && Thread.currentThread() == thread) {
                InvalidationTest.arriveAndAwait(phaser, 2000);
                InvalidationTest.arriveAndAwait(phaser, 2000);
            }
            return super.visitGetKeyValueCommand(ctx, command);
        }
    }
}

