/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan.functional;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.cache.infinispan.JndiInfinispanRegionFactory;
import org.hibernate.cache.infinispan.util.InfinispanMessageLogger;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.hibernate.test.cache.infinispan.functional.SingleNodeTest;
import org.hibernate.test.cache.infinispan.functional.entities.Item;
import org.infinispan.Cache;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.util.naming.NonSerializableFactory;
import org.jnp.server.Main;
import org.jnp.server.SingletonNamingServer;
import org.junit.Assert;
import org.junit.Test;

public class JndiRegionFactoryTest
extends SingleNodeTest {
    private static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(JndiRegionFactoryTest.class);
    private static final String JNDI_NAME = "java:CacheManager";
    private Main namingMain;
    private SingletonNamingServer namingServer;
    private Properties props;
    private boolean bindToJndi = true;
    private EmbeddedCacheManager manager;

    @Override
    public List<Object[]> getParameters() {
        return Collections.singletonList(READ_WRITE_INVALIDATION);
    }

    @Override
    protected Class<? extends RegionFactory> getRegionFactoryClass() {
        return JndiInfinispanRegionFactory.class;
    }

    protected void cleanupTest() throws Exception {
        InitialContext ctx = new InitialContext(this.props);
        this.unbind(JNDI_NAME, ctx);
        this.namingServer.destroy();
        this.namingMain.stop();
        this.manager.stop();
    }

    protected void afterStandardServiceRegistryBuilt(StandardServiceRegistry ssr) {
        if (this.bindToJndi) {
            try {
                this.namingServer = new SingletonNamingServer();
                this.namingMain = new Main();
                this.namingMain.setInstallGlobalService(true);
                this.namingMain.setPort(-1);
                this.namingMain.start();
                this.props = new Properties();
                this.props.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
                this.props.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
                String cfgFileName = (String)((ConfigurationService)ssr.getService(ConfigurationService.class)).getSettings().get("hibernate.cache.infinispan.cfg");
                this.manager = new DefaultCacheManager(cfgFileName == null ? "org/hibernate/cache/infinispan/builder/infinispan-configs.xml" : cfgFileName, false);
                InitialContext ctx = new InitialContext(this.props);
                this.bind(JNDI_NAME, this.manager, EmbeddedCacheManager.class, ctx);
            }
            catch (Exception e) {
                throw new RuntimeException("Failure to set up JNDI", e);
            }
        }
    }

    @Override
    protected void addSettings(Map settings) {
        super.addSettings(settings);
        settings.put("hibernate.cache.infinispan.cachemanager", JNDI_NAME);
        settings.put("hibernate.jndi.class", "org.jnp.interfaces.NamingContextFactory");
        settings.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
    }

    @Test
    public void testRedeployment() throws Exception {
        this.addEntityCheckCache(this.sessionFactory());
        this.bindToJndi = false;
        this.rebuildSessionFactory();
        this.addEntityCheckCache(this.sessionFactory());
        JndiInfinispanRegionFactory regionFactory = (JndiInfinispanRegionFactory)this.sessionFactory().getSettings().getRegionFactory();
        Cache cache = regionFactory.getCacheManager().getCache(Item.class.getName());
        Assert.assertEquals((Object)ComponentStatus.RUNNING, (Object)cache.getStatus());
    }

    private void addEntityCheckCache(SessionFactoryImplementor sessionFactory) throws Exception {
        Item item = new Item("chris", "Chris's Item");
        this.withTxSession(s -> s.persist((Object)item));
        this.withTxSession(s -> {
            Item found = (Item)s.load(Item.class, (Serializable)item.getId());
            StatisticsImplementor stats = sessionFactory.getStatistics();
            log.info((Object)stats.toString());
            Assert.assertEquals((Object)item.getDescription(), (Object)found.getDescription());
            Assert.assertEquals((long)0L, (long)stats.getSecondLevelCacheMissCount());
            Assert.assertEquals((long)1L, (long)stats.getSecondLevelCacheHitCount());
            s.delete((Object)found);
        });
    }

    private void bind(String jndiName, Object who, Class<?> classType, Context ctx) throws Exception {
        NonSerializableFactory.bind((String)jndiName, (Object)who);
        Name n = ctx.getNameParser("").parse(jndiName);
        while (n.size() > 1) {
            String ctxName = n.get(0);
            try {
                ctx = (Context)ctx.lookup(ctxName);
            }
            catch (NameNotFoundException e) {
                log.debug((Object)("creating Subcontext " + ctxName));
                ctx = ctx.createSubcontext(ctxName);
            }
            n = n.getSuffix(1);
        }
        StringRefAddr addr = new StringRefAddr("nns", jndiName);
        Reference ref = new Reference(classType.getName(), addr, NonSerializableFactory.class.getName(), null);
        ctx.rebind(n.get(0), (Object)ref);
    }

    private void unbind(String jndiName, Context ctx) throws Exception {
        NonSerializableFactory.unbind((String)jndiName);
    }
}

