/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan.functional;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.hibernate.MultiTenancyStrategy;
import org.hibernate.boot.SessionFactoryBuilder;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cache.infinispan.entity.EntityRegionImpl;
import org.hibernate.engine.jdbc.connections.spi.AbstractMultiTenantConnectionProvider;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.jdbc.connections.spi.MultiTenantConnectionProvider;
import org.hibernate.service.Service;
import org.hibernate.test.cache.infinispan.functional.SingleNodeTest;
import org.hibernate.test.cache.infinispan.functional.entities.Item;
import org.hibernate.test.cache.infinispan.tm.XaConnectionProvider;
import org.hibernate.testing.env.ConnectionProviderBuilder;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.context.Flag;
import org.junit.Assert;
import org.junit.Test;

public class MultiTenancyTest
extends SingleNodeTest {
    private static final String DB1 = "db1";
    private static final String DB2 = "db2";
    private final ConnectionProvider db1 = new XaConnectionProvider((ConnectionProvider)ConnectionProviderBuilder.buildConnectionProvider((String)"db1"));
    private final ConnectionProvider db2 = new XaConnectionProvider((ConnectionProvider)ConnectionProviderBuilder.buildConnectionProvider((String)"db2"));

    @Override
    public List<Object[]> getParameters() {
        return Collections.singletonList(READ_ONLY_INVALIDATION);
    }

    protected void configureStandardServiceRegistryBuilder(StandardServiceRegistryBuilder ssrb) {
        super.configureStandardServiceRegistryBuilder(ssrb);
        ssrb.addService(MultiTenantConnectionProvider.class, (Service)new AbstractMultiTenantConnectionProvider(){

            protected ConnectionProvider getAnyConnectionProvider() {
                return MultiTenancyTest.this.db1;
            }

            protected ConnectionProvider selectConnectionProvider(String tenantIdentifier) {
                if (MultiTenancyTest.DB1.equals(tenantIdentifier)) {
                    return MultiTenancyTest.this.db1;
                }
                if (MultiTenancyTest.DB2.equals(tenantIdentifier)) {
                    return MultiTenancyTest.this.db2;
                }
                throw new IllegalArgumentException();
            }
        });
    }

    protected void configureSessionFactoryBuilder(SessionFactoryBuilder sfb) {
        super.configureSessionFactoryBuilder(sfb);
        sfb.applyMultiTenancyStrategy(MultiTenancyStrategy.DATABASE);
    }

    protected void cleanupTest() throws Exception {
        this.db1.getConnection().close();
        this.db2.getConnection().close();
    }

    @Test
    public void testMultiTenancy() throws Exception {
        Item item = new Item("my item", "description");
        this.withTxSession(this.sessionFactory().withOptions().tenantIdentifier(DB1), s -> s.persist((Object)item));
        for (int i = 0; i < 5; ++i) {
            this.withTxSession(this.sessionFactory().withOptions().tenantIdentifier(DB1), s -> {
                Item item2 = (Item)s.get(Item.class, (Serializable)item.getId());
                Assert.assertNotNull((Object)item2);
                Assert.assertEquals((Object)item.getName(), (Object)item2.getName());
            });
        }
        EntityRegionImpl region = (EntityRegionImpl)this.sessionFactory().getSecondLevelCacheRegion(Item.class.getName());
        AdvancedCache localCache = region.getCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL});
        Assert.assertEquals((long)1L, (long)localCache.size());
        try (CloseableIterator iterator = localCache.keySet().iterator();){
            Assert.assertEquals((Object)"OldCacheKeyImplementation", (Object)iterator.next().getClass().getSimpleName());
        }
    }
}

