/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan.functional;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.cache.infinispan.util.InfinispanMessageLogger;
import org.hibernate.stat.SecondLevelCacheStatistics;
import org.hibernate.stat.Statistics;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.hibernate.test.cache.infinispan.functional.SingleNodeTest;
import org.hibernate.test.cache.infinispan.functional.entities.Item;
import org.junit.Assert;
import org.junit.Test;

public class ReadOnlyTest
extends SingleNodeTest {
    static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(ReadOnlyTest.class);

    @Override
    public List<Object[]> getParameters() {
        return this.getParameters(false, false, true, true);
    }

    @Test
    public void testEmptySecondLevelCacheEntry() throws Exception {
        this.sessionFactory().getCache().evictCollectionRegion(Item.class.getName() + ".items");
        StatisticsImplementor stats = this.sessionFactory().getStatistics();
        stats.clear();
        SecondLevelCacheStatistics statistics = stats.getSecondLevelCacheStatistics(Item.class.getName() + ".items");
        Map cacheEntries = statistics.getEntries();
        Assert.assertEquals((long)0L, (long)cacheEntries.size());
    }

    @Test
    public void testInsertDeleteEntity() throws Exception {
        StatisticsImplementor stats = this.sessionFactory().getStatistics();
        stats.clear();
        Item item = new Item("chris", "Chris's Item");
        this.withTxSession(s -> s.persist((Object)item));
        log.info((Object)"Entry persisted, let's load and delete it.");
        this.withTxSession(arg_0 -> ReadOnlyTest.lambda$testInsertDeleteEntity$107(item, (Statistics)stats, arg_0));
    }

    @Test
    public void testInsertClearCacheDeleteEntity() throws Exception {
        StatisticsImplementor stats = this.sessionFactory().getStatistics();
        stats.clear();
        Item item = new Item("chris", "Chris's Item");
        this.withTxSession(s -> s.persist((Object)item));
        Assert.assertEquals((long)0L, (long)stats.getSecondLevelCacheMissCount());
        Assert.assertEquals((long)0L, (long)stats.getSecondLevelCacheHitCount());
        Assert.assertEquals((long)1L, (long)stats.getSecondLevelCachePutCount());
        log.info((Object)"Entry persisted, let's load and delete it.");
        this.cleanupCache();
        Thread.sleep(10L);
        this.withTxSession(arg_0 -> ReadOnlyTest.lambda$testInsertClearCacheDeleteEntity$109(item, (Statistics)stats, arg_0));
    }

    private static /* synthetic */ void lambda$testInsertClearCacheDeleteEntity$109(Item item, Statistics statistics, Session s) throws Exception {
        Item found = (Item)s.load(Item.class, (Serializable)item.getId());
        log.info((Object)statistics.toString());
        Assert.assertEquals((Object)item.getDescription(), (Object)found.getDescription());
        Assert.assertEquals((long)1L, (long)statistics.getSecondLevelCacheMissCount());
        Assert.assertEquals((long)0L, (long)statistics.getSecondLevelCacheHitCount());
        Assert.assertEquals((long)2L, (long)statistics.getSecondLevelCachePutCount());
        s.delete((Object)found);
    }

    private static /* synthetic */ void lambda$testInsertDeleteEntity$107(Item item, Statistics statistics, Session s) throws Exception {
        Item found = (Item)s.load(Item.class, (Serializable)item.getId());
        log.info((Object)statistics.toString());
        Assert.assertEquals((Object)item.getDescription(), (Object)found.getDescription());
        Assert.assertEquals((long)0L, (long)statistics.getSecondLevelCacheMissCount());
        Assert.assertEquals((long)1L, (long)statistics.getSecondLevelCacheHitCount());
        s.delete((Object)found);
    }
}

