/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan.functional;

import java.util.concurrent.Callable;
import javax.transaction.TransactionManager;
import org.hibernate.Session;
import org.hibernate.SessionBuilder;
import org.hibernate.cache.infinispan.util.Caches;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.test.cache.infinispan.functional.AbstractFunctionalTest;
import org.hibernate.test.cache.infinispan.util.TxUtil;
import org.junit.Assert;

public abstract class SingleNodeTest
extends AbstractFunctionalTest {
    protected void afterSessionFactoryBuilt(SessionFactoryImplementor sessionFactory) {
        super.afterSessionFactoryBuilt(sessionFactory);
        JtaPlatform jtaPlatform = (JtaPlatform)this.sessionFactory().getServiceRegistry().getService(JtaPlatform.class);
        if (this.jtaPlatformClass != null) {
            Assert.assertNotNull((Object)jtaPlatform);
            Assert.assertEquals((Object)this.jtaPlatformClass, jtaPlatform.getClass());
        }
    }

    protected void withTxSession(TxUtil.ThrowingConsumer<Session, Exception> consumer) throws Exception {
        this.withTxSession((SessionBuilder)this.sessionFactory().withOptions(), consumer);
    }

    protected void withTxSession(SessionBuilder sessionBuilder, TxUtil.ThrowingConsumer<Session, Exception> consumer) throws Exception {
        JtaPlatform jtaPlatform = this.useJta ? (JtaPlatform)this.sessionFactory().getServiceRegistry().getService(JtaPlatform.class) : null;
        TxUtil.withTxSession(jtaPlatform, sessionBuilder, consumer);
    }

    protected <T> T withTxSessionApply(TxUtil.ThrowingFunction<Session, T, Exception> function) throws Exception {
        JtaPlatform jtaPlatform = this.useJta ? (JtaPlatform)this.sessionFactory().getServiceRegistry().getService(JtaPlatform.class) : null;
        return TxUtil.withTxSessionApply(jtaPlatform, (SessionBuilder)this.sessionFactory().withOptions(), function);
    }

    protected <T> T withTx(Callable<T> callable) throws Exception {
        if (this.useJta) {
            TransactionManager tm = ((JtaPlatform)this.sessionFactory().getServiceRegistry().getService(JtaPlatform.class)).retrieveTransactionManager();
            return (T)Caches.withinTx((TransactionManager)tm, () -> callable.call());
        }
        return callable.call();
    }

    public <E extends Throwable> void withSession(TxUtil.ThrowingConsumer<Session, E> consumer) throws E {
        TxUtil.withSession((SessionBuilder)this.sessionFactory().withOptions(), consumer);
    }

    public <R, E extends Throwable> R withSessionApply(TxUtil.ThrowingFunction<Session, R, E> function) throws E {
        return TxUtil.withSessionApply((SessionBuilder)this.sessionFactory().withOptions(), function);
    }
}

