/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan.functional;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.hibernate.cache.infinispan.util.Caches;
import org.hibernate.cache.infinispan.util.FutureUpdate;
import org.hibernate.cache.infinispan.util.Tombstone;
import org.hibernate.cache.spi.entry.StandardCacheEntryImpl;
import org.hibernate.test.cache.infinispan.functional.AbstractNonInvalidationTest;
import org.infinispan.AdvancedCache;
import org.junit.Assert;
import org.junit.Test;

public class TombstoneTest
extends AbstractNonInvalidationTest {
    @Override
    public List<Object[]> getParameters() {
        return Arrays.asList(READ_WRITE_REPLICATED, READ_WRITE_DISTRIBUTED);
    }

    @Test
    public void testTombstoneExpiration() throws Exception {
        CyclicBarrier loadBarrier = new CyclicBarrier(2);
        CountDownLatch flushLatch = new CountDownLatch(2);
        CountDownLatch commitLatch = new CountDownLatch(1);
        Future<Boolean> first = this.removeFlushWait(this.itemId, loadBarrier, null, flushLatch, commitLatch);
        Future<Boolean> second = this.removeFlushWait(this.itemId, loadBarrier, null, flushLatch, commitLatch);
        this.awaitOrThrow(flushLatch);
        Map contents = Caches.entrySet((AdvancedCache)this.entityCache).toMap();
        Assert.assertEquals((long)1L, (long)contents.size());
        Assert.assertEquals(Tombstone.class, contents.get(this.itemId).getClass());
        commitLatch.countDown();
        first.get(2000L, TimeUnit.SECONDS);
        second.get(2000L, TimeUnit.SECONDS);
        contents = Caches.entrySet((AdvancedCache)this.entityCache).toMap();
        Assert.assertEquals((long)1L, (long)contents.size());
        Assert.assertEquals(Tombstone.class, contents.get(this.itemId).getClass());
        TIME_SERVICE.advance(this.timeout + 1L);
        Assert.assertNull((Object)this.entityCache.get((Object)this.itemId));
        contents = Caches.entrySet((AdvancedCache)this.entityCache).toMap();
        Assert.assertEquals((Object)Collections.EMPTY_MAP, (Object)contents);
    }

    @Test
    public void testFutureUpdateExpiration() throws Exception {
        CyclicBarrier loadBarrier = new CyclicBarrier(2);
        CountDownLatch flushLatch = new CountDownLatch(2);
        CountDownLatch commitLatch = new CountDownLatch(1);
        Future<Boolean> first = this.updateFlushWait(this.itemId, loadBarrier, null, flushLatch, commitLatch);
        Future<Boolean> second = this.updateFlushWait(this.itemId, loadBarrier, null, flushLatch, commitLatch);
        this.awaitOrThrow(flushLatch);
        Map contents = Caches.entrySet((AdvancedCache)this.entityCache).toMap();
        Assert.assertEquals((long)1L, (long)contents.size());
        Assert.assertEquals(FutureUpdate.class, contents.get(this.itemId).getClass());
        commitLatch.countDown();
        first.get(2000L, TimeUnit.SECONDS);
        second.get(2000L, TimeUnit.SECONDS);
        contents = Caches.entrySet((AdvancedCache)this.entityCache).toMap();
        Assert.assertEquals((long)1L, (long)contents.size());
        Object value = contents.get(this.itemId);
        if (value instanceof FutureUpdate) {
            TIME_SERVICE.advance(this.timeout + 1L);
            Assert.assertNull((Object)this.entityCache.get((Object)this.itemId));
            contents = Caches.entrySet((AdvancedCache)this.entityCache).toMap();
            Assert.assertEquals((Object)Collections.EMPTY_MAP, (Object)contents);
        } else {
            Assert.assertNotNull(value);
            Assert.assertEquals(StandardCacheEntryImpl.class, value.getClass());
            TIME_SERVICE.advance(this.timeout + 1L);
            Assert.assertEquals(value, (Object)this.entityCache.get((Object)this.itemId));
        }
    }

    @Test
    public void testRemoveUpdateExpiration() throws Exception {
        CyclicBarrier loadBarrier = new CyclicBarrier(2);
        CountDownLatch preFlushLatch = new CountDownLatch(1);
        CountDownLatch flushLatch = new CountDownLatch(1);
        CountDownLatch commitLatch = new CountDownLatch(1);
        Future<Boolean> first = this.removeFlushWait(this.itemId, loadBarrier, null, flushLatch, commitLatch);
        Future<Boolean> second = this.updateFlushWait(this.itemId, loadBarrier, preFlushLatch, null, commitLatch);
        this.awaitOrThrow(flushLatch);
        Map contents = Caches.entrySet((AdvancedCache)this.entityCache).toMap();
        Assert.assertEquals((long)1L, (long)contents.size());
        Assert.assertEquals(Tombstone.class, contents.get(this.itemId).getClass());
        preFlushLatch.countDown();
        commitLatch.countDown();
        first.get(2000L, TimeUnit.SECONDS);
        second.get(2000L, TimeUnit.SECONDS);
        contents = Caches.entrySet((AdvancedCache)this.entityCache).toMap();
        Assert.assertEquals((long)1L, (long)contents.size());
        Assert.assertEquals(Tombstone.class, contents.get(this.itemId).getClass());
        TIME_SERVICE.advance(this.timeout + 1L);
        Assert.assertNull((Object)this.entityCache.get((Object)this.itemId));
        contents = Caches.entrySet((AdvancedCache)this.entityCache).toMap();
        Assert.assertEquals((Object)Collections.EMPTY_MAP, (Object)contents);
    }

    @Test
    public void testUpdateRemoveExpiration() throws Exception {
        CyclicBarrier loadBarrier = new CyclicBarrier(2);
        CountDownLatch preFlushLatch = new CountDownLatch(1);
        CountDownLatch flushLatch = new CountDownLatch(1);
        CountDownLatch commitLatch = new CountDownLatch(1);
        Future<Boolean> first = this.updateFlushWait(this.itemId, loadBarrier, null, flushLatch, commitLatch);
        Future<Boolean> second = this.removeFlushWait(this.itemId, loadBarrier, preFlushLatch, null, commitLatch);
        this.awaitOrThrow(flushLatch);
        Map contents = Caches.entrySet((AdvancedCache)this.entityCache).toMap();
        Assert.assertEquals((long)1L, (long)contents.size());
        Assert.assertEquals(FutureUpdate.class, contents.get(this.itemId).getClass());
        preFlushLatch.countDown();
        commitLatch.countDown();
        first.get(2000L, TimeUnit.SECONDS);
        boolean removeSucceeded = second.get(2000L, TimeUnit.SECONDS);
        contents = Caches.entrySet((AdvancedCache)this.entityCache).toMap();
        Assert.assertEquals((long)1L, (long)contents.size());
        Object value = contents.get(this.itemId);
        if (removeSucceeded) {
            Assert.assertEquals(Tombstone.class, value.getClass());
            TIME_SERVICE.advance(this.timeout + 1L);
            Assert.assertNull((Object)this.entityCache.get((Object)this.itemId));
            contents = Caches.entrySet((AdvancedCache)this.entityCache).toMap();
            Assert.assertEquals((Object)Collections.EMPTY_MAP, (Object)contents);
        } else {
            Assert.assertNotNull(value);
            Assert.assertEquals(StandardCacheEntryImpl.class, value.getClass());
            TIME_SERVICE.advance(this.timeout + 1L);
            Assert.assertEquals(value, (Object)this.entityCache.get((Object)this.itemId));
        }
    }

    @Test
    public void testUpdateEvictExpiration() throws Exception {
        CyclicBarrier loadBarrier = new CyclicBarrier(2);
        CountDownLatch preEvictLatch = new CountDownLatch(1);
        CountDownLatch flushLatch = new CountDownLatch(1);
        CountDownLatch commitLatch = new CountDownLatch(1);
        Future<Boolean> first = this.updateFlushWait(this.itemId, loadBarrier, null, flushLatch, commitLatch);
        Future<Boolean> second = this.evictWait(this.itemId, loadBarrier, preEvictLatch, null);
        this.awaitOrThrow(flushLatch);
        Map contents = Caches.entrySet((AdvancedCache)this.entityCache).toMap();
        Assert.assertEquals((long)1L, (long)contents.size());
        Assert.assertEquals(FutureUpdate.class, contents.get(this.itemId).getClass());
        preEvictLatch.countDown();
        commitLatch.countDown();
        first.get(2000L, TimeUnit.SECONDS);
        second.get(2000L, TimeUnit.SECONDS);
        contents = Caches.entrySet((AdvancedCache)this.entityCache).toMap();
        Assert.assertEquals((long)0L, (long)contents.size());
        Assert.assertNull(contents.get(this.itemId));
    }

    @Test
    public void testEvictUpdateExpiration() throws Exception {
        CyclicBarrier loadBarrier = new CyclicBarrier(2);
        CountDownLatch preFlushLatch = new CountDownLatch(1);
        CountDownLatch postEvictLatch = new CountDownLatch(1);
        CountDownLatch flushLatch = new CountDownLatch(1);
        CountDownLatch commitLatch = new CountDownLatch(1);
        Future<Boolean> first = this.evictWait(this.itemId, loadBarrier, null, postEvictLatch);
        Future<Boolean> second = this.updateFlushWait(this.itemId, loadBarrier, preFlushLatch, flushLatch, commitLatch);
        this.awaitOrThrow(postEvictLatch);
        Map contents = Caches.entrySet((AdvancedCache)this.entityCache).toMap();
        Assert.assertEquals((Object)Collections.EMPTY_MAP, (Object)contents);
        Assert.assertNull(contents.get(this.itemId));
        preFlushLatch.countDown();
        this.awaitOrThrow(flushLatch);
        contents = Caches.entrySet((AdvancedCache)this.entityCache).toMap();
        Assert.assertEquals((long)1L, (long)contents.size());
        Assert.assertEquals(FutureUpdate.class, contents.get(this.itemId).getClass());
        commitLatch.countDown();
        first.get(2000L, TimeUnit.SECONDS);
        second.get(2000L, TimeUnit.SECONDS);
        contents = Caches.entrySet((AdvancedCache)this.entityCache).toMap();
        Assert.assertEquals((long)1L, (long)contents.size());
        Object value = contents.get(this.itemId);
        Assert.assertNotNull(value);
        Assert.assertEquals(StandardCacheEntryImpl.class, value.getClass());
        TIME_SERVICE.advance(this.timeout + 1L);
        Assert.assertEquals(value, (Object)this.entityCache.get((Object)this.itemId));
    }
}

