/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan.functional.cluster;

import java.util.Hashtable;
import java.util.Properties;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.infinispan.InfinispanRegionFactory;
import org.hibernate.cache.infinispan.util.InfinispanMessageLogger;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.CollectionRegion;
import org.hibernate.cache.spi.EntityRegion;
import org.hibernate.cache.spi.NaturalIdRegion;
import org.hibernate.cache.spi.QueryResultsRegion;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.TimestampsRegion;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.test.cache.infinispan.util.CacheTestUtil;
import org.infinispan.manager.EmbeddedCacheManager;

public class ClusterAwareRegionFactory
implements RegionFactory {
    private static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(ClusterAwareRegionFactory.class);
    private static final Hashtable<String, EmbeddedCacheManager> cacheManagers = new Hashtable();
    private InfinispanRegionFactory delegate;
    private String cacheManagerName;
    private boolean locallyAdded;

    public ClusterAwareRegionFactory(Properties props) {
        Class regionFactoryClass = (Class)props.get("hibernate.cache.region.factory_delegate");
        this.delegate = CacheTestUtil.createRegionFactory(regionFactoryClass, props);
    }

    public static EmbeddedCacheManager getCacheManager(String name) {
        return cacheManagers.get(name);
    }

    public static void addCacheManager(String name, EmbeddedCacheManager manager) {
        cacheManagers.put(name, manager);
    }

    public static void clearCacheManagers() {
        for (EmbeddedCacheManager manager : cacheManagers.values()) {
            try {
                manager.stop();
            }
            catch (Exception e) {
                log.error((Object)("Exception cleaning up CacheManager " + manager), (Throwable)e);
            }
        }
        cacheManagers.clear();
    }

    public void start(SessionFactoryOptions settings, Properties properties) throws CacheException {
        this.cacheManagerName = properties.getProperty("hibernate.test.cluster.node.id");
        EmbeddedCacheManager existing = ClusterAwareRegionFactory.getCacheManager(this.cacheManagerName);
        boolean bl = this.locallyAdded = existing == null;
        if (this.locallyAdded) {
            this.delegate.start(settings, properties);
            cacheManagers.put(this.cacheManagerName, this.delegate.getCacheManager());
        } else {
            this.delegate.setCacheManager(existing);
        }
    }

    public void stop() {
        if (this.locallyAdded) {
            cacheManagers.remove(this.cacheManagerName);
        }
        this.delegate.stop();
    }

    public CollectionRegion buildCollectionRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        return this.delegate.buildCollectionRegion(regionName, properties, metadata);
    }

    public EntityRegion buildEntityRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        return this.delegate.buildEntityRegion(regionName, properties, metadata);
    }

    public NaturalIdRegion buildNaturalIdRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        return this.delegate.buildNaturalIdRegion(regionName, properties, metadata);
    }

    public QueryResultsRegion buildQueryResultsRegion(String regionName, Properties properties) throws CacheException {
        return this.delegate.buildQueryResultsRegion(regionName, properties);
    }

    public TimestampsRegion buildTimestampsRegion(String regionName, Properties properties) throws CacheException {
        return this.delegate.buildTimestampsRegion(regionName, properties);
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return this.delegate.isMinimalPutsEnabledByDefault();
    }

    public AccessType getDefaultAccessType() {
        return AccessType.TRANSACTIONAL;
    }

    public long nextTimestamp() {
        return this.delegate.nextTimestamp();
    }
}

