/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan.functional.cluster;

import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cache.infinispan.util.InfinispanMessageLogger;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.test.cache.infinispan.functional.cluster.ClusterAwareRegionFactory;
import org.hibernate.test.cache.infinispan.functional.cluster.DualNodeTest;
import org.hibernate.test.cache.infinispan.functional.entities.Citizen;
import org.hibernate.test.cache.infinispan.functional.entities.NaturalIdOnManyToOne;
import org.hibernate.test.cache.infinispan.functional.entities.State;
import org.infinispan.Cache;
import org.infinispan.CacheSet;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryVisited;
import org.infinispan.notifications.cachelistener.event.CacheEntryVisitedEvent;
import org.jboss.util.collection.ConcurrentSet;
import org.junit.Assert;
import org.junit.Test;

public class NaturalIdInvalidationTest
extends DualNodeTest {
    private static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(NaturalIdInvalidationTest.class);
    private static final long SLEEP_TIME = 50L;

    @Override
    public List<Object[]> getParameters() {
        return this.getParameters(true, true, true, true);
    }

    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Citizen.class, State.class, NaturalIdOnManyToOne.class};
    }

    @Test
    public void testAll() throws Exception {
        log.info((Object)"*** testAll()");
        EmbeddedCacheManager localManager = ClusterAwareRegionFactory.getCacheManager("local");
        Cache localNaturalIdCache = localManager.getCache(Citizen.class.getName() + "##NaturalId");
        MyListener localListener = new MyListener("local");
        localNaturalIdCache.addListener((Object)localListener);
        EmbeddedCacheManager remoteManager = ClusterAwareRegionFactory.getCacheManager("remote");
        Cache remoteNaturalIdCache = remoteManager.getCache(Citizen.class.getName() + "##NaturalId");
        MyListener remoteListener = new MyListener("remote");
        remoteNaturalIdCache.addListener((Object)remoteListener);
        SessionFactoryImplementor localFactory = this.sessionFactory();
        SessionFactoryImplementor remoteFactory = this.secondNodeEnvironment().getSessionFactory();
        try {
            Assert.assertTrue((boolean)remoteListener.isEmpty());
            Assert.assertTrue((boolean)localListener.isEmpty());
            this.saveSomeCitizens((SessionFactory)localFactory);
            Assert.assertTrue((boolean)remoteListener.isEmpty());
            Assert.assertTrue((boolean)localListener.isEmpty());
            this.sleep(50L);
            log.debug((Object)"Find node 0");
            this.getCitizenWithCriteria((SessionFactory)localFactory);
            this.sleep(50L);
            log.debug((Object)"Find(2) node 0");
            localListener.clear();
            this.getCitizenWithCriteria((SessionFactory)localFactory);
            log.debug((Object)"Check cache 0");
            this.assertLoadedFromCache(localListener, "1234");
            log.debug((Object)"Find node 1");
            this.getCitizenWithCriteria((SessionFactory)remoteFactory);
            log.debug((Object)"Find(2) node 1");
            remoteListener.clear();
            this.getCitizenWithCriteria((SessionFactory)remoteFactory);
            log.debug((Object)"Check cache 1");
            this.assertLoadedFromCache(remoteListener, "1234");
            remoteListener.clear();
            this.deleteCitizenWithCriteria((SessionFactory)remoteFactory);
            this.sleep(250L);
            CacheSet localKeys = localNaturalIdCache.keySet();
            Assert.assertEquals((long)1L, (long)localKeys.size());
            localKeys.toString().contains("000");
        }
        catch (Exception e) {
            log.error((Object)"Error", (Throwable)e);
            throw e;
        }
        finally {
            this.withTxSession((SessionFactory)localFactory, s -> {
                s.createQuery("delete NaturalIdOnManyToOne").executeUpdate();
                s.createQuery("delete Citizen").executeUpdate();
                s.createQuery("delete State").executeUpdate();
            });
        }
    }

    private void assertLoadedFromCache(MyListener localListener, String id) {
        for (String visited : localListener.visited) {
            if (!visited.contains(id)) continue;
            return;
        }
        Assert.fail((String)("Citizen (" + id + ") should have present in the cache"));
    }

    private void saveSomeCitizens(SessionFactory sf) throws Exception {
        Citizen c1 = new Citizen();
        c1.setFirstname("Emmanuel");
        c1.setLastname("Bernard");
        c1.setSsn("1234");
        State france = new State();
        france.setName("Ile de France");
        c1.setState(france);
        Citizen c2 = new Citizen();
        c2.setFirstname("Gavin");
        c2.setLastname("King");
        c2.setSsn("000");
        State australia = new State();
        australia.setName("Australia");
        c2.setState(australia);
        this.withTxSession(sf, s -> {
            s.persist((Object)australia);
            s.persist((Object)france);
            s.persist((Object)c1);
            s.persist((Object)c2);
        });
    }

    private void getCitizenWithCriteria(SessionFactory sf) throws Exception {
        this.withTxSession(sf, s -> {
            State france = this.getState((Session)s, "Ile de France");
            Criteria criteria = s.createCriteria(Citizen.class);
            criteria.add((Criterion)Restrictions.naturalId().set("ssn", (Object)"1234").set("state", (Object)france));
            criteria.setCacheable(true);
            criteria.list();
        });
    }

    private void deleteCitizenWithCriteria(SessionFactory sf) throws Exception {
        this.withTxSession(sf, s -> {
            State france = this.getState((Session)s, "Ile de France");
            Criteria criteria = s.createCriteria(Citizen.class);
            criteria.add((Criterion)Restrictions.naturalId().set("ssn", (Object)"1234").set("state", (Object)france));
            criteria.setCacheable(true);
            Citizen c = (Citizen)criteria.uniqueResult();
            s.delete((Object)c);
        });
    }

    private State getState(Session s, String name) {
        Criteria criteria = s.createCriteria(State.class);
        criteria.add((Criterion)Restrictions.eq((String)"name", (Object)name));
        criteria.setCacheable(true);
        return (State)criteria.list().get(0);
    }

    @Listener
    public static class MyListener {
        private static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(MyListener.class);
        private Set<String> visited = new ConcurrentSet();
        private final String name;

        public MyListener(String name) {
            this.name = name;
        }

        public void clear() {
            this.visited.clear();
        }

        public boolean isEmpty() {
            return this.visited.isEmpty();
        }

        @CacheEntryVisited
        public void nodeVisited(CacheEntryVisitedEvent event) {
            log.debug((Object)event.toString());
            if (!event.isPre()) {
                this.visited.add(event.getKey().toString());
            }
        }
    }
}

