/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan.stress;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.transaction.RollbackException;
import javax.transaction.TransactionManager;
import org.hibernate.LockMode;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.PessimisticLockException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.StaleObjectStateException;
import org.hibernate.StaleStateException;
import org.hibernate.Transaction;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cache.infinispan.access.InvalidationCacheAccessDelegate;
import org.hibernate.cache.infinispan.access.PutFromLoadValidator;
import org.hibernate.cache.infinispan.util.InfinispanMessageLogger;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.access.RegionAccessStrategy;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.transaction.jta.platform.internal.NoJtaPlatform;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.RootClass;
import org.hibernate.resource.transaction.backend.jdbc.internal.JdbcResourceLocalTransactionCoordinatorBuilderImpl;
import org.hibernate.resource.transaction.backend.jta.internal.JtaTransactionCoordinatorBuilderImpl;
import org.hibernate.resource.transaction.spi.TransactionStatus;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.test.cache.infinispan.stress.entities.Address;
import org.hibernate.test.cache.infinispan.stress.entities.Family;
import org.hibernate.test.cache.infinispan.stress.entities.Person;
import org.hibernate.test.cache.infinispan.util.TestInfinispanRegionFactory;
import org.hibernate.testing.jta.JtaAwareConnectionProviderImpl;
import org.hibernate.testing.jta.TestingJtaPlatformImpl;
import org.hibernate.testing.junit4.CustomParameterized;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commons.util.ByRef;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.InterceptorConfiguration;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.base.BaseCustomInterceptor;
import org.infinispan.remoting.RemoteException;
import org.infinispan.util.concurrent.TimeoutException;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=CustomParameterized.class)
public abstract class CorrectnessTestCase {
    static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(CorrectnessTestCase.class);
    static final long EXECUTION_TIME = TimeUnit.MINUTES.toMillis(10L);
    static final int NUM_NODES = 4;
    static final int NUM_THREADS_PER_NODE = 4;
    static final int NUM_THREADS = 16;
    static final int NUM_FAMILIES = 1;
    static final int NUM_ACCESS_AFTER_REMOVAL = 32;
    static final int MAX_MEMBERS = 10;
    private static final Comparator<Log<?>> WALL_CLOCK_TIME_COMPARATOR = (o1, o2) -> Long.compare(o1.wallClockTime, o2.wallClockTime);
    @Parameterized.Parameter(value=0)
    public String name;
    @Parameterized.Parameter(value=1)
    public CacheMode cacheMode;
    @Parameterized.Parameter(value=2)
    public AccessType accessType;
    static ThreadLocal<Integer> threadNode = new ThreadLocal();
    final AtomicInteger timestampGenerator = new AtomicInteger();
    final ConcurrentSkipListMap<Integer, AtomicInteger> familyIds = new ConcurrentSkipListMap();
    SessionFactory[] sessionFactories;
    volatile boolean running = true;
    final ThreadLocal<Map<Integer, List<Log<String>>>> familyNames = new ThreadLocal<Map<Integer, List<Log<String>>>>(){

        @Override
        protected Map<Integer, List<Log<String>>> initialValue() {
            return new HashMap<Integer, List<Log<String>>>();
        }
    };
    final ThreadLocal<Map<Integer, List<Log<Set<String>>>>> familyMembers = new ThreadLocal<Map<Integer, List<Log<Set<String>>>>>(){

        @Override
        protected Map<Integer, List<Log<Set<String>>>> initialValue() {
            return new HashMap<Integer, List<Log<Set<String>>>>();
        }
    };
    private List<Exception> exceptions = Collections.synchronizedList(new ArrayList());

    public String getDbName() {
        return this.getClass().getName().replaceAll("\\W", "_");
    }

    @Before
    public void beforeClass() {
        Arrays.asList(new File(System.getProperty("java.io.tmpdir")).listFiles((dir, name) -> name.startsWith("family_") || name.startsWith("invalidations-"))).stream().forEach(f -> f.delete());
        StandardServiceRegistryBuilder ssrb = new StandardServiceRegistryBuilder().enableAutoClose().applySetting("hibernate.cache.use_second_level_cache", (Object)"true").applySetting("hibernate.cache.use_query_cache", (Object)"true").applySetting("hibernate.connection.driver_class", (Object)"org.h2.Driver").applySetting("hibernate.connection.url", (Object)("jdbc:h2:mem:" + this.getDbName() + ";TRACE_LEVEL_FILE=4")).applySetting("hibernate.dialect", (Object)H2Dialect.class.getName()).applySetting("hibernate.hbm2ddl.auto", (Object)"create-drop").applySetting("hibernate.cache.region.factory_class", (Object)FailingInfinispanRegionFactory.class.getName()).applySetting(TestInfinispanRegionFactory.CACHE_MODE, (Object)this.cacheMode).applySetting("hibernate.generate_statistics", (Object)"false");
        this.applySettings(ssrb);
        this.sessionFactories = new SessionFactory[4];
        for (int i = 0; i < 4; ++i) {
            StandardServiceRegistry registry = ssrb.build();
            Metadata metadata = CorrectnessTestCase.buildMetadata(registry);
            this.sessionFactories[i] = metadata.buildSessionFactory();
        }
    }

    protected void applySettings(StandardServiceRegistryBuilder ssrb) {
        ssrb.applySetting("hibernate.cache.default_cache_concurrency_strategy", (Object)this.accessType.getExternalName());
        ssrb.applySetting(TestInfinispanRegionFactory.TRANSACTIONAL, (Object)(this.accessType == AccessType.TRANSACTIONAL ? 1 : 0));
    }

    @After
    public void afterClass() {
        for (SessionFactory sf : this.sessionFactories) {
            if (sf == null) continue;
            sf.close();
        }
    }

    public static Class[] getAnnotatedClasses() {
        return new Class[]{Family.class, Person.class, Address.class};
    }

    private static Metadata buildMetadata(StandardServiceRegistry registry) {
        String cacheStrategy = "transactional";
        MetadataSources metadataSources = new MetadataSources((ServiceRegistry)registry);
        for (Class entityClass : CorrectnessTestCase.getAnnotatedClasses()) {
            metadataSources.addAnnotatedClass(entityClass);
        }
        Metadata metadata = metadataSources.buildMetadata();
        for (PersistentClass entityBinding : metadata.getEntityBindings()) {
            if (entityBinding.isInherited()) continue;
            ((RootClass)entityBinding).setCacheConcurrencyStrategy("transactional");
        }
        for (org.hibernate.mapping.Collection collectionBinding : metadata.getCollectionBindings()) {
            collectionBinding.setCacheConcurrencyStrategy("transactional");
        }
        return metadata;
    }

    @Test
    public void test() throws Exception {
        ExecutorService exec = Executors.newFixedThreadPool(16);
        HashMap allFamilyNames = new HashMap();
        HashMap allFamilyMembers = new HashMap();
        this.running = true;
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        for (int node = 0; node < 4; ++node) {
            int NODE = node;
            int i = 0;
            while (i < 4) {
                int n = i++;
                futures.add(exec.submit(() -> {
                    Thread.currentThread().setName("Node" + (char)(65 + NODE) + "-thread-" + I);
                    threadNode.set(NODE);
                    while (this.running) {
                        Operation operation = this.familyIds.size() < 1 ? new InsertFamily(ThreadLocalRandom.current().nextInt(5) == 0) : this.getOperation();
                        try {
                            operation.run();
                        }
                        catch (Exception e) {
                            Throwable throwable;
                            Throwable throwable2;
                            if (this.hasCause(e, InducedException.class) || (e instanceof RollbackException ? (throwable2 = e.getCause()) instanceof StaleObjectStateException || throwable2 instanceof PessimisticLockException || throwable2 instanceof LockAcquisitionException : (e instanceof RemoteException ? (throwable = e.getCause()) instanceof TimeoutException : e instanceof StaleStateException || e instanceof PessimisticLockException || e instanceof ObjectNotFoundException || e instanceof ConstraintViolationException || e instanceof LockAcquisitionException))) continue;
                            this.exceptions.add(e);
                            log.error((Object)("Failed " + operation.getClass().getName()), (Throwable)e);
                        }
                    }
                    Map map3 = allFamilyNames;
                    synchronized (map3) {
                        List list;
                        for (Map.Entry<Integer, List<Log<String>>> entry : this.familyNames.get().entrySet()) {
                            list = (ArrayList)allFamilyNames.get(entry.getKey());
                            if (list == null) {
                                list = new ArrayList();
                                allFamilyNames.put(entry.getKey(), list);
                            }
                            list.addAll(entry.getValue());
                        }
                        for (Map.Entry<Integer, List<Log<Object>>> entry : this.familyMembers.get().entrySet()) {
                            list = (List)allFamilyMembers.get(entry.getKey());
                            if (list == null) {
                                list = new ArrayList();
                                allFamilyMembers.put(entry.getKey(), list);
                            }
                            list.addAll(entry.getValue());
                        }
                    }
                    return null;
                }));
            }
        }
        long testEnd = System.currentTimeMillis() + EXECUTION_TIME;
        while (System.currentTimeMillis() < testEnd && this.exceptions.isEmpty()) {
            Thread.sleep(1000L);
        }
        this.running = false;
        exec.shutdown();
        if (!exec.awaitTermination(1000L, TimeUnit.SECONDS)) {
            throw new IllegalStateException();
        }
        for (Future future : futures) {
            future.get();
        }
        this.checkForEmptyPendingPuts();
        log.infof("Generated %d timestamps%n", (Object)this.timestampGenerator.get());
        AtomicInteger created = new AtomicInteger();
        AtomicInteger atomicInteger = new AtomicInteger();
        ForkJoinPool threadPool = ForkJoinPool.commonPool();
        ArrayList<Future> tasks = new ArrayList<Future>();
        for (Map.Entry entry : allFamilyNames.entrySet()) {
            tasks.add(threadPool.submit(() -> {
                int familyId = (Integer)entry.getKey();
                List list = (List)entry.getValue();
                created.incrementAndGet();
                NavigableMap logByTime = this.getWritesAtTime(list);
                this.checkCorrectness("family_name-" + familyId + "-", list, logByTime);
                if (list.stream().anyMatch(l -> l.type == LogType.WRITE && l.getValue() == null)) {
                    removed.incrementAndGet();
                }
            }));
        }
        for (Map.Entry entry : allFamilyMembers.entrySet()) {
            tasks.add(threadPool.submit(() -> {
                int familyId = (Integer)entry.getKey();
                List list = (List)entry.getValue();
                NavigableMap logByTime = this.getWritesAtTime(list);
                this.checkCorrectness("family_members-" + familyId + "-", list, logByTime);
            }));
        }
        for (ForkJoinTask forkJoinTask : tasks) {
            forkJoinTask.get();
        }
        if (!this.exceptions.isEmpty()) {
            for (Exception exception : this.exceptions) {
                log.error((Object)"Test failure", (Throwable)exception);
            }
            throw new IllegalStateException("There were " + this.exceptions.size() + " exceptions");
        }
        log.infof("Created %d families, removed %d%n", (Object)created.get(), (Object)atomicInteger.get());
    }

    protected void checkForEmptyPendingPuts() throws Exception {
        Field pp = PutFromLoadValidator.class.getDeclaredField("pendingPuts");
        pp.setAccessible(true);
        Method getInvalidators = null;
        LinkedList<DelayedInvalidators> delayed = new LinkedList<DelayedInvalidators>();
        for (int i = 0; i < this.sessionFactories.length; ++i) {
            SessionFactoryImplementor sfi = (SessionFactoryImplementor)this.sessionFactories[i];
            for (String regionName : sfi.getCache().getSecondLevelCacheRegionNames()) {
                PutFromLoadValidator validator = this.getPutFromLoadValidator(sfi, regionName);
                if (validator == null) {
                    log.warn((Object)("No validator for " + regionName));
                    continue;
                }
                ConcurrentMap map = (ConcurrentMap)pp.get(validator);
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Collection invalidators;
                    Map.Entry entry = iterator.next();
                    if (getInvalidators == null) {
                        getInvalidators = entry.getValue().getClass().getMethod("getInvalidators", new Class[0]);
                        getInvalidators.setAccessible(true);
                    }
                    if ((invalidators = (Collection)getInvalidators.invoke(entry.getValue(), new Object[0])) != null && !invalidators.isEmpty()) {
                        delayed.add(new DelayedInvalidators(map, entry.getKey()));
                    }
                    iterator.remove();
                }
            }
        }
        long deadline = System.currentTimeMillis() + 30000L;
        while (System.currentTimeMillis() < deadline) {
            Iterator iterator = delayed.iterator();
            while (iterator.hasNext()) {
                DelayedInvalidators entry = (DelayedInvalidators)iterator.next();
                Object pendingPutMap = entry.getPendingPutMap();
                if (pendingPutMap == null) {
                    iterator.remove();
                    continue;
                }
                Collection invalidators = (Collection)getInvalidators.invoke(pendingPutMap, new Object[0]);
                if (invalidators != null && !invalidators.isEmpty()) continue;
                iterator.remove();
            }
            if (delayed.isEmpty()) break;
            Thread.sleep(1000L);
        }
        if (!delayed.isEmpty()) {
            throw new IllegalStateException("Invalidators were not cleared: " + delayed);
        }
    }

    private boolean hasCause(Throwable throwable, Class<? extends Throwable> clazz) {
        if (throwable == null) {
            return false;
        }
        Throwable cause = throwable.getCause();
        if (throwable == cause) {
            return false;
        }
        if (clazz.isInstance(cause)) {
            return true;
        }
        return this.hasCause(cause, clazz);
    }

    protected Operation getOperation() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        int r = random.nextInt(100);
        Operation operation = r == 0 ? new InvalidateCache() : (r < 5 ? new QueryFamilies() : (r < 10 ? new RemoveFamily(r < 6) : (r < 20 ? new UpdateFamily(r < 12, random.nextInt(1, 3)) : (r < 35 ? new AddMember(r < 25) : (r < 50 ? new RemoveMember(r < 40) : new ReadFamily(r < 75))))));
        return operation;
    }

    private <T> NavigableMap<Integer, List<Log<T>>> getWritesAtTime(List<Log<T>> list) {
        TreeMap<Integer, List<Log<T>>> writes = new TreeMap<Integer, List<Log<T>>>();
        for (Log<T> log : list) {
            if (log.type != LogType.WRITE) continue;
            for (int time = log.before; time <= log.after; ++time) {
                ArrayList<Log<T>> onTime = (ArrayList<Log<T>>)writes.get(time);
                if (onTime == null) {
                    onTime = new ArrayList<Log<T>>();
                    writes.put(time, onTime);
                }
                onTime.add(log);
            }
        }
        return writes;
    }

    private <T> void checkCorrectness(String dumpPrefix, List<Log<T>> logs, NavigableMap<Integer, List<Log<T>>> writesByTime) {
        Collections.sort(logs, WALL_CLOCK_TIME_COMPARATOR);
        int nullReads = 0;
        int reads = 0;
        int writes = 0;
        for (Log<T> read : logs) {
            Map.Entry entry;
            int time;
            if (read.type != LogType.READ) {
                ++writes;
                continue;
            }
            if (read.getValue() == null || CorrectnessTestCase.isEmptyCollection(read)) {
                ++nullReads;
            } else {
                ++reads;
            }
            HashMap possibleValues = new HashMap();
            for (List list : writesByTime.subMap(read.before, true, read.after, true).values()) {
                for (Log write : list) {
                    if (read.precedes(write)) continue;
                    possibleValues.put(write.getValue(), write);
                }
            }
            int startOfLastWriteBeforeRead = 0;
            Iterator iterator = writesByTime.headMap(read.before, false).descendingMap().entrySet().iterator();
            while (iterator.hasNext() && (time = ((Integer)(entry = iterator.next()).getKey()).intValue()) >= startOfLastWriteBeforeRead) {
                for (Log write : (List)entry.getValue()) {
                    if (write.after < read.before && write.before > startOfLastWriteBeforeRead) {
                        startOfLastWriteBeforeRead = write.before;
                    }
                    possibleValues.put(write.getValue(), write);
                }
            }
            if (possibleValues.isEmpty()) break;
            if (possibleValues.containsKey(read.getValue())) continue;
            this.dumpLogs(dumpPrefix, logs);
            this.exceptions.add(new IllegalStateException(String.format("R %s: %d .. %d (%s, %s) -> %s not in %s (%d+)", dumpPrefix, read.before, read.after, read.threadName, new SimpleDateFormat("HH:mm:ss,SSS").format(new Date(read.wallClockTime)), read.getValue(), possibleValues.values(), startOfLastWriteBeforeRead)));
            break;
        }
        log.infof("Checked %d null reads, %d reads and %d writes%n", (Object)nullReads, (Object)reads, (Object)writes);
    }

    private <T> void dumpLogs(String prefix, List<Log<T>> logs) {
        try {
            File f = File.createTempFile(prefix, ".log");
            log.info((Object)("Dumping logs into " + f.getAbsolutePath()));
            try (BufferedWriter writer = Files.newBufferedWriter(f.toPath(), new OpenOption[0]);){
                for (Log<T> log : logs) {
                    writer.write(log.toString());
                    writer.write(10);
                }
            }
        }
        catch (IOException e) {
            log.error((Object)"Failed to dump family logs");
        }
    }

    private static boolean isEmptyCollection(Log read) {
        return read.getValue() instanceof Collection && ((Collection)read.getValue()).isEmpty();
    }

    protected abstract void withTx(Runnable var1, boolean var2) throws Exception;

    private Set<String> membersToNames(Set<Person> members) {
        return members.stream().map(p -> p.getFirstName()).collect(Collectors.toSet());
    }

    private PutFromLoadValidator getPutFromLoadValidator(SessionFactoryImplementor sfi, String regionName) throws NoSuchFieldException, IllegalAccessException {
        RegionAccessStrategy strategy = sfi.getSecondLevelCacheRegionAccessStrategy(regionName);
        if (strategy == null) {
            return null;
        }
        Field delegateField = this.getField(strategy.getClass(), "delegate");
        Object delegate = delegateField.get(strategy);
        if (delegate == null) {
            return null;
        }
        if (InvalidationCacheAccessDelegate.class.isInstance(delegate)) {
            Field validatorField = InvalidationCacheAccessDelegate.class.getDeclaredField("putValidator");
            validatorField.setAccessible(true);
            return (PutFromLoadValidator)validatorField.get(delegate);
        }
        return null;
    }

    private Field getField(Class<?> clazz, String fieldName) {
        Field f = null;
        while (clazz != null && clazz != Object.class) {
            try {
                f = clazz.getDeclaredField(fieldName);
                break;
            }
            catch (NoSuchFieldException e) {
                clazz = clazz.getSuperclass();
            }
        }
        if (f != null) {
            f.setAccessible(true);
        }
        return f;
    }

    protected SessionFactory sessionFactory(int node) {
        return this.sessionFactories[node];
    }

    private void familyNotFound(int id) {
        AtomicInteger access = this.familyIds.get(id);
        if (access == null) {
            return;
        }
        if (access.decrementAndGet() == 0) {
            this.familyIds.remove(id);
        }
    }

    private <T> List<T> getRecordList(ThreadLocal<Map<Integer, List<T>>> tlListMap, int id) {
        Map<Integer, List<T>> map = tlListMap.get();
        List<T> list = map.get(id);
        if (list == null) {
            list = new ArrayList<T>();
            map.put(id, list);
        }
        return list;
    }

    private int randomFamilyId(ThreadLocalRandom random) {
        Map.Entry<Integer, AtomicInteger> first = this.familyIds.firstEntry();
        Map.Entry<Integer, AtomicInteger> last = this.familyIds.lastEntry();
        if (first == null || last == null) {
            return 0;
        }
        Map.Entry<Integer, AtomicInteger> ceiling = this.familyIds.ceilingEntry(random.nextInt(first.getKey(), last.getKey() + 1));
        return ceiling == null ? 0 : ceiling.getKey();
    }

    private static Family createFamily() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        String familyName = CorrectnessTestCase.randomString(random);
        Family f = new Family(familyName);
        HashSet<Person> members = new HashSet<Person>();
        members.add(CorrectnessTestCase.createPerson(random, f));
        f.setMembers(members);
        return f;
    }

    private static Person createPerson(ThreadLocalRandom random, Family family) {
        return new Person(CorrectnessTestCase.randomString(random), family);
    }

    private static String randomString(ThreadLocalRandom random) {
        StringBuilder sb = new StringBuilder(10);
        for (int i = 0; i < 10; ++i) {
            sb.append((char)random.nextInt(65, 91));
        }
        return sb.toString();
    }

    private static class Ref<T> {
        private static Ref EMPTY = new Ref(){

            public void set(Object value) {
                throw new UnsupportedOperationException();
            }
        };
        private boolean set;
        private T value;

        private Ref() {
        }

        public static <T> Ref<T> empty() {
            return EMPTY;
        }

        public static <T> Ref<T> of(T value) {
            Ref<T> ref = new Ref<T>();
            ref.set(value);
            return ref;
        }

        public boolean isSet() {
            return this.set;
        }

        public T get() {
            return this.value;
        }

        public void set(T value) {
            this.value = value;
            this.set = true;
        }
    }

    private class Log<T> {
        int before;
        int after;
        T value;
        LogType type;
        Log[] preceding;
        String threadName = Thread.currentThread().getName();
        long wallClockTime = System.currentTimeMillis();

        public Log(int time) {
            this();
            this.before = time;
            this.after = time;
        }

        public Log(int before, int after, T value, LogType type, Log<T> ... preceding) {
            this();
            this.before = before;
            this.after = after;
            this.value = value;
            this.type = type;
            this.preceding = preceding;
        }

        public Log() {
        }

        public Log setType(LogType type) {
            this.type = type;
            return this;
        }

        public void setTimes(int before, int after) {
            this.before = before;
            this.after = after;
        }

        public void setValue(T value) {
            this.value = value;
        }

        public T getValue() {
            return this.value;
        }

        public boolean precedes(Log<T> write) {
            if (write.preceding == null) {
                return false;
            }
            for (Log l : write.preceding) {
                if (l != this) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return String.format("%c: %5d - %5d\t(%s,\t%s)\t%s", Character.valueOf(this.type.shortName), this.before, this.after, new SimpleDateFormat("HH:mm:ss,SSS").format(new Date(this.wallClockTime)), this.threadName, this.value);
        }
    }

    private static enum LogType {
        READ('R'),
        WRITE('W'),
        READ_FAILURE('L'),
        WRITE_FAILURE('F');

        private final char shortName;

        private LogType(char shortName) {
            this.shortName = shortName;
        }
    }

    private class InvalidateCache
    extends Operation {
        public InvalidateCache() {
            super(false);
        }

        @Override
        public void run() throws Exception {
            log.trace((Object)"Invalidating all caches");
            CorrectnessTestCase.this.withTx(() -> {
                int node = threadNode.get();
                CorrectnessTestCase.this.sessionFactory(node).getCache().evictAllRegions();
            }, this.rolledBack);
        }
    }

    private class QueryFamilies
    extends Operation {
        static final int MAX_RESULTS = 10;

        public QueryFamilies() {
            super(false);
        }

        @Override
        public void run() throws Exception {
            String prefix = new StringBuilder(2).append((char)ThreadLocalRandom.current().nextInt(65, 91)).append('%').toString();
            int[] ids = new int[10];
            String[] names = new String[10];
            Set[] members = new Set[10];
            int before = CorrectnessTestCase.this.timestampGenerator.getAndIncrement();
            log.tracef("Started QueryFamilies at %d", before);
            this.withSession(s -> {
                List results = s.createCriteria(Family.class).add((Criterion)Restrictions.like((String)"name", (Object)prefix)).setMaxResults(10).setCacheable(true).list();
                int index = 0;
                for (Family f : results) {
                    nArray[index] = f.getId();
                    stringArray[index] = f.getName();
                    setArray[index] = CorrectnessTestCase.this.membersToNames(f.getMembers());
                    ++index;
                }
            });
            int after = CorrectnessTestCase.this.timestampGenerator.getAndIncrement();
            log.tracef("Finished QueryFamilies at %d", after);
            for (int index = 0; index < 10 && names[index] != null; ++index) {
                CorrectnessTestCase.this.getRecordList(CorrectnessTestCase.this.familyNames, ids[index]).add(new Log<String>(before, after, names[index], LogType.READ, new Log[0]));
                CorrectnessTestCase.this.getRecordList(CorrectnessTestCase.this.familyMembers, ids[index]).add(new Log<Set>(before, after, members[index], LogType.READ, new Log[0]));
            }
        }
    }

    private class RemoveMember
    extends MemberOperation {
        public RemoveMember(boolean rolledBack) {
            super(rolledBack);
        }

        @Override
        protected boolean updateMembers(Session s, ThreadLocalRandom random, Family f) {
            int numMembers = f.getMembers().size();
            if (numMembers > 0) {
                Iterator<Person> it = f.getMembers().iterator();
                Person person = null;
                for (int i = random.nextInt(numMembers); i >= 0; --i) {
                    person = it.next();
                }
                it.remove();
                if (person != null) {
                    s.delete((Object)person);
                }
                return true;
            }
            return false;
        }
    }

    private class AddMember
    extends MemberOperation {
        public AddMember(boolean rolledBack) {
            super(rolledBack);
        }

        @Override
        protected boolean updateMembers(Session s, ThreadLocalRandom random, Family f) {
            Set<Person> members = f.getMembers();
            if (members.size() < 10) {
                members.add(CorrectnessTestCase.createPerson(random, f));
                return true;
            }
            return false;
        }
    }

    private abstract class MemberOperation
    extends Operation {
        public MemberOperation(boolean rolledBack) {
            super(rolledBack);
        }

        @Override
        public void run() throws Exception {
            Ref<Set<String>> newMembers = new Ref<Set<String>>();
            this.withRandomFamily((s, f) -> {
                boolean updated = this.updateMembers((Session)s, ThreadLocalRandom.current(), (Family)f);
                if (updated) {
                    newMembers.set(CorrectnessTestCase.this.membersToNames(f.getMembers()));
                    s.persist(f);
                }
            }, Ref.empty(), newMembers, LockMode.OPTIMISTIC_FORCE_INCREMENT);
        }

        protected abstract boolean updateMembers(Session var1, ThreadLocalRandom var2, Family var3);
    }

    private class RemoveFamily
    extends Operation {
        public RemoveFamily(boolean rolledBack) {
            super(rolledBack);
        }

        @Override
        public void run() throws Exception {
            this.withRandomFamily((s, f) -> s.delete(f), Ref.of(null), Ref.of(Collections.EMPTY_SET), LockMode.OPTIMISTIC);
        }
    }

    private class UpdateFamily
    extends Operation {
        private final int numUpdates;

        public UpdateFamily(boolean rolledBack, int numUpdates) {
            super(rolledBack);
            this.numUpdates = numUpdates;
        }

        @Override
        public void run() throws Exception {
            String[] newNames = new String[this.numUpdates];
            for (int i = 0; i < this.numUpdates; ++i) {
                newNames[i] = CorrectnessTestCase.randomString(ThreadLocalRandom.current());
            }
            this.withRandomFamilies(this.numUpdates, (s, families) -> {
                for (int i = 0; i < this.numUpdates; ++i) {
                    Family f = families[i];
                    if (f == null) continue;
                    f.setName(newNames[i]);
                    s.persist((Object)f);
                }
            }, newNames, null, LockMode.OPTIMISTIC_FORCE_INCREMENT);
        }
    }

    private class ReadFamily
    extends Operation {
        private final boolean evict;

        public ReadFamily(boolean evict) {
            super(false);
            this.evict = evict;
        }

        @Override
        public void run() throws Exception {
            this.withRandomFamily((s, f) -> {
                if (this.evict) {
                    CorrectnessTestCase.this.sessionFactory(threadNode.get()).getCache().evictEntity(Family.class, (Serializable)Integer.valueOf(f.getId()));
                }
            }, Ref.empty(), Ref.empty(), null);
        }
    }

    private class InsertFamily
    extends Operation {
        public InsertFamily(boolean rolledBack) {
            super(rolledBack);
        }

        @Override
        public void run() throws Exception {
            int after;
            Family family = CorrectnessTestCase.createFamily();
            int before = CorrectnessTestCase.this.timestampGenerator.getAndIncrement();
            log.trace((Object)("Started InsertFamily at " + before));
            boolean failure = false;
            try {
                this.withSession(s -> s.persist((Object)family));
                after = CorrectnessTestCase.this.timestampGenerator.getAndIncrement();
            }
            catch (Exception e) {
                try {
                    failure = true;
                    throw e;
                }
                catch (Throwable throwable) {
                    int after2 = CorrectnessTestCase.this.timestampGenerator.getAndIncrement();
                    log.trace((Object)("Finished InsertFamily at " + after2));
                    CorrectnessTestCase.this.familyIds.put(family.getId(), new AtomicInteger(32));
                    LogType type = failure || this.rolledBack ? LogType.WRITE_FAILURE : LogType.WRITE;
                    CorrectnessTestCase.this.getRecordList(CorrectnessTestCase.this.familyNames, family.getId()).add(new Log<String>(before, after2, family.getName(), type, new Log[0]));
                    CorrectnessTestCase.this.getRecordList(CorrectnessTestCase.this.familyMembers, family.getId()).add(new Log<Set>(before, after2, CorrectnessTestCase.this.membersToNames(family.getMembers()), type, new Log[0]));
                    throw throwable;
                }
            }
            log.trace((Object)("Finished InsertFamily at " + after));
            CorrectnessTestCase.this.familyIds.put(family.getId(), new AtomicInteger(32));
            LogType type = failure || this.rolledBack ? LogType.WRITE_FAILURE : LogType.WRITE;
            CorrectnessTestCase.this.getRecordList(CorrectnessTestCase.this.familyNames, family.getId()).add(new Log<String>(before, after, family.getName(), type, new Log[0]));
            CorrectnessTestCase.this.getRecordList(CorrectnessTestCase.this.familyMembers, family.getId()).add(new Log<Set>(before, after, CorrectnessTestCase.this.membersToNames(family.getMembers()), type, new Log[0]));
        }
    }

    private abstract class Operation {
        protected final boolean rolledBack;

        public Operation(boolean rolledBack) {
            this.rolledBack = rolledBack;
        }

        public abstract void run() throws Exception;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void withSession(Consumer<Session> consumer) throws Exception {
            ByRef sessionRef = new ByRef(null);
            try {
                CorrectnessTestCase.this.withTx(() -> this.openSessionAndExecute((ByRef<Session>)sessionRef, consumer), this.rolledBack);
            }
            finally {
                Session s = (Session)sessionRef.get();
                if (s != null) {
                    s.close();
                }
            }
        }

        protected void openSessionAndExecute(ByRef<Session> sessionRef, Consumer<Session> consumer) {
            int node = threadNode.get();
            Session s = CorrectnessTestCase.this.sessionFactory(node).openSession();
            sessionRef.set((Object)s);
            Transaction tx = s.getTransaction();
            tx.begin();
            try {
                consumer.accept(s);
            }
            catch (Exception e) {
                tx.markRollbackOnly();
                throw e;
            }
            finally {
                try {
                    if (!this.rolledBack && tx.getStatus() == TransactionStatus.ACTIVE) {
                        log.trace((Object)"Hibernate commit begin");
                        tx.commit();
                        log.trace((Object)"Hibernate commit end");
                    } else {
                        log.trace((Object)"Hibernate rollback begin");
                        tx.rollback();
                        log.trace((Object)"Hibernate rollback end");
                    }
                }
                catch (Exception e) {
                    log.trace((Object)"Hibernate commit or rollback failed", (Throwable)e);
                    throw e;
                }
            }
        }

        protected void withRandomFamily(BiConsumer<Session, Family> consumer, Ref<String> familyNameUpdate, Ref<Set<String>> familyMembersUpdate, LockMode lockMode) throws Exception {
            int id = CorrectnessTestCase.this.randomFamilyId(ThreadLocalRandom.current());
            int before = CorrectnessTestCase.this.timestampGenerator.getAndIncrement();
            log.tracef("Started %s(%d, %s) at %d", new Object[]{this.getClass().getSimpleName(), id, this.rolledBack, before});
            Log<String> familyNameLog = new Log<String>();
            Log<Set<String>> familyMembersLog = new Log<Set<String>>();
            boolean failure = false;
            try {
                this.withSession(s -> {
                    Family f;
                    Family family = f = lockMode != null ? (Family)s.get(Family.class, (Serializable)Integer.valueOf(id), lockMode) : (Family)s.get(Family.class, (Serializable)Integer.valueOf(id));
                    if (f == null) {
                        familyNameLog.setValue(null);
                        familyMembersLog.setValue(Collections.EMPTY_SET);
                        CorrectnessTestCase.this.familyNotFound(id);
                    } else {
                        familyNameLog.setValue(f.getName());
                        familyMembersLog.setValue(CorrectnessTestCase.this.membersToNames(f.getMembers()));
                        consumer.accept((Session)s, f);
                    }
                });
            }
            catch (Exception e) {
                failure = true;
                throw e;
            }
            finally {
                int after = CorrectnessTestCase.this.timestampGenerator.getAndIncrement();
                this.recordReadWrite(id, before, after, failure, familyNameUpdate, familyMembersUpdate, familyNameLog, familyMembersLog);
            }
        }

        protected void withRandomFamilies(int numFamilies, BiConsumer<Session, Family[]> consumer, String[] familyNameUpdates, Set<String>[] familyMembersUpdates, LockMode lockMode) throws Exception {
            int after;
            int[] ids = new int[numFamilies];
            Log[] familyNameLogs = new Log[numFamilies];
            Log[] familyMembersLogs = new Log[numFamilies];
            for (int i = 0; i < numFamilies; ++i) {
                ids[i] = CorrectnessTestCase.this.randomFamilyId(ThreadLocalRandom.current());
                familyNameLogs[i] = new Log();
                familyMembersLogs[i] = new Log();
            }
            int before = CorrectnessTestCase.this.timestampGenerator.getAndIncrement();
            log.tracef("Started %s(%s) at %d", (Object)this.getClass().getSimpleName(), (Object)Arrays.toString(ids), (Object)before);
            boolean failure = false;
            try {
                this.withSession(s -> {
                    Family[] families = new Family[numFamilies];
                    for (int i = 0; i < numFamilies; ++i) {
                        Family f;
                        families[i] = f = lockMode != null ? (Family)s.get(Family.class, (Serializable)Integer.valueOf(ids[i]), lockMode) : (Family)s.get(Family.class, (Serializable)Integer.valueOf(ids[i]));
                        if (f == null) {
                            familyNameLogs[i].setValue(null);
                            familyMembersLogs[i].setValue(Collections.EMPTY_SET);
                            CorrectnessTestCase.this.familyNotFound(ids[i]);
                            continue;
                        }
                        familyNameLogs[i].setValue(f.getName());
                        familyMembersLogs[i].setValue(CorrectnessTestCase.this.membersToNames(f.getMembers()));
                    }
                    consumer.accept((Session)s, families);
                });
                after = CorrectnessTestCase.this.timestampGenerator.getAndIncrement();
            }
            catch (Exception e) {
                try {
                    failure = true;
                    throw e;
                }
                catch (Throwable throwable) {
                    int after2 = CorrectnessTestCase.this.timestampGenerator.getAndIncrement();
                    for (int i = 0; i < numFamilies; ++i) {
                        this.recordReadWrite(ids[i], before, after2, failure, familyNameUpdates != null ? Ref.of(familyNameUpdates[i]) : Ref.empty(), familyMembersUpdates != null ? Ref.of(familyMembersUpdates[i]) : Ref.empty(), familyNameLogs[i], familyMembersLogs[i]);
                    }
                    throw throwable;
                }
            }
            for (int i = 0; i < numFamilies; ++i) {
                this.recordReadWrite(ids[i], before, after, failure, familyNameUpdates != null ? Ref.of(familyNameUpdates[i]) : Ref.empty(), familyMembersUpdates != null ? Ref.of(familyMembersUpdates[i]) : Ref.empty(), familyNameLogs[i], familyMembersLogs[i]);
            }
        }

        private void recordReadWrite(int id, int before, int after, boolean failure, Ref<String> familyNameUpdate, Ref<Set<String>> familyMembersUpdate, Log<String> familyNameLog, Log<Set<String>> familyMembersLog) {
            LogType readType;
            LogType writeType;
            log.tracef("Finished %s at %d", (Object)this.getClass().getSimpleName(), (Object)after);
            if (failure || this.rolledBack) {
                writeType = LogType.WRITE_FAILURE;
                readType = LogType.READ_FAILURE;
            } else {
                writeType = LogType.WRITE;
                readType = LogType.READ;
            }
            familyNameLog.setType(readType).setTimes(before, after);
            familyMembersLog.setType(readType).setTimes(before, after);
            CorrectnessTestCase.this.getRecordList(CorrectnessTestCase.this.familyNames, id).add(familyNameLog);
            CorrectnessTestCase.this.getRecordList(CorrectnessTestCase.this.familyMembers, id).add(familyMembersLog);
            if (familyNameLog.getValue() != null) {
                if (familyNameUpdate.isSet()) {
                    CorrectnessTestCase.this.getRecordList(CorrectnessTestCase.this.familyNames, id).add(new Log<String>(before, after, familyNameUpdate.get(), writeType, familyNameLog));
                }
                if (familyMembersUpdate.isSet()) {
                    CorrectnessTestCase.this.getRecordList(CorrectnessTestCase.this.familyMembers, id).add(new Log<Set<String>>(before, after, familyMembersUpdate.get(), writeType, familyMembersLog));
                }
            }
        }
    }

    private static class DelayedInvalidators {
        final ConcurrentMap map;
        final Object key;

        public DelayedInvalidators(ConcurrentMap map, Object key) {
            this.map = map;
            this.key = key;
        }

        public Object getPendingPutMap() {
            return this.map.get(this.key);
        }
    }

    public static class FailingInfinispanRegionFactory
    extends TestInfinispanRegionFactory {
        public FailingInfinispanRegionFactory(Properties properties) {
            super(properties);
        }

        @Override
        protected void amendCacheConfiguration(String cacheName, ConfigurationBuilder configurationBuilder) {
            super.amendCacheConfiguration(cacheName, configurationBuilder);
            if (!cacheName.equals("timestamps") && !cacheName.endsWith("pending-puts")) {
                configurationBuilder.customInterceptors().addInterceptor().interceptorClass(FailureInducingInterceptor.class).position(InterceptorConfiguration.Position.FIRST);
                log.trace((Object)("Injecting FailureInducingInterceptor into " + cacheName));
            } else {
                log.trace((Object)("Not injecting into " + cacheName));
            }
        }
    }

    public static class FailureInducingInterceptor
    extends BaseCustomInterceptor {
        protected Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
            if (!(command instanceof CommitCommand) && !(command instanceof RollbackCommand) && ThreadLocalRandom.current().nextInt(100) < 5) {
                throw new InducedException("Simulating failure somewhere");
            }
            return super.handleDefault(ctx, command);
        }
    }

    public static class InducedException
    extends Exception {
        public InducedException(String message) {
            super(message);
        }
    }

    @Ignore
    public static class NonJta
    extends CorrectnessTestCase {
        @Parameterized.Parameters(name="{0}")
        public List<Object[]> getParameters() {
            return Arrays.asList({"read-write, invalidation", CacheMode.INVALIDATION_SYNC, AccessType.READ_WRITE}, {"read-write, replicated", CacheMode.REPL_SYNC, AccessType.READ_WRITE}, {"read-write, distributed", CacheMode.DIST_SYNC, AccessType.READ_WRITE}, {"non-strict, replicated", CacheMode.REPL_SYNC, AccessType.READ_WRITE});
        }

        @Override
        protected void withTx(Runnable runnable, boolean rolledBack) throws Exception {
            runnable.run();
        }

        @Override
        protected void applySettings(StandardServiceRegistryBuilder ssrb) {
            super.applySettings(ssrb);
            ssrb.applySetting("hibernate.transaction.jta.platform", (Object)NoJtaPlatform.class.getName());
            ssrb.applySetting("hibernate.transaction.coordinator_class", (Object)JdbcResourceLocalTransactionCoordinatorBuilderImpl.class.getName());
        }
    }

    @Ignore
    public static class Jta
    extends CorrectnessTestCase {
        private final TransactionManager transactionManager = TestingJtaPlatformImpl.transactionManager();

        @Parameterized.Parameters(name="{0}")
        public List<Object[]> getParameters() {
            return Arrays.asList({"transactional, invalidation", CacheMode.INVALIDATION_SYNC, AccessType.TRANSACTIONAL}, {"read-only, invalidation", CacheMode.INVALIDATION_SYNC, AccessType.READ_ONLY}, {"read-write, invalidation", CacheMode.INVALIDATION_SYNC, AccessType.READ_WRITE}, {"read-write, replicated", CacheMode.REPL_SYNC, AccessType.READ_WRITE}, {"read-write, distributed", CacheMode.DIST_SYNC, AccessType.READ_WRITE}, {"non-strict, replicated", CacheMode.REPL_SYNC, AccessType.NONSTRICT_READ_WRITE});
        }

        @Override
        protected void applySettings(StandardServiceRegistryBuilder ssrb) {
            super.applySettings(ssrb);
            ssrb.applySetting("hibernate.transaction.jta.platform", (Object)TestingJtaPlatformImpl.class.getName());
            ssrb.applySetting("hibernate.connection.provider_class", (Object)JtaAwareConnectionProviderImpl.class.getName());
            ssrb.applySetting("hibernate.transaction.coordinator_class", (Object)JtaTransactionCoordinatorBuilderImpl.class.getName());
        }

        @Override
        protected void withTx(Runnable runnable, boolean rolledBack) throws Exception {
            TransactionManager tm = this.transactionManager;
            tm.begin();
            try {
                runnable.run();
            }
            catch (RuntimeException e) {
                tm.setRollbackOnly();
                throw e;
            }
            finally {
                if (!rolledBack && tm.getStatus() == 0) {
                    log.trace((Object)"TM commit begin");
                    tm.commit();
                    log.trace((Object)"TM commit end");
                } else {
                    log.trace((Object)"TM rollback begin");
                    tm.rollback();
                    log.trace((Object)"TM rollback end");
                }
            }
        }

        @Override
        protected Operation getOperation() {
            if (this.accessType == AccessType.READ_ONLY) {
                ThreadLocalRandom random = ThreadLocalRandom.current();
                int r = random.nextInt(30);
                Operation operation = r == 0 ? new InvalidateCache() : (r < 5 ? new QueryFamilies() : (r < 10 ? new RemoveFamily(r < 12) : new ReadFamily(r < 20)));
                return operation;
            }
            return super.getOperation();
        }
    }
}

