/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan.stress;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.transaction.TransactionManager;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.RootClass;
import org.hibernate.query.Query;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.test.cache.infinispan.stress.entities.Address;
import org.hibernate.test.cache.infinispan.stress.entities.Family;
import org.hibernate.test.cache.infinispan.stress.entities.Person;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.concurrent.ConcurrentHashSet;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class SecondLevelCacheStressTestCase {
    static final int NUM_THREADS = 10;
    static final long WARMUP_TIME = TimeUnit.SECONDS.toNanos(Integer.getInteger("warmup-time", 1) * 5);
    static final long RUNNING_TIME = TimeUnit.SECONDS.toNanos(Integer.getInteger("time", 1) * 60);
    static final boolean PROFILE = Boolean.getBoolean("profile");
    static final boolean ALLOCATION = Boolean.getBoolean("allocation");
    static final int RUN_COUNT_LIMIT = Integer.getInteger("count", 1000);
    static final Random RANDOM = new Random(12345L);
    String provider;
    ConcurrentHashSet<Integer> updatedIds;
    Queue<Integer> removeIds;
    SessionFactory sessionFactory;
    TransactionManager tm;
    volatile int numEntities;

    @Before
    public void beforeClass() {
        this.provider = this.getProvider();
        this.updatedIds = new ConcurrentHashSet();
        this.removeIds = new ConcurrentLinkedQueue<Integer>();
        StandardServiceRegistryBuilder ssrb = new StandardServiceRegistryBuilder().enableAutoClose().applySetting("hibernate.cache.use_second_level_cache", (Object)"true").applySetting("hibernate.cache.use_query_cache", (Object)"true").applySetting("hibernate.connection.driver_class", (Object)"com.mysql.jdbc.Driver").applySetting("hibernate.connection.url", (Object)"jdbc:mysql://localhost:3306/hibernate").applySetting("hibernate.dialect", (Object)"org.hibernate.dialect.MySQL5InnoDBDialect").applySetting("hibernate.connection.username", (Object)"root").applySetting("hibernate.connection.password", (Object)"password").applySetting("hibernate.hbm2ddl.auto", (Object)"create-drop");
        this.applyCacheSettings(ssrb);
        StandardServiceRegistry registry = ssrb.build();
        Metadata metadata = SecondLevelCacheStressTestCase.buildMetadata(registry);
        this.sessionFactory = metadata.buildSessionFactory();
        this.tm = com.arjuna.ats.jta.TransactionManager.transactionManager();
    }

    protected String getProvider() {
        return "infinispan";
    }

    protected void applyCacheSettings(StandardServiceRegistryBuilder ssrb) {
        ssrb.applySetting("hibernate.cache.region.factory_class", (Object)"org.hibernate.cache.infinispan.InfinispanRegionFactory");
        ssrb.applySetting("hibernate.transaction.jta.platform", (Object)"org.hibernate.service.jta.platform.internal.JBossStandAloneJtaPlatform");
        ssrb.applySetting("hibernate.cache.infinispan.cfg", (Object)"stress-local-infinispan.xml");
    }

    @After
    public void afterClass() {
        this.sessionFactory.close();
    }

    @Test
    public void testEntityLifecycle() throws InterruptedException {
        if (!PROFILE) {
            System.out.printf("[provider=%s] Warming up\n", this.provider);
            this.doEntityLifecycle(true);
            this.afterClass();
            this.beforeClass();
        }
        System.out.printf("[provider=%s] Testing...\n", this.provider);
        this.doEntityLifecycle(false);
    }

    void doEntityLifecycle(boolean isWarmup) {
        long runningTimeout = isWarmup ? WARMUP_TIME : RUNNING_TIME;
        TotalStats insertPerf = this.runEntityInsert(runningTimeout);
        this.numEntities = this.countEntities().intValue();
        SecondLevelCacheStressTestCase.printResult(isWarmup, "[provider=%s] Inserts/s %10.2f (%d entities)\n", this.provider, insertPerf.getOpsPerSec("INSERT"), this.numEntities);
        TotalStats updatePerf = this.runEntityUpdate(runningTimeout);
        ArrayList<Integer> updateIdsSeq = new ArrayList<Integer>((Collection<Integer>)this.updatedIds);
        SecondLevelCacheStressTestCase.printResult(isWarmup, "[provider=%s] Updates/s %10.2f (%d updates)\n", this.provider, updatePerf.getOpsPerSec("UPDATE"), updateIdsSeq.size());
        TotalStats findUpdatedPerf = this.runEntityFindUpdated(runningTimeout, updateIdsSeq);
        SecondLevelCacheStressTestCase.printResult(isWarmup, "[provider=%s] Updated finds/s %10.2f\n", this.provider, findUpdatedPerf.getOpsPerSec("FIND_UPDATED"));
        TotalStats findQueryPerf = this.runEntityFindQuery(runningTimeout, isWarmup);
        SecondLevelCacheStressTestCase.printResult(isWarmup, "[provider=%s] Query finds/s %10.2f\n", this.provider, findQueryPerf.getOpsPerSec("FIND_QUERY"));
        TotalStats findRandomPerf = this.runEntityFindRandom(runningTimeout);
        SecondLevelCacheStressTestCase.printResult(isWarmup, "[provider=%s] Random finds/s %10.2f\n", this.provider, findRandomPerf.getOpsPerSec("FIND_RANDOM"));
        ArrayList<Integer> entityIds = new ArrayList<Integer>();
        for (int i = 1; i <= this.numEntities; ++i) {
            entityIds.add(i);
        }
        Collections.shuffle(entityIds);
        this.removeIds.addAll(entityIds);
        TotalStats deletePerf = this.runEntityDelete(runningTimeout);
        SecondLevelCacheStressTestCase.printResult(isWarmup, "[provider=%s] Deletes/s %10.2f\n", this.provider, deletePerf.getOpsPerSec("DELETE"));
    }

    static void printResult(boolean isWarmup, String format, Object ... args) {
        if (!isWarmup) {
            System.out.printf(format, args);
        }
    }

    Long countEntities() {
        try {
            return (Long)TestingUtil.withTx((TransactionManager)this.tm, (Callable)new Callable<Long>(){

                @Override
                public Long call() throws Exception {
                    Session s = SecondLevelCacheStressTestCase.this.sessionFactory.openSession();
                    Query query = s.createQuery("select count(*) from Family");
                    Object result = query.list().get(0);
                    s.close();
                    return (Long)result;
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    TotalStats runEntityInsert(long runningTimeout) {
        return this.runSingleWork(runningTimeout, "insert", this.insertOperation());
    }

    TotalStats runEntityUpdate(long runningTimeout) {
        return this.runSingleWork(runningTimeout, "update", this.updateOperation());
    }

    TotalStats runEntityFindUpdated(long runningTimeout, List<Integer> updatedIdsSeq) {
        return this.runSingleWork(runningTimeout, "find-updated", this.findUpdatedOperation(updatedIdsSeq));
    }

    TotalStats runEntityFindQuery(long runningTimeout, boolean warmup) {
        return this.runSingleWork(runningTimeout, "find-query", this.findQueryOperation(warmup));
    }

    TotalStats runEntityFindRandom(long runningTimeout) {
        return this.runSingleWork(runningTimeout, "find-random", this.findRandomOperation());
    }

    TotalStats runEntityDelete(long runningTimeout) {
        return this.runSingleWork(runningTimeout, "remove", this.deleteOperation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TotalStats runSingleWork(long runningTimeout, final String name, Operation op) {
        TotalStats perf = new TotalStats();
        ExecutorService exec = Executors.newFixedThreadPool(10, new ThreadFactory(){
            volatile int i = 0;

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(new ThreadGroup(name), r, "worker-" + name + "-" + this.i++);
            }
        });
        try {
            ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>(10);
            CyclicBarrier barrier = new CyclicBarrier(11);
            for (int i = 0; i < 10; ++i) {
                futures.add(exec.submit(new WorkerThread(runningTimeout, perf, op, barrier)));
            }
            try {
                barrier.await();
                barrier.await();
                for (Future future : futures) {
                    future.get();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            TotalStats totalStats = perf;
            return totalStats;
        }
        finally {
            exec.shutdown();
        }
    }

    <T> T captureThrowables(Callable<T> task) throws Exception {
        try {
            return task.call();
        }
        catch (Throwable t) {
            t.printStackTrace();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw new RuntimeException(t);
        }
    }

    Operation insertOperation() {
        return new Operation("INSERT"){

            @Override
            boolean call(final int run) throws Exception {
                return SecondLevelCacheStressTestCase.this.captureThrowables(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        return (Boolean)TestingUtil.withTx((TransactionManager)SecondLevelCacheStressTestCase.this.tm, (Callable)new Callable<Boolean>(){

                            @Override
                            public Boolean call() throws Exception {
                                Session s = SecondLevelCacheStressTestCase.this.sessionFactory.openSession();
                                s.getTransaction().begin();
                                String name = "Zamarre\u00f1o-" + run;
                                Family family = new Family(name);
                                s.persist((Object)family);
                                s.getTransaction().commit();
                                s.close();
                                return true;
                            }
                        });
                    }
                });
            }
        };
    }

    Operation updateOperation() {
        return new Operation("UPDATE"){

            @Override
            boolean call(final int run) throws Exception {
                return SecondLevelCacheStressTestCase.this.captureThrowables(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        return (Boolean)TestingUtil.withTx((TransactionManager)SecondLevelCacheStressTestCase.this.tm, (Callable)new Callable<Boolean>(){

                            @Override
                            public Boolean call() throws Exception {
                                Session s = SecondLevelCacheStressTestCase.this.sessionFactory.openSession();
                                s.getTransaction().begin();
                                int id = RANDOM.nextInt(SecondLevelCacheStressTestCase.this.numEntities) + 1;
                                Family family = (Family)s.load(Family.class, (Serializable)Integer.valueOf(id));
                                String newSecondName = "Arrizabalaga-" + run;
                                family.setSecondName(newSecondName);
                                s.getTransaction().commit();
                                s.close();
                                SecondLevelCacheStressTestCase.this.updatedIds.add((Object)id);
                                return true;
                            }
                        });
                    }
                });
            }
        };
    }

    Operation findUpdatedOperation(final List<Integer> updatedIdsSeq) {
        return new Operation("FIND_UPDATED"){

            @Override
            boolean call(int run) throws Exception {
                return SecondLevelCacheStressTestCase.this.captureThrowables(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        Session s = SecondLevelCacheStressTestCase.this.sessionFactory.openSession();
                        int id = (Integer)updatedIdsSeq.get(RANDOM.nextInt(updatedIdsSeq.size()));
                        Family family = (Family)s.load(Family.class, (Serializable)Integer.valueOf(id));
                        String secondName = family.getSecondName();
                        Assert.assertNotNull((Object)secondName);
                        Assert.assertTrue((String)("Second name not expected: " + secondName), (boolean)secondName.startsWith("Arrizabalaga"));
                        s.close();
                        return true;
                    }
                });
            }
        };
    }

    private Operation findQueryOperation(final boolean isWarmup) {
        return new Operation("FIND_QUERY"){

            @Override
            boolean call(int run) throws Exception {
                return SecondLevelCacheStressTestCase.this.captureThrowables(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        Session s = SecondLevelCacheStressTestCase.this.sessionFactory.openSession();
                        Query query = s.createQuery("from Family").setCacheable(true);
                        int maxResults = isWarmup ? 10 : 100;
                        query.setMaxResults(maxResults);
                        List result = query.list();
                        Assert.assertEquals((long)maxResults, (long)result.size());
                        s.close();
                        return true;
                    }
                });
            }
        };
    }

    private Operation findRandomOperation() {
        return new Operation("FIND_RANDOM"){

            @Override
            boolean call(int run) throws Exception {
                return SecondLevelCacheStressTestCase.this.captureThrowables(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        Session s = SecondLevelCacheStressTestCase.this.sessionFactory.openSession();
                        int id = RANDOM.nextInt(SecondLevelCacheStressTestCase.this.numEntities) + 1;
                        Family family = (Family)s.load(Family.class, (Serializable)Integer.valueOf(id));
                        String familyName = family.getName();
                        Assert.assertTrue((String)("Unexpected family: " + familyName), (boolean)familyName.startsWith("Zamarre"));
                        s.close();
                        return true;
                    }
                });
            }
        };
    }

    private Operation deleteOperation() {
        return new Operation("DELETE"){

            @Override
            boolean call(int run) throws Exception {
                return SecondLevelCacheStressTestCase.this.captureThrowables(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        return (Boolean)TestingUtil.withTx((TransactionManager)SecondLevelCacheStressTestCase.this.tm, (Callable)new Callable<Boolean>(){

                            @Override
                            public Boolean call() throws Exception {
                                Session s = SecondLevelCacheStressTestCase.this.sessionFactory.openSession();
                                s.getTransaction().begin();
                                int id = SecondLevelCacheStressTestCase.this.removeIds.poll();
                                Family family = (Family)s.load(Family.class, (Serializable)Integer.valueOf(id));
                                String familyName = family.getName();
                                Assert.assertTrue((String)("Unexpected family: " + familyName), (boolean)familyName.startsWith("Zamarre"));
                                s.delete((Object)family);
                                s.getTransaction().commit();
                                s.close();
                                return true;
                            }
                        });
                    }
                });
            }
        };
    }

    public static Class[] getAnnotatedClasses() {
        return new Class[]{Family.class, Person.class, Address.class};
    }

    private static Metadata buildMetadata(StandardServiceRegistry registry) {
        String cacheStrategy = "transactional";
        MetadataSources metadataSources = new MetadataSources((ServiceRegistry)registry);
        for (Class entityClass : SecondLevelCacheStressTestCase.getAnnotatedClasses()) {
            metadataSources.addAnnotatedClass(entityClass);
        }
        Metadata metadata = metadataSources.buildMetadata();
        for (PersistentClass entityBinding : metadata.getEntityBindings()) {
            if (entityBinding.isInherited()) continue;
            ((RootClass)entityBinding).setCacheConcurrencyStrategy("transactional");
        }
        for (org.hibernate.mapping.Collection collectionBinding : metadata.getCollectionBindings()) {
            collectionBinding.setCacheConcurrencyStrategy("transactional");
        }
        return metadata;
    }

    private static class OpStats {
        public final String opName;
        public final int threadCount;
        public final long opCount;
        public final long runningTime;
        public final long missCount;

        private OpStats(String opName, long opCount, long runningTime, long missCount) {
            this.opName = opName;
            this.threadCount = 1;
            this.opCount = opCount;
            this.runningTime = runningTime;
            this.missCount = missCount;
        }

        private OpStats(OpStats base, long opCount, long runningTime, long missCount) {
            this.opName = base.opName;
            this.threadCount = base.threadCount + 1;
            this.opCount = base.opCount + opCount;
            this.runningTime = base.runningTime + runningTime;
            this.missCount = base.missCount + missCount;
        }
    }

    private static class TotalStats {
        private ConcurrentHashMap<String, OpStats> statsMap = new ConcurrentHashMap();

        private TotalStats() {
        }

        public void addStats(String opName, long opCount, long runningTime, long missCount) {
            boolean replaced;
            OpStats s = new OpStats(opName, opCount, runningTime, missCount);
            OpStats old = this.statsMap.putIfAbsent(opName, s);
            boolean bl = replaced = old == null;
            while (!replaced) {
                old = this.statsMap.get(opName);
                s = new OpStats(old, opCount, runningTime, missCount);
                replaced = this.statsMap.replace(opName, old, s);
            }
        }

        public double getOpsPerSec(String opName) {
            OpStats s = this.statsMap.get(opName);
            if (s == null) {
                return 0.0;
            }
            return (double)s.opCount * 1.0E9 / (double)s.runningTime * (double)s.threadCount;
        }

        public double getTotalOpsPerSec() {
            long totalOpCount = 0L;
            long totalRunningTime = 0L;
            long totalThreadCount = 0L;
            for (Map.Entry<String, OpStats> e : this.statsMap.entrySet()) {
                OpStats s = e.getValue();
                totalOpCount += s.opCount;
                totalRunningTime += s.runningTime;
                totalThreadCount += (long)s.threadCount;
            }
            return (double)totalOpCount * 1.0E9 / (double)totalRunningTime * (double)totalThreadCount;
        }

        public double getHitRatio(String opName) {
            OpStats s = this.statsMap.get(opName);
            if (s == null) {
                return 0.0;
            }
            return 1.0 - 1.0 * (double)s.missCount / (double)s.opCount;
        }

        public double getTotalHitRatio() {
            long totalOpCount = 0L;
            long totalMissCount = 0L;
            for (Map.Entry<String, OpStats> e : this.statsMap.entrySet()) {
                OpStats s = e.getValue();
                totalOpCount += s.opCount;
                totalMissCount += s.missCount;
            }
            return 1.0 - 1.0 * (double)totalMissCount / (double)totalOpCount;
        }
    }

    private class WorkerThread
    implements Callable<Void> {
        private final long runningTimeout;
        private final TotalStats perf;
        private final Operation op;
        private final CyclicBarrier barrier;

        public WorkerThread(long runningTimeout, TotalStats perf, Operation op, CyclicBarrier barrier) {
            this.runningTimeout = runningTimeout;
            this.perf = perf;
            this.op = op;
            this.barrier = barrier;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            this.barrier.await();
            try {
                long startNanos = System.nanoTime();
                long endNanos = startNanos + this.runningTimeout;
                int runs = 0;
                long missCount = 0L;
                while (this.callOperation(endNanos, runs)) {
                    boolean hit = this.op.call(runs);
                    if (!hit) {
                        ++missCount;
                    }
                    ++runs;
                }
                this.perf.addStats(this.op.name, runs, System.nanoTime() - startNanos, missCount);
            }
            finally {
                this.barrier.await();
            }
            return null;
        }

        private boolean callOperation(long endNanos, int runs) {
            if (ALLOCATION) {
                return runs < RUN_COUNT_LIMIT;
            }
            return (runs & 0x400) != 0 || System.nanoTime() < endNanos;
        }
    }

    private static abstract class Operation {
        final String name;

        Operation(String name) {
            this.name = name;
        }

        abstract boolean call(int var1) throws Exception;
    }
}

