/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan.stress.entities;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import org.hibernate.test.cache.infinispan.stress.entities.Person;

@Entity
public final class Address {
    @Id
    @GeneratedValue
    private int id;
    private int streetNumber;
    private String streetName;
    private String cityName;
    private String countryName;
    private String zipCode;
    @OneToMany
    private Set<Person> inhabitants;
    private int version;

    public Address(int streetNumber, String streetName, String cityName, String countryName) {
        this.streetNumber = streetNumber;
        this.streetName = streetName;
        this.cityName = cityName;
        this.countryName = countryName;
        this.zipCode = null;
        this.inhabitants = new HashSet<Person>();
        this.id = 0;
        this.version = 0;
    }

    protected Address() {
        this.streetNumber = 0;
        this.streetName = null;
        this.cityName = null;
        this.countryName = null;
        this.zipCode = null;
        this.inhabitants = new HashSet<Person>();
        this.id = 0;
        this.version = 0;
    }

    public int getStreetNumber() {
        return this.streetNumber;
    }

    public String getStreetName() {
        return this.streetName;
    }

    public String getCityName() {
        return this.cityName;
    }

    public String getCountryName() {
        return this.countryName;
    }

    public String getZipCode() {
        return this.zipCode;
    }

    public void setZipCode(String zipCode) {
        this.zipCode = zipCode;
    }

    public Set<Person> getInhabitants() {
        return this.inhabitants;
    }

    public boolean addInhabitant(Person inhabitant) {
        boolean done = false;
        if (this.inhabitants.add(inhabitant)) {
            inhabitant.setAddress(this);
            done = true;
        }
        return done;
    }

    public boolean remInhabitant(Person inhabitant) {
        boolean done = false;
        if (this.inhabitants.remove(inhabitant)) {
            inhabitant.setAddress(null);
            done = true;
        }
        return done;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getVersion() {
        return this.version;
    }

    protected void removeAllInhabitants() {
        for (Person p : this.inhabitants) {
            p.setAddress(null);
        }
    }

    protected void setStreetNumber(int streetNumber) {
        this.streetNumber = streetNumber;
    }

    protected void setStreetName(String streetName) {
        this.streetName = streetName;
    }

    protected void setCityName(String cityName) {
        this.cityName = cityName;
    }

    protected void setCountryName(String countryName) {
        this.countryName = countryName;
    }

    protected void setInhabitants(Set<Person> inhabitants) {
        this.inhabitants = inhabitants == null ? new HashSet<Person>() : inhabitants;
    }

    protected void setVersion(Integer version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Address address = (Address)o;
        if (this.id != address.id) {
            return false;
        }
        if (this.streetNumber != address.streetNumber) {
            return false;
        }
        if (this.version != address.version) {
            return false;
        }
        if (this.cityName != null ? !this.cityName.equals(address.cityName) : address.cityName != null) {
            return false;
        }
        if (this.countryName != null ? !this.countryName.equals(address.countryName) : address.countryName != null) {
            return false;
        }
        if (this.streetName != null ? !this.streetName.equals(address.streetName) : address.streetName != null) {
            return false;
        }
        return !(this.zipCode != null ? !this.zipCode.equals(address.zipCode) : address.zipCode != null);
    }

    public int hashCode() {
        int result = this.streetNumber;
        result = 31 * result + (this.streetName != null ? this.streetName.hashCode() : 0);
        result = 31 * result + (this.cityName != null ? this.cityName.hashCode() : 0);
        result = 31 * result + (this.countryName != null ? this.countryName.hashCode() : 0);
        result = 31 * result + (this.zipCode != null ? this.zipCode.hashCode() : 0);
        result = 31 * result + this.id;
        result = 31 * result + this.version;
        return result;
    }

    public String toString() {
        return "Address{cityName='" + this.cityName + '\'' + ", streetNumber=" + this.streetNumber + ", streetName='" + this.streetName + '\'' + ", countryName='" + this.countryName + '\'' + ", zipCode='" + this.zipCode + '\'' + ", inhabitants=" + this.inhabitants + ", id=" + this.id + ", version=" + this.version + '}';
    }
}

