/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan.tm;

import java.io.Serializable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.transaction.UserTransaction;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cache.infinispan.util.InfinispanMessageLogger;
import org.hibernate.engine.transaction.jta.platform.internal.JBossStandAloneJtaPlatform;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.RootClass;
import org.hibernate.resource.transaction.backend.jta.internal.JtaTransactionCoordinatorBuilderImpl;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.stat.Statistics;
import org.hibernate.test.cache.infinispan.functional.entities.Item;
import org.hibernate.test.cache.infinispan.util.InfinispanTestingSetup;
import org.hibernate.test.cache.infinispan.util.TestInfinispanRegionFactory;
import org.hibernate.testing.ServiceRegistryBuilder;
import org.hibernate.testing.jta.JtaAwareConnectionProviderImpl;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.transaction.lookup.JBossStandaloneJTAManagerLookup;
import org.jboss.util.naming.NonSerializableFactory;
import org.jnp.interfaces.Naming;
import org.jnp.interfaces.NamingContext;
import org.jnp.server.Main;
import org.jnp.server.NamingServer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class JBossStandaloneJtaExampleTest {
    private static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(JBossStandaloneJtaExampleTest.class);
    private static final JBossStandaloneJTAManagerLookup lookup = new JBossStandaloneJTAManagerLookup();
    Context ctx;
    Main jndiServer;
    private ServiceRegistry serviceRegistry;
    @Rule
    public final InfinispanTestingSetup infinispanTestIdentifier = new InfinispanTestingSetup();

    @Before
    public void setUp() throws Exception {
        this.jndiServer = this.startJndiServer();
        this.ctx = this.createJndiContext();
        lookup.init(new ConfigurationBuilder().build());
        this.bindTransactionManager();
        this.bindUserTransaction();
    }

    @After
    public void tearDown() throws Exception {
        try {
            this.unbind("UserTransaction", this.ctx);
            this.unbind("java:/TransactionManager", this.ctx);
            this.ctx.close();
            this.jndiServer.stop();
        }
        finally {
            if (this.serviceRegistry != null) {
                ServiceRegistryBuilder.destroy((ServiceRegistry)this.serviceRegistry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPersistAndLoadUnderJta() throws Exception {
        try (SessionFactory sessionFactory = this.buildSessionFactory();){
            Item item;
            Session session;
            UserTransaction ut = (UserTransaction)this.ctx.lookup("UserTransaction");
            ut.begin();
            try {
                session = sessionFactory.openSession();
                session.getTransaction().begin();
                item = new Item("anItem", "An item owned by someone");
                session.persist((Object)item);
                session.getTransaction().commit();
                session.close();
            }
            catch (Exception e) {
                ut.setRollbackOnly();
                throw e;
            }
            finally {
                if (ut.getStatus() == 0) {
                    ut.commit();
                } else {
                    ut.rollback();
                }
            }
            ut = (UserTransaction)this.ctx.lookup("UserTransaction");
            ut.begin();
            try {
                session = sessionFactory.openSession();
                session.getTransaction().begin();
                Item found = (Item)session.load(Item.class, (Serializable)item.getId());
                Statistics stats = session.getSessionFactory().getStatistics();
                log.info((Object)stats.toString());
                Assert.assertEquals((Object)item.getDescription(), (Object)found.getDescription());
                Assert.assertEquals((long)0L, (long)stats.getSecondLevelCacheMissCount());
                Assert.assertEquals((long)1L, (long)stats.getSecondLevelCacheHitCount());
                session.delete((Object)found);
                session.getTransaction().commit();
                session.close();
            }
            catch (Exception e) {
                ut.setRollbackOnly();
                throw e;
            }
            finally {
                if (ut.getStatus() == 0) {
                    ut.commit();
                } else {
                    ut.rollback();
                }
            }
            ut = (UserTransaction)this.ctx.lookup("UserTransaction");
            ut.begin();
            try {
                session = sessionFactory.openSession();
                session.getTransaction().begin();
                Assert.assertNull((Object)session.get(Item.class, (Serializable)item.getId()));
                session.getTransaction().commit();
                session.close();
            }
            catch (Exception e) {
                ut.setRollbackOnly();
                throw e;
            }
            finally {
                if (ut.getStatus() == 0) {
                    ut.commit();
                } else {
                    ut.rollback();
                }
            }
        }
    }

    private Main startJndiServer() throws Exception {
        NamingServer namingServer = new NamingServer();
        NamingContext.setLocal((Naming)namingServer);
        Main namingMain = new Main();
        namingMain.setInstallGlobalService(true);
        namingMain.setPort(-1);
        namingMain.start();
        return namingMain;
    }

    private Context createJndiContext() throws Exception {
        Properties props = new Properties();
        props.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
        props.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
        return new InitialContext(props);
    }

    private void bindTransactionManager() throws Exception {
        this.bind("java:/TransactionManager", lookup.getTransactionManager(), lookup.getTransactionManager().getClass(), this.ctx);
    }

    private void bindUserTransaction() throws Exception {
        this.bind("UserTransaction", lookup.getUserTransaction(), lookup.getUserTransaction().getClass(), this.ctx);
    }

    private void bind(String jndiName, Object who, Class classType, Context ctx) throws Exception {
        NonSerializableFactory.bind((String)jndiName, (Object)who);
        Name n = ctx.getNameParser("").parse(jndiName);
        while (n.size() > 1) {
            String ctxName = n.get(0);
            try {
                ctx = (Context)ctx.lookup(ctxName);
            }
            catch (NameNotFoundException e) {
                System.out.println("Creating subcontext:" + ctxName);
                ctx = ctx.createSubcontext(ctxName);
            }
            n = n.getSuffix(1);
        }
        StringRefAddr addr = new StringRefAddr("nns", jndiName);
        Reference ref = new Reference(classType.getName(), addr, NonSerializableFactory.class.getName(), null);
        ctx.rebind(n.get(0), (Object)ref);
    }

    private void unbind(String jndiName, Context ctx) throws Exception {
        NonSerializableFactory.unbind((String)jndiName);
        ctx.unbind(jndiName);
    }

    private SessionFactory buildSessionFactory() {
        StandardServiceRegistryBuilder ssrb = new StandardServiceRegistryBuilder().applySetting("hibernate.dialect", (Object)"HSQL").applySetting("hibernate.hbm2ddl.auto", (Object)"create-drop").applySetting("hibernate.connection.provider_class", (Object)JtaAwareConnectionProviderImpl.class.getName()).applySetting("hibernate.jndi.class", (Object)"org.jnp.interfaces.NamingContextFactory").applySetting("hibernate.transaction.coordinator_class", (Object)JtaTransactionCoordinatorBuilderImpl.class.getName()).applySetting("hibernate.current_session_context_class", (Object)"jta").applySetting("hibernate.connection.release_mode", (Object)"auto").applySetting("hibernate.cache.use_second_level_cache", (Object)"true").applySetting("hibernate.cache.use_query_cache", (Object)"true").applySetting("hibernate.transaction.jta.platform", (Object)new JBossStandAloneJtaPlatform()).applySetting("hibernate.cache.region.factory_class", (Object)TestInfinispanRegionFactory.class.getName());
        StandardServiceRegistry serviceRegistry = ssrb.build();
        MetadataSources metadataSources = new MetadataSources((ServiceRegistry)serviceRegistry);
        metadataSources.addResource("org/hibernate/test/cache/infinispan/functional/entities/Item.hbm.xml");
        Metadata metadata = metadataSources.buildMetadata();
        for (PersistentClass entityBinding : metadata.getEntityBindings()) {
            if (!(entityBinding instanceof RootClass)) continue;
            ((RootClass)entityBinding).setCacheConcurrencyStrategy("transactional");
        }
        for (Collection collectionBinding : metadata.getCollectionBindings()) {
            collectionBinding.setCacheConcurrencyStrategy("transactional");
        }
        return metadata.buildSessionFactory();
    }
}

