/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan.tm;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.service.UnknownUnwrapTypeException;
import org.hibernate.service.spi.Stoppable;
import org.hibernate.test.cache.infinispan.tm.XaTransactionImpl;
import org.hibernate.test.cache.infinispan.tm.XaTransactionManagerImpl;
import org.hibernate.testing.env.ConnectionProviderBuilder;

public class XaConnectionProvider
implements ConnectionProvider {
    private static final ConnectionProvider DEFAULT_CONNECTION_PROVIDER = ConnectionProviderBuilder.buildConnectionProvider();
    private final ConnectionProvider actualConnectionProvider;
    private boolean isTransactional;

    public XaConnectionProvider() {
        this(DEFAULT_CONNECTION_PROVIDER);
    }

    public XaConnectionProvider(ConnectionProvider connectionProvider) {
        this.actualConnectionProvider = connectionProvider;
    }

    public ConnectionProvider getActualConnectionProvider() {
        return this.actualConnectionProvider;
    }

    public boolean isUnwrappableAs(Class unwrapType) {
        return XaConnectionProvider.class.isAssignableFrom(unwrapType) || ConnectionProvider.class.equals((Object)unwrapType) || this.actualConnectionProvider.getClass().isAssignableFrom(unwrapType);
    }

    public <T> T unwrap(Class<T> unwrapType) {
        if (XaConnectionProvider.class.isAssignableFrom(unwrapType)) {
            return (T)this;
        }
        if (ConnectionProvider.class.isAssignableFrom(unwrapType) || this.actualConnectionProvider.getClass().isAssignableFrom(unwrapType)) {
            return (T)this.getActualConnectionProvider();
        }
        throw new UnknownUnwrapTypeException(unwrapType);
    }

    public void configure(Properties props) throws HibernateException {
    }

    public Connection getConnection() throws SQLException {
        XaTransactionImpl currentTransaction = XaTransactionManagerImpl.getInstance().getCurrentTransaction();
        if (currentTransaction == null) {
            this.isTransactional = false;
            return this.actualConnectionProvider.getConnection();
        }
        this.isTransactional = true;
        Connection connection = currentTransaction.getEnlistedConnection();
        if (connection == null) {
            connection = this.actualConnectionProvider.getConnection();
            currentTransaction.enlistConnection(connection);
        }
        return connection;
    }

    public void closeConnection(Connection conn) throws SQLException {
        if (!this.isTransactional) {
            conn.close();
        }
    }

    public void close() throws HibernateException {
        if (this.actualConnectionProvider instanceof Stoppable) {
            ((Stoppable)this.actualConnectionProvider).stop();
        }
    }

    public boolean supportsAggressiveRelease() {
        return true;
    }
}

