/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan.util;

import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.hibernate.HibernateException;
import org.hibernate.Transaction;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.transaction.spi.IsolationDelegate;
import org.hibernate.engine.transaction.spi.TransactionObserver;
import org.hibernate.resource.transaction.backend.jta.internal.JtaIsolationDelegate;
import org.hibernate.resource.transaction.backend.jta.internal.StatusTranslator;
import org.hibernate.resource.transaction.spi.SynchronizationRegistry;
import org.hibernate.resource.transaction.spi.TransactionCoordinator;
import org.hibernate.resource.transaction.spi.TransactionCoordinatorBuilder;
import org.hibernate.resource.transaction.spi.TransactionStatus;
import org.infinispan.transaction.tm.BatchModeTransactionManager;
import org.infinispan.transaction.tm.DummyTransaction;
import org.mockito.Mockito;

public class BatchModeTransactionCoordinator
implements TransactionCoordinator {
    private BatchModeTransactionManager tm = BatchModeTransactionManager.getInstance();
    private TransactionCoordinator.TransactionDriver transactionDriver = new TransactionCoordinator.TransactionDriver(){

        public void begin() {
            try {
                BatchModeTransactionCoordinator.this.tm.begin();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void commit() {
            try {
                BatchModeTransactionCoordinator.this.tm.commit();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void rollback() {
            try {
                BatchModeTransactionCoordinator.this.tm.rollback();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public TransactionStatus getStatus() {
            try {
                DummyTransaction transaction = BatchModeTransactionCoordinator.this.tm.getTransaction();
                return transaction == null ? TransactionStatus.NOT_ACTIVE : StatusTranslator.translate((int)transaction.getStatus());
            }
            catch (SystemException e) {
                throw new RuntimeException(e);
            }
        }

        public void markRollbackOnly() {
            throw new UnsupportedOperationException();
        }
    };

    public void explicitJoin() {
    }

    public boolean isJoined() {
        return true;
    }

    public void pulse() {
    }

    public TransactionCoordinator.TransactionDriver getTransactionDriverControl() {
        return this.transactionDriver;
    }

    public SynchronizationRegistry getLocalSynchronizations() {
        return new SynchronizationRegistry(){

            public void registerSynchronization(Synchronization synchronization) {
                try {
                    BatchModeTransactionManager.getInstance().getTransaction().registerSynchronization(synchronization);
                }
                catch (RollbackException e) {
                    throw new RuntimeException(e);
                }
                catch (SystemException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public boolean isActive() {
        try {
            return BatchModeTransactionManager.getInstance().getStatus() == 0;
        }
        catch (SystemException e) {
            return false;
        }
    }

    public IsolationDelegate createIsolationDelegate() {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        JdbcConnectionAccess jdbcConnectionAccess = (JdbcConnectionAccess)Mockito.mock(JdbcConnectionAccess.class);
        try {
            Mockito.when((Object)jdbcConnectionAccess.obtainConnection()).thenReturn((Object)connection);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return new JtaIsolationDelegate(jdbcConnectionAccess, (SqlExceptionHelper)Mockito.mock(SqlExceptionHelper.class), (TransactionManager)this.tm);
    }

    public void addObserver(TransactionObserver observer) {
        throw new UnsupportedOperationException();
    }

    public void removeObserver(TransactionObserver observer) {
        throw new UnsupportedOperationException();
    }

    public TransactionCoordinatorBuilder getTransactionCoordinatorBuilder() {
        throw new UnsupportedOperationException();
    }

    public void setTimeOut(int seconds) {
        throw new UnsupportedOperationException();
    }

    public int getTimeOut() {
        throw new UnsupportedOperationException();
    }

    public Transaction newTransaction() {
        return new BatchModeTransaction();
    }

    public class BatchModeTransaction
    implements Transaction {
        public void begin() {
        }

        public void commit() {
            BatchModeTransactionCoordinator.this.transactionDriver.commit();
        }

        public void rollback() {
            BatchModeTransactionCoordinator.this.transactionDriver.rollback();
        }

        public void setRollbackOnly() {
        }

        public boolean getRollbackOnly() {
            return false;
        }

        public boolean isActive() {
            return false;
        }

        public TransactionStatus getStatus() {
            return BatchModeTransactionCoordinator.this.transactionDriver.getStatus();
        }

        public void registerSynchronization(Synchronization synchronization) throws HibernateException {
            BatchModeTransactionCoordinator.this.getLocalSynchronizations().registerSynchronization(synchronization);
        }

        public void setTimeout(int seconds) {
        }

        public int getTimeout() {
            return 0;
        }

        public void markRollbackOnly() {
            BatchModeTransactionCoordinator.this.transactionDriver.markRollbackOnly();
        }
    }
}

