/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan.util;

import java.util.Collections;
import java.util.UUID;
import java.util.function.Supplier;
import org.hibernate.cache.infinispan.util.BeginInvalidationCommand;
import org.hibernate.cache.infinispan.util.CacheCommandInitializer;
import org.hibernate.cache.infinispan.util.EndInvalidationCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.distribution.TestAddress;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.jgroups.util.Util;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class CacheCommandsInitializerTest {
    private static CacheCommandInitializer initializer = new CacheCommandInitializer();

    @BeforeClass
    public static void setUp() {
        ClusteringDependentLogic cdl = (ClusteringDependentLogic)Mockito.mock(ClusteringDependentLogic.class);
        Mockito.when((Object)cdl.getAddress()).thenReturn((Object)new TestAddress(0));
        initializer.injectDependencies(null, null, cdl);
    }

    @Test
    public void testBeginInvalidationCommand1() {
        BeginInvalidationCommand command = initializer.buildBeginInvalidationCommand(Collections.EMPTY_SET, new Object[0], (Object)UUID.randomUUID());
        this.checkParameters(command, () -> new BeginInvalidationCommand());
    }

    @Test
    public void testBeginInvalidationCommand2() {
        BeginInvalidationCommand command = initializer.buildBeginInvalidationCommand(Collections.EMPTY_SET, new Object[]{1}, (Object)UUID.randomUUID());
        this.checkParameters(command, () -> new BeginInvalidationCommand());
    }

    @Test
    public void testBeginInvalidationCommand3() {
        BeginInvalidationCommand command = initializer.buildBeginInvalidationCommand(Collections.EMPTY_SET, new Object[]{2, 3}, (Object)UUID.randomUUID());
        this.checkParameters(command, () -> new BeginInvalidationCommand());
    }

    @Test
    public void testEndInvalidationCommmand() {
        EndInvalidationCommand command = initializer.buildEndInvalidationCommand("foo", new Object[]{2, 3}, (Object)UUID.randomUUID());
        this.checkParameters(command, () -> new EndInvalidationCommand("foo"));
    }

    protected <T extends ReplicableCommand> void checkParameters(T command, Supplier<T> commandSupplier) {
        Object[] parameters = command.getParameters();
        ReplicableCommand newCommand = (ReplicableCommand)commandSupplier.get();
        newCommand.setParameters((int)command.getCommandId(), parameters);
        Util.assertEquals(command, (Object)newCommand);
        Assert.assertArrayEquals((Object[])parameters, (Object[])newCommand.getParameters());
    }
}

