/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan.util;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.hibernate.boot.internal.SessionFactoryBuilderImpl;
import org.hibernate.boot.internal.SessionFactoryOptionsImpl;
import org.hibernate.boot.internal.SessionFactoryOptionsState;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.infinispan.InfinispanRegionFactory;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.internal.util.compare.EqualsHelper;
import org.hibernate.resource.transaction.backend.jdbc.internal.JdbcResourceLocalTransactionCoordinatorBuilderImpl;
import org.hibernate.resource.transaction.backend.jta.internal.JtaTransactionCoordinatorBuilderImpl;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.test.cache.infinispan.util.CacheTestSupport;
import org.hibernate.test.cache.infinispan.util.TestInfinispanRegionFactory;
import org.hibernate.testing.boot.ServiceRegistryTestingImpl;

public class CacheTestUtil {
    public static Map buildBaselineSettings(String regionPrefix, Class regionFactory, boolean use2ndLevel, boolean useQueries, Class<? extends JtaPlatform> jtaPlatform) {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("hibernate.generate_statistics", "true");
        settings.put("hibernate.cache.use_structured_entries", "true");
        if (jtaPlatform == null) {
            settings.put("hibernate.transaction.coordinator_class", JdbcResourceLocalTransactionCoordinatorBuilderImpl.class.getName());
        } else {
            settings.put("hibernate.transaction.coordinator_class", JtaTransactionCoordinatorBuilderImpl.class.getName());
            settings.put("hibernate.transaction.jta.platform", jtaPlatform);
        }
        settings.put("hibernate.cache.region.factory_class", regionFactory.getName());
        settings.put("hibernate.cache.region_prefix", regionPrefix);
        settings.put("hibernate.cache.use_second_level_cache", String.valueOf(use2ndLevel));
        settings.put("hibernate.cache.use_query_cache", String.valueOf(useQueries));
        return settings;
    }

    public static StandardServiceRegistryBuilder buildBaselineStandardServiceRegistryBuilder(String regionPrefix, Class regionFactory, boolean use2ndLevel, boolean useQueries, Class<? extends JtaPlatform> jtaPlatform) {
        StandardServiceRegistryBuilder ssrb = new StandardServiceRegistryBuilder();
        ssrb.applySettings(CacheTestUtil.buildBaselineSettings(regionPrefix, regionFactory, use2ndLevel, useQueries, jtaPlatform));
        return ssrb;
    }

    public static StandardServiceRegistryBuilder buildCustomQueryCacheStandardServiceRegistryBuilder(String regionPrefix, String queryCacheName, Class<? extends JtaPlatform> jtaPlatform) {
        StandardServiceRegistryBuilder ssrb = CacheTestUtil.buildBaselineStandardServiceRegistryBuilder(regionPrefix, InfinispanRegionFactory.class, true, true, jtaPlatform);
        ssrb.applySetting(InfinispanRegionFactory.QUERY_CACHE_RESOURCE_PROP, (Object)queryCacheName);
        return ssrb;
    }

    public static InfinispanRegionFactory createRegionFactory(Class<? extends InfinispanRegionFactory> clazz, Properties properties) {
        try {
            try {
                Constructor<? extends InfinispanRegionFactory> constructor = clazz.getConstructor(Properties.class);
                return constructor.newInstance(properties);
            }
            catch (NoSuchMethodException e) {
                return clazz.newInstance();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static InfinispanRegionFactory startRegionFactory(ServiceRegistry serviceRegistry) {
        try {
            TestInfinispanRegionFactory regionFactory;
            ConfigurationService cfgService = (ConfigurationService)serviceRegistry.getService(ConfigurationService.class);
            Properties properties = CacheTestUtil.toProperties(cfgService.getSettings());
            String factoryType = (String)cfgService.getSetting("hibernate.cache.region.factory_class", StandardConverters.STRING);
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(factoryType);
            if (clazz == InfinispanRegionFactory.class) {
                regionFactory = new TestInfinispanRegionFactory(properties);
            } else if (InfinispanRegionFactory.class.isAssignableFrom(clazz)) {
                regionFactory = CacheTestUtil.createRegionFactory(clazz, properties);
            } else {
                throw new IllegalArgumentException(clazz + " is not InfinispanRegionFactory");
            }
            SessionFactoryOptionsImpl sessionFactoryOptions = new SessionFactoryOptionsImpl((SessionFactoryOptionsState)new SessionFactoryBuilderImpl.SessionFactoryOptionsStateStandardImpl((StandardServiceRegistry)serviceRegistry));
            regionFactory.start((SessionFactoryOptions)sessionFactoryOptions, properties);
            return regionFactory;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static InfinispanRegionFactory startRegionFactory(ServiceRegistry serviceRegistry, CacheTestSupport testSupport) {
        InfinispanRegionFactory factory = CacheTestUtil.startRegionFactory(serviceRegistry);
        testSupport.registerFactory((RegionFactory)factory);
        return factory;
    }

    public static void stopRegionFactory(InfinispanRegionFactory factory, CacheTestSupport testSupport) {
        testSupport.unregisterFactory((RegionFactory)factory);
        factory.stop();
    }

    public static Properties toProperties(Map map) {
        if (map == null) {
            return null;
        }
        if (map instanceof Properties) {
            return (Properties)map;
        }
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)map);
        return properties;
    }

    public static <T> void assertEqualsEventually(T expected, Callable<T> callable) throws Exception {
        CacheTestUtil.assertEqualsEventually(expected, callable, -1L, TimeUnit.SECONDS);
    }

    public static <T> void assertEqualsEventually(T expected, Callable<T> callable, long timeout, TimeUnit timeUnit) throws Exception {
        long deadline;
        long l = deadline = timeout <= 0L ? Long.MAX_VALUE : System.currentTimeMillis() + timeUnit.toMillis(timeout);
        while (true) {
            T value;
            if (EqualsHelper.equals(value = callable.call(), expected)) {
                return;
            }
            long now = System.currentTimeMillis();
            if (now >= deadline) break;
            Thread.sleep(Math.min(100L, deadline - now));
        }
        throw new TimeoutException();
    }

    public static SessionFactoryOptions sfOptionsForStart() {
        return new SessionFactoryOptionsImpl((SessionFactoryOptionsState)new SessionFactoryBuilderImpl.SessionFactoryOptionsStateStandardImpl((StandardServiceRegistry)ServiceRegistryTestingImpl.forUnitTesting()));
    }

    private CacheTestUtil() {
    }
}

