/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan.util;

import java.util.Map;
import java.util.Properties;
import org.hibernate.cache.infinispan.InfinispanRegionFactory;
import org.infinispan.commons.executors.CachedThreadPoolExecutorFactory;
import org.infinispan.commons.executors.ThreadPoolExecutorFactory;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.TransportConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.fwk.TestResourceTracker;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.TimeService;

public class TestInfinispanRegionFactory
extends InfinispanRegionFactory {
    protected static final String PREFIX = TestInfinispanRegionFactory.class.getName() + ".";
    public static final String TRANSACTIONAL = PREFIX + "transactional";
    public static final String CACHE_MODE = PREFIX + "cacheMode";
    public static final String TIME_SERVICE = PREFIX + "timeService";
    public static final String PENDING_PUTS_SIMPLE = PREFIX + "pendingPuts.simple";
    private final boolean transactional;
    private final CacheMode cacheMode;
    private final TimeService timeService;
    private final boolean pendingPutsSimple;

    public TestInfinispanRegionFactory(Properties properties) {
        this.transactional = (Boolean)properties.getOrDefault((Object)TRANSACTIONAL, (Object)false);
        this.cacheMode = (CacheMode)properties.getOrDefault((Object)CACHE_MODE, (Object)null);
        this.timeService = (TimeService)properties.getOrDefault((Object)TIME_SERVICE, (Object)null);
        this.pendingPutsSimple = (Boolean)properties.getOrDefault((Object)PENDING_PUTS_SIMPLE, (Object)true);
    }

    protected EmbeddedCacheManager createCacheManager(ConfigurationBuilderHolder holder) {
        this.amendConfiguration(holder);
        DefaultCacheManager cacheManager = new DefaultCacheManager(holder, true);
        if (this.timeService != null) {
            cacheManager.getGlobalComponentRegistry().registerComponent((Object)this.timeService, TimeService.class);
            cacheManager.getGlobalComponentRegistry().rewire();
        }
        return cacheManager;
    }

    protected void amendConfiguration(ConfigurationBuilderHolder holder) {
        holder.getGlobalConfigurationBuilder().globalJmxStatistics().allowDuplicateDomains(Boolean.valueOf(true));
        TransportConfigurationBuilder transport = holder.getGlobalConfigurationBuilder().transport();
        transport.nodeName(TestResourceTracker.getNextNodeName());
        transport.clusterName(TestResourceTracker.getCurrentTestName());
        transport.remoteCommandThreadPool().threadPoolFactory((ThreadPoolExecutorFactory)CachedThreadPoolExecutorFactory.create());
        transport.transportThreadPool().threadPoolFactory((ThreadPoolExecutorFactory)CachedThreadPoolExecutorFactory.create());
        for (Map.Entry cfg : holder.getNamedConfigurationBuilders().entrySet()) {
            this.amendCacheConfiguration((String)cfg.getKey(), (ConfigurationBuilder)cfg.getValue());
        }
        if (!this.pendingPutsSimple) {
            ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("pending-puts")).simpleCache(false);
        }
    }

    protected void amendCacheConfiguration(String cacheName, ConfigurationBuilder configurationBuilder) {
        if (cacheName.equals("pending-puts")) {
            return;
        }
        if (this.transactional) {
            if (!(cacheName.endsWith("query") || cacheName.equals("timestamps") || cacheName.endsWith("pending-puts"))) {
                configurationBuilder.transaction().transactionMode(TransactionMode.TRANSACTIONAL).useSynchronization(true);
            }
        } else {
            configurationBuilder.transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL);
        }
        if (this.cacheMode != null && configurationBuilder.clustering().cacheMode().isInvalidation()) {
            configurationBuilder.clustering().cacheMode(this.cacheMode);
        }
    }

    public long nextTimestamp() {
        if (this.timeService == null) {
            return super.nextTimestamp();
        }
        return this.timeService.wallClockTime();
    }
}

