/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan.util;

import javax.transaction.Synchronization;
import org.hibernate.cache.spi.access.EntityRegionAccessStrategy;
import org.hibernate.cache.spi.access.RegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SharedSessionContractImplementor;

public abstract class TestSynchronization
implements Synchronization {
    protected final SharedSessionContractImplementor session;
    protected final Object key;
    protected final Object value;
    protected final Object version;

    public TestSynchronization(SharedSessionContractImplementor session, Object key, Object value, Object version) {
        this.session = session;
        this.key = key;
        this.value = value;
        this.version = version;
    }

    public void beforeCompletion() {
    }

    public static class UnlockItem
    extends TestSynchronization {
        private final RegionAccessStrategy strategy;
        private final SoftLock lock;

        public UnlockItem(RegionAccessStrategy strategy, SharedSessionContractImplementor session, Object key, SoftLock lock) {
            super(session, key, null, null);
            this.strategy = strategy;
            this.lock = lock;
        }

        public void afterCompletion(int status) {
            this.strategy.unlockItem(this.session, this.key, this.lock);
        }
    }

    public static class AfterUpdate
    extends TestSynchronization {
        private final EntityRegionAccessStrategy strategy;
        private final SoftLock lock;

        public AfterUpdate(EntityRegionAccessStrategy strategy, SharedSessionContractImplementor session, Object key, Object value, Object version, SoftLock lock) {
            super(session, key, value, version);
            this.strategy = strategy;
            this.lock = lock;
        }

        public void afterCompletion(int status) {
            this.strategy.afterUpdate(this.session, this.key, this.value, this.version, null, this.lock);
        }
    }

    public static class AfterInsert
    extends TestSynchronization {
        private final EntityRegionAccessStrategy strategy;

        public AfterInsert(EntityRegionAccessStrategy strategy, SharedSessionContractImplementor session, Object key, Object value, Object version) {
            super(session, key, value, version);
            this.strategy = strategy;
        }

        public void afterCompletion(int status) {
            this.strategy.afterInsert(this.session, this.key, this.value, this.version);
        }
    }
}

