/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan.util;

import java.util.concurrent.Callable;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.hibernate.Session;
import org.hibernate.SessionBuilder;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cache.infinispan.util.Caches;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.resource.transaction.spi.TransactionStatus;

public final class TxUtil {
    public static void withTxSession(boolean useJta, SessionFactory sessionFactory, ThrowingConsumer<Session, Exception> consumer) throws Exception {
        JtaPlatform jtaPlatform = useJta ? (JtaPlatform)sessionFactory.getSessionFactoryOptions().getServiceRegistry().getService(JtaPlatform.class) : null;
        TxUtil.withTxSession(jtaPlatform, sessionFactory.withOptions(), consumer);
    }

    public static void withTxSession(JtaPlatform jtaPlatform, SessionBuilder sessionBuilder, ThrowingConsumer<Session, Exception> consumer) throws Exception {
        if (jtaPlatform != null) {
            TransactionManager tm = jtaPlatform.retrieveTransactionManager();
            SessionBuilder sb = sessionBuilder;
            Caches.withinTx((TransactionManager)tm, () -> {
                TxUtil.withSession(sb, s -> {
                    consumer.accept((Session)s);
                    s.flush();
                });
                return null;
            });
        } else {
            TxUtil.withSession(sessionBuilder, s -> TxUtil.withResourceLocalTx(s, consumer));
        }
    }

    public static <T> T withTxSessionApply(boolean useJta, SessionFactory sessionFactory, ThrowingFunction<Session, T, Exception> function) throws Exception {
        JtaPlatform jtaPlatform = useJta ? (JtaPlatform)sessionFactory.getSessionFactoryOptions().getServiceRegistry().getService(JtaPlatform.class) : null;
        return TxUtil.withTxSessionApply(jtaPlatform, sessionFactory.withOptions(), function);
    }

    public static <T> T withTxSessionApply(JtaPlatform jtaPlatform, SessionBuilder sessionBuilder, ThrowingFunction<Session, T, Exception> function) throws Exception {
        if (jtaPlatform != null) {
            TransactionManager tm = jtaPlatform.retrieveTransactionManager();
            Callable<Object> callable = () -> TxUtil.withSessionApply(sessionBuilder, s -> {
                Object t = function.apply((Session)s);
                s.flush();
                return t;
            });
            return (T)Caches.withinTx((TransactionManager)tm, callable);
        }
        return (T)TxUtil.withSessionApply(sessionBuilder, s -> TxUtil.withResourceLocalTx(s, function));
    }

    public static <E extends Throwable> void withSession(SessionBuilder sessionBuilder, ThrowingConsumer<Session, E> consumer) throws E {
        try (Session s = sessionBuilder.openSession();){
            consumer.accept(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R, E extends Throwable> R withSessionApply(SessionBuilder sessionBuilder, ThrowingFunction<Session, R, E> function) throws E {
        try (Session s = sessionBuilder.openSession();){
            R r = function.apply(s);
            return r;
        }
    }

    public static void withResourceLocalTx(Session session, ThrowingConsumer<Session, Exception> consumer) throws Exception {
        Transaction transaction = session.beginTransaction();
        boolean rollingBack = false;
        try {
            consumer.accept(session);
            if (transaction.getStatus() == TransactionStatus.ACTIVE) {
                transaction.commit();
            } else {
                rollingBack = true;
                transaction.rollback();
            }
        }
        catch (Exception e) {
            if (!rollingBack) {
                try {
                    transaction.rollback();
                }
                catch (Exception suppressed) {
                    e.addSuppressed(suppressed);
                }
            }
            throw e;
        }
    }

    public static <T> T withResourceLocalTx(Session session, ThrowingFunction<Session, T, Exception> consumer) throws Exception {
        Transaction transaction = session.beginTransaction();
        boolean rollingBack = false;
        try {
            T t = consumer.apply(session);
            if (transaction.getStatus() == TransactionStatus.ACTIVE) {
                transaction.commit();
            } else {
                rollingBack = true;
                transaction.rollback();
            }
            return t;
        }
        catch (Exception e) {
            if (!rollingBack) {
                try {
                    transaction.rollback();
                }
                catch (Exception suppressed) {
                    e.addSuppressed(suppressed);
                }
            }
            throw e;
        }
    }

    public static void markRollbackOnly(boolean useJta, Session s) {
        if (useJta) {
            JtaPlatform jtaPlatform = (JtaPlatform)s.getSessionFactory().getSessionFactoryOptions().getServiceRegistry().getService(JtaPlatform.class);
            TransactionManager tm = jtaPlatform.retrieveTransactionManager();
            try {
                tm.setRollbackOnly();
            }
            catch (SystemException e) {
                throw new RuntimeException(e);
            }
        } else {
            s.getTransaction().markRollbackOnly();
        }
    }

    public static interface ThrowingFunction<T, R, E extends Throwable> {
        public R apply(T var1) throws E;
    }

    public static interface ThrowingConsumer<T, E extends Throwable> {
        public void accept(T var1) throws E;
    }
}

