package com.recruitment;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;


/**
 * Entity implementation class for Entity: Registration
 *
 */
@Entity
@Table(name="Employer")
public class Employer implements Serializable {

/**
	 * 
	 */
private static final long serialVersionUID = 1L;
@Id
@GeneratedValue
private int id ;
@NotNull
private String firstname ;
@NotNull
private String lastname ;
private String company ;

@OneToMany(cascade=CascadeType.ALL)
@JoinColumn(name="employerid")
private Set<Employee> employees = new HashSet<Employee>();

public int getId() {
	return id;
}
public void setId(int id) {
	this.id = id;
}
public String getFirstname() {
	return firstname;
}
public void setFirstname(String firstname) {
	this.firstname = firstname;
}
public String getLastname() {
	return lastname;
}
public void setLastname(String lastname) {
	this.lastname = lastname;
}
public String getCompany() {
	return company;
}
public void setCompany(String company) {
	this.company = company;
}
public Set<Employee> getEmployees() {
    return employees;
}

}
