package com.recruitment;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.validation.Valid;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;



@Controller
public class EmployerController {
	
//private RegistrationServiceImpl registrationService;
	
private RecruitmentService recruitmentService;
	
	@Autowired(required=true)
	@Qualifier(value="recruitmentService")
	public void setRecruitmentService(RecruitmentService rs){
		this.recruitmentService = rs;
	}
	@RequestMapping(value="/addemployee", method=RequestMethod.POST)
	protected ModelAndView processEmployee(@ModelAttribute("employee") Employee employee,HttpSession session,BindingResult result,HttpServletRequest request,
		HttpServletResponse response) throws Exception {
        ModelAndView model = new ModelAndView();
            Employer employer = (Employer) session.getAttribute("employer");
        	//this.recruitmentService.insert(employer);
        	//System.out.println("Employer : " + employer + " added successfully");
            this.recruitmentService.insertEmployer(employer);
            employee.setEmployerid(employer.getId());
        	
        	this.recruitmentService.insertEmployee(employee);
        	System.out.println("Employee : " + employee + " added successfully");
        	model.setViewName("result");
        	//response.sendRedirect("http://58.179.16.247/digiherb/index.html");
        
		//model.addObject("msg", registration);
		
		return model;
	}
	@RequestMapping(value="/addemployeemodify", method=RequestMethod.POST)
	protected ModelAndView processEmployeeModify(@ModelAttribute("employee") Employee employee,HttpSession session,BindingResult result,HttpServletRequest request,
		HttpServletResponse response) throws Exception {
        ModelAndView model = new ModelAndView();
            Employer employer = (Employer) session.getAttribute("employer");
        	//this.recruitmentService.insert(employer);
        	//System.out.println("Employer : " + employer + " added successfully");
            this.recruitmentService.updateEmployer(employer);
            employee.setEmployerid(employer.getId());
        	
        	this.recruitmentService.insertEmployee(employee);
        	System.out.println("Employee : " + employee + " added successfully");
        	model.setViewName("result");
        	//response.sendRedirect("http://58.179.16.247/digiherb/index.html");
        
		//model.addObject("msg", registration);
		
		return model;
	}

	
	
	
	@RequestMapping(value="/add", method=RequestMethod.POST, params={"save","!addemployee"})
	protected ModelAndView processRecruitment(@Valid @ModelAttribute("employer") Employer employer,BindingResult result,HttpServletRequest request,
		HttpServletResponse response) throws Exception {
        ModelAndView model = new ModelAndView();
        	this.recruitmentService.insert(employer);
        	System.out.println("Employer : " + employer + " added successfully");
        	model.setViewName("result");
        	//response.sendRedirect("http://58.179.16.247/digiherb/index.html");
        
		//model.addObject("msg", registration);
		
		return model;
	}
	
	
	@RequestMapping(value="/empsearch", method=RequestMethod.POST, params={"search","!edit","!delete"})
	protected ModelAndView empSearch(@Valid @ModelAttribute("employer") Employer employer,BindingResult result,HttpServletRequest request,
		HttpServletResponse response,Model mod) throws Exception {
        //ModelAndView model = new ModelAndView();
		ModelAndView model = new ModelAndView("employersearch","employer",new Employer());
        List<Employer> employers = this.recruitmentService.getEmployers(employer.getFirstname());;
        mod.addAttribute("employers", employers);
        return model;
        
        
        
        
        	
	}
	@RequestMapping(value = "/form")
	public ModelAndView employer() {
        ModelAndView model = new ModelAndView("recruitment","employer",new Employer());
		//model.addObject("msg", registration);
		
		return model;
	}
	@RequestMapping(value = "/employerqueryform")
	public ModelAndView employerSearch(Model mod,Employer employer) {
        ModelAndView model = new ModelAndView("employersearch","employer",new Employer());
		//model.addObject("msg", registration);
        List<Employer> employers = this.recruitmentService.getEmployers("");
        if(employers.size() > 0){
        		mod.addAttribute("employers", employers);
       // return "employersList";
        }
		return model;
	}
	
	@RequestMapping(value = "/employeemodifyform")
	public ModelAndView employeeModifyForm(Model mod,HttpServletRequest request) {
        ModelAndView model = new ModelAndView("employeemodifyform","employee",new Employee());
		//model.addObject("msg", registration);
        int employeeid ;
        employeeid = Integer.parseInt(request.getParameter("id"));
        Employee employee = this.recruitmentService.getEmployee(employeeid);
        
        //mod.addAttribute("employer", employer);
        model.addObject("employee",employee);
        
       // return "employersList";
		return model;
	}
	
	@RequestMapping(value = "/employeremployeeform")
	public ModelAndView employerEmployeeQuery(Model mod,HttpServletRequest request) {
        ModelAndView model = new ModelAndView("employeremployeequery","employer",new Employer());
		//model.addObject("msg", registration);
        int employerid ;
        employerid = Integer.parseInt(request.getParameter("id"));
        Employer employer = this.recruitmentService.getEmployer(employerid);
        
        //mod.addAttribute("employer", employer);
        model.addObject("employer",employer);
        List<Employee> employees = this.recruitmentService.getEmployees(employerid);
        //if(employees.size() > 0 ){
        	mod.addAttribute("employees", employees);
        
        //}
        //System.out.println("Employer size is " +employer.size());
        //System.out.println("Employee size is " +employees.size());
       // return "employersList";
		return model;
	}
	
	
	@RequestMapping(value="/modify", method=RequestMethod.POST, params={"addemployee", "!save"})
	public ModelAndView modifyEmployee(@ModelAttribute("employer") Employer employer,HttpSession session){
	
			ModelAndView model = new ModelAndView("employeeaddmod","employee",new Employee());
		//model.addObject("msg", registrati
        Employee employee = new Employee() ;
        session.setAttribute("employer",employer);
        
        
        // employee.setEmployerid(employer.getId());
		return model;
	}
	
	@RequestMapping(value="/modify", method=RequestMethod.POST, params={"save","!addemployee"})
	protected ModelAndView updateRecruitment(@Valid @ModelAttribute("employer") Employer employer,BindingResult result,HttpServletRequest request,
		HttpServletResponse response) throws Exception {
        ModelAndView model = new ModelAndView();
        	this.recruitmentService.updateEmployer(employer);
        	System.out.println("Employer : " + employer + " added successfully");
        	model.setViewName("result");
        	//response.sendRedirect("http://58.179.16.247/digiherb/index.html");
        
		//model.addObject("msg", registration);
		
		return model;
	}
	@RequestMapping(value="/modifyemployee", method=RequestMethod.POST)
	protected ModelAndView updateRecruitment(@Valid @ModelAttribute("employee") Employee employee,BindingResult result,HttpServletRequest request,
		HttpServletResponse response) throws Exception {
        ModelAndView model = new ModelAndView();
        	this.recruitmentService.updateEmployee(employee);
        	System.out.println("Employee : " + employee + " added successfully");
        	model.setViewName("result");
        	//response.sendRedirect("http://58.179.16.247/digiherb/index.html");
        
		//model.addObject("msg", registration);
		
		return model;
	}
	
	@RequestMapping(value="/add", method=RequestMethod.POST, params={"addemployee", "!save"})
	public ModelAndView employee(@ModelAttribute("employer") Employer employer,HttpSession session){
	
			ModelAndView model = new ModelAndView("employeeadd","employee",new Employee());
		//model.addObject("msg", registrati
        Employee employee = new Employee() ;
        session.setAttribute("employer",employer);
        
        
        // employee.setEmployerid(employer.getId());
		return model;
	}

	protected ModelAndView handleRequestInternal(HttpServletRequest arg0, HttpServletResponse arg1) throws Exception {
		// TODO Auto-generated method stub
		return null;
	}
}